/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.interceptor;

import com.tn.lib.logger.MBLogger;
import com.tn.lib.util.networkinfo.NetworkUtil;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/tn/lib/net/interceptor/RetryInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "countinueFailCount", "", "retryMax", "lastFailTime", "", "TAG", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "doRequest", "request", "Lokhttp3/Request;", "lib_release"})
public final class RetryInterceptor
implements Interceptor {
    private int countinueFailCount;
    private int retryMax = 2;
    private long lastFailTime;
    @NotNull
    private final String TAG;

    public RetryInterceptor() {
        this.TAG = "RetryInterceptor";
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response = this.doRequest(chain, request);
        for (int tryCount = 0; response == null && tryCount < this.retryMax; ++tryCount) {
            if (!NetworkUtil.INSTANCE.hasCapabilityAsync()) {
                MBLogger.Companion.d$default((MBLogger.Companion)MBLogger.Companion, (String)this.TAG, (String)"no net", (boolean)false, (int)4, null);
                break;
            }
            response = this.doRequest(chain, request);
        }
        if (response == null) {
            throw new IOException();
        }
        return response;
    }

    private final Response doRequest(Interceptor.Chain chain, Request request) {
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            MBLogger.Companion.d$default((MBLogger.Companion)MBLogger.Companion, (String)this.TAG, (String)("doRequest exception " + e.getMessage()), (boolean)false, (int)4, null);
        }
        return response;
    }
}

