/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.interceptor.header;

import com.tn.lib.net.interceptor.header.HeaderHelper;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/tn/lib/net/interceptor/header/HeaderInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "TAG", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "updateHeaders", "Lokhttp3/Request;", "request", "generateClientRequest", "timeStamp", "lib_release"})
@SourceDebugExtension(value={"SMAP\nHeaderInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderInterceptor.kt\ncom/tn/lib/net/interceptor/header/HeaderInterceptor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,45:1\n216#2,2:46\n*S KotlinDebug\n*F\n+ 1 HeaderInterceptor.kt\ncom/tn/lib/net/interceptor/header/HeaderInterceptor\n*L\n27#1:46,2\n*E\n"})
public final class HeaderInterceptor
implements Interceptor {
    @NotNull
    private final String TAG;

    public HeaderInterceptor() {
        this.TAG = "HeaderInterceptor";
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Request dynamicHeaderRequest = this.updateHeaders(request);
        Request newRequest = this.generateClientRequest(dynamicHeaderRequest, "");
        return chain.proceed(newRequest);
    }

    private final Request updateHeaders(Request request) {
        Map<String, String> headers = HeaderHelper.Companion.getHeaders();
        if (headers.isEmpty()) {
            return request;
        }
        Request.Builder builder = request.newBuilder();
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            builder.header(key, value);
        }
        return builder.build();
    }

    private final Request generateClientRequest(Request request, String timeStamp) {
        String client = HeaderHelper.Companion.builderCommonHeaderJson();
        Request.Builder requestBuilder = request.newBuilder();
        requestBuilder.addHeader("X-Client-Info", client);
        Boolean appBackground = HeaderHelper.Companion.getAppBackground();
        requestBuilder.addHeader("X-Client-Status", String.valueOf(Intrinsics.areEqual((Object)appBackground, (Object)true) ? 0 : 1));
        return requestBuilder.build();
    }
}

