/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.interceptor.signature;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsonBodyToMapHelper {
    private static JsonBodyToMapHelper sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonBodyToMapHelper getInstance() {
        if (sInstance != null) return sInstance;
        Class<JsonBodyToMapHelper> clazz = JsonBodyToMapHelper.class;
        synchronized (JsonBodyToMapHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new JsonBodyToMapHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private JsonBodyToMapHelper() {
    }

    public Map<String, String> toMap(String json) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = null;
        try {
            jsonElement = parser.parse(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (jsonElement != null) {
            if (jsonElement.isJsonArray()) {
                JsonArray jsonArray = (JsonArray)jsonElement;
                this.putArrayToMap(jsonArray, resultMap);
            } else if (jsonElement.isJsonObject()) {
                this.putObjectToMap((JsonObject)jsonElement, resultMap);
            }
        }
        return resultMap;
    }

    private void putArrayToMap(JsonArray jsonArray, Map<String, String> outMap) {
        int size = jsonArray.size();
        if (size == 1) {
            JsonObject jsonObject = jsonArray.get(0).getAsJsonObject();
            this.putObjectToMap(jsonObject, outMap);
        } else if (size > 1) {
            this.mergeArrayToMap(jsonArray, outMap);
        }
    }

    private void mergeArrayToMap(JsonArray jsonArray, Map<String, String> outMap) {
        int size = jsonArray.size();
        HashMap<String, ArrayList<String>> mergeMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < size; ++i) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            Map<String, String> singleObjectMap = this.jsonToMap(jsonObject);
            Set<String> keySet = singleObjectMap.keySet();
            for (String key : keySet) {
                ArrayList<String> values = (ArrayList<String>)mergeMap.get(key);
                if (values == null) {
                    values = new ArrayList<String>(2);
                    mergeMap.put(key, values);
                }
                values.add(singleObjectMap.get(key));
            }
        }
        Set keySet = mergeMap.keySet();
        Gson gson = new Gson();
        for (String key : keySet) {
            List values = (List)mergeMap.get(key);
            outMap.put(key, gson.toJson((Object)values));
        }
    }

    private void putObjectToMap(JsonObject jsonObject, Map<String, String> outMap) {
        outMap.putAll(this.jsonToMap(jsonObject));
    }

    private Map<String, String> jsonToMap(JsonObject jsonObject) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Set keySet = jsonObject.keySet();
        for (String key : keySet) {
            JsonElement jsonElement = jsonObject.get(key);
            if (jsonElement instanceof JsonPrimitive && ((JsonPrimitive)jsonElement).isString()) {
                resultMap.put(key, jsonElement.getAsString());
                continue;
            }
            resultMap.put(key, jsonElement.toString());
        }
        return resultMap;
    }
}

