/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.manager;

import android.content.Context;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import com.google.net.cronet.okhttptransport.CronetInterceptor;
import com.tn.lib.net.Http;
import com.tn.lib.net.annotatioProcess.AnnotationDataManager;
import com.tn.lib.net.annotatioProcess.RetryAnnoProcess;
import com.tn.lib.net.annotation.IRequestApi;
import com.tn.lib.net.annotation.InterfaceType;
import com.tn.lib.net.annotation.RETRY;
import com.tn.lib.net.convert.FastJsonConverterFactory;
import com.tn.lib.net.dns.or.CacheIpPool;
import com.tn.lib.net.env.Host;
import com.tn.lib.net.interceptor.BaseUrlInterceptor;
import com.tn.lib.net.interceptor.DynamicHostInterceptor;
import com.tn.lib.net.interceptor.HttpLogInterceptor;
import com.tn.lib.net.interceptor.HttpLoggingInterceptor;
import com.tn.lib.net.interceptor.InterceptorsManager;
import com.tn.lib.net.interceptor.header.HeaderFactory;
import com.tn.lib.net.ssl.HttpsTrustManager;
import com.transsion.api.gateway.interceptor.GatewayInterceptor;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.chromium.net.CronetEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.http.GET;
import retrofit2.http.POST;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\b\r\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\u0007H\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001f\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007J\u001b\u0010\u0015\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J!\u0010 \u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010&\u001a\u0004\u0018\u00010\u0007J\n\u0010'\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lcom/tn/lib/net/manager/NetServiceGenerator;", "", "<init>", "()V", "TAG", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "retrofit", "Lretrofit2/Retrofit;", "threadCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "newOkhttpClient", "getCronetInterceptor", "Lokhttp3/Interceptor;", "getService", "T", "service", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getHttpClient", "agent", "newApi", "Lcom/tn/lib/net/annotation/IRequestApi;", "(Lcom/tn/lib/net/annotation/IRequestApi;)Ljava/lang/Object;", "parseMethodAnnotation", "", "annotation", "", "url", "getMethodUrl", "resetAnnotation", "generateDefaultRetrofit", "okHttpClientForGlide", "getOkHttpClientForGlide", "()Lokhttp3/OkHttpClient;", "setOkHttpClientForGlide", "(Lokhttp3/OkHttpClient;)V", "newGlideOkhttpClient", "getCronetInterceptorForGlide", "Companion", "lib_release"})
@SourceDebugExtension(value={"SMAP\nNetServiceGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetServiceGenerator.kt\ncom/tn/lib/net/manager/NetServiceGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,277:1\n1869#2,2:278\n13472#3,2:280\n13472#3,2:282\n*S KotlinDebug\n*F\n+ 1 NetServiceGenerator.kt\ncom/tn/lib/net/manager/NetServiceGenerator\n*L\n105#1:278,2\n180#1:280,2\n184#1:282,2\n*E\n"})
public final class NetServiceGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String TAG;
    @Nullable
    private OkHttpClient okHttpClient;
    @Nullable
    private Retrofit retrofit;
    @NotNull
    private final AtomicInteger threadCounter = new AtomicInteger(1);
    @Nullable
    private OkHttpClient okHttpClientForGlide;
    @NotNull
    private static final Lazy<NetServiceGenerator> instance$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, NetServiceGenerator::instance_delegate$lambda$6);
    @NotNull
    private static final String HTTP_THREAD_NAME = "one_room_net_thread";

    public NetServiceGenerator() {
        this.TAG = "NetServiceGenerator";
        CacheIpPool.INSTANCE.getCacheUrlList();
        this.okHttpClient = this.newOkhttpClient();
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(Host.Companion.getHost());
        OkHttpClient okHttpClient = this.okHttpClient;
        Intrinsics.checkNotNull((Object)okHttpClient);
        this.retrofit = builder.client(okHttpClient).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.from((Executor)Executors.newFixedThreadPool(6, arg_0 -> NetServiceGenerator._init_$lambda$1(this, arg_0))))).build();
    }

    private final OkHttpClient newOkhttpClient() {
        HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor(new HttpLogInterceptor());
        logInterceptor.level(HttpLoggingInterceptor.Level.BODY);
        java.net.Proxy proxy = Http.Companion.isDebug() ? null : java.net.Proxy.NO_PROXY;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        SSLSocketFactory sSLSocketFactory = HttpsTrustManager.createSSLSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"createSSLSocketFactory(...)");
        builder.sslSocketFactory(sSLSocketFactory, (X509TrustManager)new HttpsTrustManager()).hostnameVerifier((HostnameVerifier)new HttpsTrustManager.TrustAllHostnameVerifier());
        builder.proxy(proxy).connectTimeout(40L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).callTimeout(40L, TimeUnit.SECONDS).addInterceptor(HeaderFactory.Companion.createHttpHeader()).addInterceptor((Interceptor)new DynamicHostInterceptor()).addInterceptor((Interceptor)new GatewayInterceptor()).addInterceptor((Interceptor)new BaseUrlInterceptor());
        Iterable $this$forEach$iv = InterceptorsManager.INSTANCE.getInterceptorsList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Interceptor interceptor = (Interceptor)element$iv;
            boolean bl = false;
            builder.addInterceptor(interceptor);
        }
        OkHttpClient.Builder instance = builder.addInterceptor((Interceptor)logInterceptor);
        Interceptor cronetInterceptor = this.getCronetInterceptor();
        if (cronetInterceptor != null) {
            instance.addInterceptor(cronetInterceptor);
        }
        return instance.build();
    }

    private final Interceptor getCronetInterceptor() {
        try {
            CronetEngine.Builder builder = new CronetEngine.Builder((Context)Utils.getApp());
            builder.enableQuic(true).enableBrotli(true).addQuicHint("api3.aoneroom.com", 443, 443).addQuicHint("api4.aoneroom.com", 443, 443).addQuicHint("api4sg.aoneroom.com", 443, 443).addQuicHint("api5.aoneroom.com", 443, 443).addQuicHint("api6.aoneroom.com", 443, 443).addQuicHint(" api7.aoneroom.com ", 443, 443).addQuicHint(" api8.aoneroom.com", 443, 443).addQuicHint("api6sg.aoneroom.com", 443, 443).addQuicHint("api.inmoviebox.com", 443, 443).addQuicHint("test-mse-api.aoneroom.com", 443, 443);
            CronetEngine cronetEngine = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)cronetEngine, (String)"build(...)");
            CronetEngine cronetEngine2 = cronetEngine;
            return (Interceptor)CronetInterceptor.newBuilder((CronetEngine)cronetEngine2).build();
        }
        catch (Throwable e) {
            Log.e((String)"error", (String)("e " + e.getMessage()));
            return null;
        }
    }

    public final <T> T getService(@NotNull Class<T> service) {
        Intrinsics.checkNotNullParameter(service, (String)"service");
        Object object = this.retrofit;
        if (object == null || (object = object.create(service)) == null) {
            object = this.generateDefaultRetrofit(service);
        }
        Object api = object;
        try {
            this.resetAnnotation();
            if (api instanceof IRequestApi) {
                return this.agent((IRequestApi)api);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return (T)api;
        }
        return (T)api;
    }

    @Nullable
    public final OkHttpClient getHttpClient() {
        return this.okHttpClient;
    }

    private final <T> T agent(IRequestApi newApi) {
        Object proxy = Proxy.newProxyInstance(newApi.getClass().getClassLoader(), newApi.getClass().getInterfaces(), (arg_0, arg_1, arg_2) -> NetServiceGenerator.agent$lambda$5(newApi, this, arg_0, arg_1, arg_2));
        return (T)proxy;
    }

    private final void parseMethodAnnotation(Annotation annotation, String url) {
        Annotation annotation2 = annotation;
        if (annotation2 instanceof RETRY) {
            RetryAnnoProcess.INSTANCE.setRetryMaxNum(((RETRY)annotation).retryCount());
            RetryAnnoProcess.INSTANCE.setRetryTimestamp(((RETRY)annotation).timestamp());
        } else if (annotation2 instanceof InterfaceType) {
            AnnotationDataManager.INSTANCE.setType(url, ((InterfaceType)annotation).type());
        }
    }

    private final String getMethodUrl(Annotation annotation) {
        String url = "";
        if (annotation instanceof GET) {
            url = ((GET)annotation).value();
        } else if (annotation instanceof POST) {
            url = ((POST)annotation).value();
        }
        return url;
    }

    private final void resetAnnotation() {
        RetryAnnoProcess.INSTANCE.setRetryMaxNum(0);
        RetryAnnoProcess.INSTANCE.setRetryTimestamp(0L);
    }

    private final <T> T generateDefaultRetrofit(Class<T> service) {
        return (T)new Retrofit.Builder().build().create(service);
    }

    @Nullable
    public final OkHttpClient getOkHttpClientForGlide() {
        return this.okHttpClientForGlide;
    }

    public final void setOkHttpClientForGlide(@Nullable OkHttpClient okHttpClient) {
        this.okHttpClientForGlide = okHttpClient;
    }

    @Nullable
    public final OkHttpClient newGlideOkhttpClient() {
        if (this.okHttpClientForGlide != null) {
            return this.okHttpClientForGlide;
        }
        HttpLogInterceptor loginInterceptor = new HttpLogInterceptor();
        loginInterceptor.replaceTag("HttpLogInterceptor_glide");
        HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor(loginInterceptor);
        logInterceptor.level(HttpLoggingInterceptor.Level.BASIC);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        SSLSocketFactory sSLSocketFactory = HttpsTrustManager.createSSLSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"createSSLSocketFactory(...)");
        builder.sslSocketFactory(sSLSocketFactory, (X509TrustManager)new HttpsTrustManager()).hostnameVerifier((HostnameVerifier)new HttpsTrustManager.TrustAllHostnameVerifier());
        OkHttpClient.Builder instance = builder.connectTimeout(40L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).addInterceptor((Interceptor)logInterceptor);
        Interceptor cronetInterceptor = this.getCronetInterceptorForGlide();
        if (cronetInterceptor != null) {
            instance.addInterceptor(cronetInterceptor);
        }
        this.okHttpClientForGlide = instance.build();
        return this.okHttpClientForGlide;
    }

    private final Interceptor getCronetInterceptorForGlide() {
        try {
            CronetEngine.Builder builder = new CronetEngine.Builder((Context)Utils.getApp());
            builder.enableQuic(true).enableBrotli(true).addQuicHint("pacdn.aoneroom.com", 443, 443);
            CronetEngine cronetEngine = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)cronetEngine, (String)"build(...)");
            CronetEngine cronetEngine2 = cronetEngine;
            return (Interceptor)CronetInterceptor.newBuilder((CronetEngine)cronetEngine2).build();
        }
        catch (Throwable e) {
            Log.e((String)"error", (String)("e " + e.getMessage()));
            return null;
        }
    }

    private static final Thread _init_$lambda$1(NetServiceGenerator this$0, Runnable r) {
        Thread thread;
        Thread $this$lambda_u241_u24lambda_u240 = thread = new Thread(r, HTTP_THREAD_NAME + "-" + this$0.threadCounter.incrementAndGet());
        boolean bl = false;
        $this$lambda_u241_u24lambda_u240.setPriority(10);
        return thread;
    }

    private static final Object agent$lambda$5(IRequestApi $newApi, NetServiceGenerator this$0, Object proxy, Method method, Object[] args) {
        Annotation it;
        Annotation element$iv;
        int n;
        Annotation[] annotations = method.getAnnotations();
        String url = null;
        url = "";
        Intrinsics.checkNotNull((Object)annotations);
        Annotation[] $this$forEach$iv = annotations;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            url = this$0.getMethodUrl(it);
        }
        $this$forEach$iv = annotations;
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this$0.parseMethodAnnotation(it, url);
        }
        return method.invoke((Object)$newApi, Arrays.copyOf(args, args.length));
    }

    private static final NetServiceGenerator instance_delegate$lambda$6() {
        return new NetServiceGenerator();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/tn/lib/net/manager/NetServiceGenerator$Companion;", "", "<init>", "()V", "instance", "Lcom/tn/lib/net/manager/NetServiceGenerator;", "getInstance", "()Lcom/tn/lib/net/manager/NetServiceGenerator;", "instance$delegate", "Lkotlin/Lazy;", "HTTP_THREAD_NAME", "", "getHTTP_THREAD_NAME", "()Ljava/lang/String;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NetServiceGenerator getInstance() {
            Lazy lazy = instance$delegate;
            return (NetServiceGenerator)lazy.getValue();
        }

        @NotNull
        public final String getHTTP_THREAD_NAME() {
            return HTTP_THREAD_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

