/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/tn/lib/net/utils/InetUtil;", "", "<init>", "()V", "NETWORK_OFFLINE", "", "NETWORK_NONE", "NETWORK_WIFI", "NETWORK_2G", "NETWORK_3G", "NETWORK_4G", "NETWORK_MOBILE", "lastNetType", "getLastNetType", "()Ljava/lang/String;", "setLastNetType", "(Ljava/lang/String;)V", "getNetworkType", "context", "Landroid/content/Context;", "lib_release"})
public final class InetUtil {
    @NotNull
    public static final InetUtil INSTANCE = new InetUtil();
    @NotNull
    public static final String NETWORK_OFFLINE = "offline";
    @NotNull
    public static final String NETWORK_NONE = "none";
    @NotNull
    public static final String NETWORK_WIFI = "Wifi";
    @NotNull
    public static final String NETWORK_2G = "2G";
    @NotNull
    public static final String NETWORK_3G = "3G";
    @NotNull
    public static final String NETWORK_4G = "4G";
    @NotNull
    public static final String NETWORK_MOBILE = "mobile";
    @NotNull
    private static String lastNetType = "none";

    private InetUtil() {
    }

    @NotNull
    public final String getLastNetType() {
        return lastNetType;
    }

    public final void setLastNetType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        lastNetType = string;
    }

    @NotNull
    public final String getNetworkType(@Nullable Context context) {
        try {
            NetworkInfo.State state;
            Context context2 = context;
            Object object = context2 != null ? context2.getSystemService("connectivity") : null;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            ConnectivityManager connManager = (ConnectivityManager)object;
            NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
            if (activeNetInfo == null) {
                return NETWORK_NONE;
            }
            if (!activeNetInfo.isAvailable()) {
                return NETWORK_OFFLINE;
            }
            NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
            if (wifiInfo != null && (state = wifiInfo.getState()) != null && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
                return NETWORK_WIFI;
            }
            NetworkInfo networkInfo = connManager.getNetworkInfo(0);
            if (networkInfo != null) {
                NetworkInfo.State state2 = networkInfo.getState();
                String subTypeName = networkInfo.getSubtypeName();
                if (state2 != null && (state2 == NetworkInfo.State.CONNECTED || state2 == NetworkInfo.State.CONNECTING)) {
                    return switch (activeNetInfo.getSubtype()) {
                        case 1, 2, 4, 7, 11 -> NETWORK_2G;
                        case 3, 5, 6, 8, 9, 10, 12, 14, 15 -> NETWORK_3G;
                        case 13 -> NETWORK_4G;
                        default -> StringsKt.equals((String)subTypeName, (String)"TD-SCDMA", (boolean)true) || StringsKt.equals((String)subTypeName, (String)"WCDMA", (boolean)true) || StringsKt.equals((String)subTypeName, (String)"CDMA2000", (boolean)true) ? NETWORK_3G : NETWORK_MOBILE;
                    };
                }
            }
            return NETWORK_NONE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return lastNetType;
        }
    }
}

