package com.transsion.player

import com.aliyun.player.bean.ErrorInfo
import com.aliyun.player.bean.InfoBean

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2022/8/7 15:12
 *
 *   Desc: 参考阿里云
 *   https://help.aliyun.com/document_detail/311525.htm?spm=a2c4g.11186623.0.0.50af125dVOds89#task-2104111
 */
interface PlayerListener {

    fun onPrepared(){}

    fun onError(var1: ErrorInfo?){}

    fun onCompletion(){}

    fun onLoadingBegin(){}

    fun onLoadingProgress(var1: Int, var2: Float){}

    fun onLoadingEnd(){}

    fun onInfo(var1: InfoBean?){}

    fun onStateChanged(var1: Int){}

    fun onStop(){}

    /**
     * 暂停回调
     */
    fun onPause(){}

    /**
     * 开始回调
     */
    fun onStart(){}



}