package com.transsion.player.mediasession

import android.app.PendingIntent
import android.content.Intent
import android.os.Bundle
import android.support.v4.media.MediaBrowserCompat
import android.support.v4.media.session.MediaSessionCompat
import android.support.v4.media.session.PlaybackStateCompat
import androidx.media.MediaBrowserServiceCompat

/**
 * @author xinbing.zhang
 * @date :2023/9/21 19:17
 * @description: 媒体播放器框架
 * MediaBrowserServiceCompat（服务端）：
 */
class MediaService : MediaBrowserServiceCompat() {

    companion object {

        /**
         * 暂时不需要这两个按钮,需要的时候在放开
         * or PlaybackStateCompat.ACTION_SKIP_TO_PREVIOUS
         * PlaybackStateCompat.ACTION_SKIP_TO_NEXT or
         */
        const val PLAY_BACK_STATE_COMPAT_ACTIONS =
            PlaybackStateCompat.ACTION_PAUSE or PlaybackStateCompat.ACTION_PLAY or PlaybackStateCompat.ACTION_SEEK_TO or PlaybackStateCompat.ACTION_PLAY_PAUSE or PlaybackStateCompat.ACTION_STOP

        /*** 一个唯一标识*/
        const val ROOT_ID = "media_service_id"
    }

    private fun getTagClass(): String = javaClass.simpleName


    // =============================================================================================


    override fun onCreate() {
        super.onCreate()
        SessionLogger.log("${getTagClass()} --> onCreate()")

        // 创建渠道
        MediaNotification.initNotificationChannel()

        // 初始化媒体框架
        initMediaSessionCompat()
    }

    /**
     * onGetRoot（）控制对服务的访问：
     *
     *
     * 之前提到过，在客户端声明MediaBrowserCompat的时候，向服务端发起了初次连接请求。
     * 此时，服务端会在onGetRoot方法中收到请求，此时返回一个rootId就好了，如果方法返回null，则拒绝连接。
     */
    override fun onGetRoot(
        clientPackageName: String, clientUid: Int, rootHints: Bundle?
    ): BrowserRoot {
        return BrowserRoot(ROOT_ID, null)
    }

    /**
     * onLoadChildren（）与客户端通信：
     *
     *
     * 接着在onLoadChildren方法中，服务端会接收来自客户端的不同请求，此时需要通过客户端发送过来的parentMediaId，
     * 服务端根据parentMediaId来返回不同的结果给客户端。
     */
    override fun onLoadChildren(
        parentId: String, result: Result<List<MediaBrowserCompat.MediaItem>>
    ) {
        result.sendResult(null)
    }

    override fun onDestroy() {
        super.onDestroy()
        SessionLogger.logE("${getTagClass()} --> onDestroy() --> 服务销毁的时候停止通知")
    }


    // =============================================================================================


    /**
     * 初始化 MediaSessionCompat 媒体框架
     */
    private fun initMediaSessionCompat() {
        kotlin.runCatching {
            val mediaSession = MediaSessionCompat(this@MediaService, ROOT_ID)
            mediaSession.let {
                it.isActive = true
                val playbackState = PlaybackStateCompat.Builder() //这里指定可以接收的来自锁屏页面的按键信息
                    .setActions(PLAY_BACK_STATE_COMPAT_ACTIONS).build()
                it.setPlaybackState(playbackState)
                it.setCallback(MediaMediaSessionCompatCallBack(it, this@MediaService))
                sessionToken = it.sessionToken

                // 给按钮设置点击事件意图 --> 创建通知点击事件处理的广播 --> 交给 MediaSessionCompat 进行处理
                val pendingIntent = PendingIntent.getBroadcast(
                    this,
                    1,
                    Intent(this, MusicIntentReceiver::class.java),
                    MediaNotification.getFlag()
                )
                it.setMediaButtonReceiver(pendingIntent)
            }
        }.getOrElse {
            SessionLogger.logE("${getTagClass()} --> initMediaSessionCompat() --> it = $it")
        }
    }
}