package com.transsion.player.orplayer.global

import com.transsion.player.MediaSource
import com.transsion.player.orplayer.PlayError

/**
 * @FileName:    播放失败拦截-切换播放器
 * @Author:      kun.xu
 * @Date:        2024/6/26 10:03
 * @Description: 阿里失败且exo，exo失败切阿里。失败只会切1次
 */
interface TnErrorInterceptorListener {
 /**
  * 视频失败了，通知外部，切换播放器
  */
 fun onPlayError(playerType: TnPlayerType, errorInfo: PlayError, mediaSource: MediaSource? = null): Boolean

 /**
  * 失败准备好了，通知外部播放seek到对应位置
  * 正常只针对播放到中间失败，有播放进度的需要seek
  */
 fun onPrepare(mediaSource: MediaSource? = null): Boolean
}