package com.transsion.player.ui

import com.transsion.player.MediaSource
import com.transsion.player.enum.PipStatus
import com.transsion.player.enum.ScaleMode
import com.transsion.player.orplayer.IPlayerListener
import com.transsion.player.tracks.TnFormat
import com.transsion.player.tracks.TnTracksGroup

/**
 *
 * Created by kun.xu on 2024/11/14 10:15
 * Description:
 *
 */
interface IORVideoView {
    //播放器相关-set
    fun setMediaData(data: MediaSource)//第一步，设置播放信息
    fun prepare()//第二步，播放准备
    fun play()//第三步，播放视频
    fun pause()//暂停播放
    fun addPlayerListener(listener: IPlayerListener)//添加监听
    fun removePayerListener(listener: IPlayerListener)//移除监听
    fun seekTo(mills: Long)//指定进度
    fun setSpeed(speed: Float)//设置倍速-看播放器支持
    fun reset()//重置播放器-不是回收只是重置，方便剧集播下一个视频
    fun release()//回收-这里就不再可用，需要重新创建
    fun release(id: String?) = Unit
    fun clearScreen()//清除屏幕-默写场景下会有残影，reset前需要清除
    fun setLooping(isLoop: Boolean)
    fun setScaleMode(scaleMode: ScaleMode)
    fun setVolume(volume: Float)//设置音量，只能0-1范围
    fun setMute(mute: Boolean)//设置静音
    fun enableHardwareDecoder(enable: Boolean = true)//true：硬解，false：软解

    fun changeTrackSelection(mediaTrackGroup: TnTracksGroup, index: Int) = Unit

    //播放器相关-get
    fun getMediaData(): MediaSource?
    fun getDuration(): Long//视频总时长
    fun getPosition(): Long//当前播放进度
    fun isPlaying(): Boolean//当前是否在播放
    fun isComplete(): Boolean//是否播放完成
    fun isMute(): Boolean
    fun isBuffering(): Boolean
    fun getVideoWidth(): Int
    fun getVideoHeight(): Int
    fun isPrepared(): Boolean

    fun getVideoFormat(): TnFormat?

    //视频view相关
    fun isLand(): Boolean
    fun isFullscreen(): Boolean
    fun changeFullscreen(fullscreen: Boolean, land: Boolean)//横竖屏切换
    fun pipChangeFullscreen(pipStatus: PipStatus)//进入系统画中画，添加到全屏上
    fun setPipStatus(pipStatus: PipStatus)
    fun getCurPipStatus(): PipStatus
}