package com.transsion.player.utils

import android.app.Activity
import android.util.Log
import android.view.Surface
import android.view.View
import com.blankj.utilcode.util.BarUtils

/**
 *
 * Created by kun.xu on 2024/11/20 10:39
 * Description:
 * 播放器横屏下适配状态栏留白
 *
 */
class LandSpaceHelper(private val startView: View, private val endView: View) {

    private var curIsLand = false

    fun onScreenChange(isLand: Boolean) {
        curIsLand = isLand
        val rotation = if (isLand) Surface.ROTATION_90 else Surface.ROTATION_0
        setSpace(isLand, rotation)
    }

    fun enable() {
        orientationEventListener?.enable()
    }

    fun disable() {
        orientationEventListener?.disable()
    }

    private val orientationEventListener: PlayerOrientationEventListener? by lazy {
        PlayerOrientationEventListener((startView.context as Activity)) { rotation ->
            //切回到竖屏也要恢复边距
            if (rotation == Surface.ROTATION_0 || rotation == Surface.ROTATION_90 || rotation == Surface.ROTATION_270) {
                setSpace(curIsLand, rotation)
            }
        }
    }

    private fun setSpace(isLand: Boolean, rotation: Int) {
        val space = BarUtils.getStatusBarHeight()
        val spaceStart = if (isLand) {
            if (rotation == Surface.ROTATION_90) space else 0
        } else 0
        val spaceEnd = if (isLand) {
            if (rotation == Surface.ROTATION_270) space else 0
        } else 0
        val lpStart = startView.layoutParams
        lpStart.width = spaceStart
        startView.layoutParams = lpStart
        val lpEnd = endView.layoutParams
        lpEnd.width = spaceEnd
        endView.layoutParams = lpEnd
    }

}