/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.exo;

import android.content.Context;
import android.os.Handler;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.decoder.av1.Libgav1VideoRenderer;
import androidx.media3.exoplayer.DefaultRenderersFactory;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.audio.AudioRendererEventListener;
import androidx.media3.exoplayer.audio.AudioSink;
import androidx.media3.exoplayer.audio.DefaultAudioSink;
import androidx.media3.exoplayer.mediacodec.MediaCodecSelector;
import androidx.media3.exoplayer.video.DecoderVideoRenderer;
import androidx.media3.exoplayer.video.VideoRendererEventListener;
import com.transsion.player.exo.ORExoDecoderType;
import com.transsion.player.exo.ORRenderersFactory;
import com.transsion.player.exo.SonicAudioProcessor;
import com.transsion.player.utils.ORPlayerLog;
import io.github.anilbeesetti.nextlib.media3ext.ffdecoder.FfmpegAudioRenderer;
import io.github.anilbeesetti.nextlib.media3ext.ffdecoder.FfmpegVideoRenderer;
import java.util.ArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JX\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eH\u0014J \u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014H\u0014JX\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eH\u0014J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lcom/transsion/player/exo/ORRenderersFactory;", "Landroidx/media3/exoplayer/DefaultRenderersFactory;", "context", "Landroid/content/Context;", "videoRendererType", "Lcom/transsion/player/exo/ORExoDecoderType;", "(Landroid/content/Context;Lcom/transsion/player/exo/ORExoDecoderType;)V", "volumeAudioProcessor", "Lcom/transsion/player/exo/SonicAudioProcessor;", "getVolumeAudioProcessor", "()Lcom/transsion/player/exo/SonicAudioProcessor;", "volumeAudioProcessor$delegate", "Lkotlin/Lazy;", "buildAudioRenderers", "", "extensionRendererMode", "", "mediaCodecSelector", "Landroidx/media3/exoplayer/mediacodec/MediaCodecSelector;", "enableDecoderFallback", "", "audioSink", "Landroidx/media3/exoplayer/audio/AudioSink;", "eventHandler", "Landroid/os/Handler;", "eventListener", "Landroidx/media3/exoplayer/audio/AudioRendererEventListener;", "out", "Ljava/util/ArrayList;", "Landroidx/media3/exoplayer/Renderer;", "Lkotlin/collections/ArrayList;", "buildAudioSink", "enableFloatOutput", "enableAudioTrackPlaybackParams", "buildVideoRenderers", "Landroidx/media3/exoplayer/video/VideoRendererEventListener;", "allowedVideoJoiningTimeMs", "", "setVolume", "volume", "", "Companion", "Player_release"})
@UnstableApi
public final class ORRenderersFactory
extends DefaultRenderersFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ORExoDecoderType videoRendererType;
    @NotNull
    private final Lazy volumeAudioProcessor$delegate;
    @NotNull
    public static final String TAG = "ORRenderersFactory";

    public ORRenderersFactory(@NotNull Context context2, @NotNull ORExoDecoderType videoRendererType) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)videoRendererType), (String)"videoRendererType");
        super(context2);
        this.videoRendererType = videoRendererType;
        this.volumeAudioProcessor$delegate = LazyKt.lazy((Function0)volumeAudioProcessor.2.INSTANCE);
    }

    private final SonicAudioProcessor getVolumeAudioProcessor() {
        Lazy lazy = this.volumeAudioProcessor$delegate;
        return (SonicAudioProcessor)lazy.getValue();
    }

    protected void buildAudioRenderers(@NotNull Context context2, int extensionRendererMode, @NotNull MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, @NotNull AudioSink audioSink, @NotNull Handler eventHandler, @NotNull AudioRendererEventListener eventListener, @NotNull ArrayList<Renderer> out) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaCodecSelector, (String)"mediaCodecSelector");
        Intrinsics.checkNotNullParameter((Object)audioSink, (String)"audioSink");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        Intrinsics.checkNotNullParameter(out, (String)"out");
        super.buildAudioRenderers(context2, extensionRendererMode, mediaCodecSelector, enableDecoderFallback, audioSink, eventHandler, eventListener, out);
        ORPlayerLog.INSTANCE.i(TAG, "buildAudioRenderers, mode:" + extensionRendererMode, true);
        if (extensionRendererMode == 0) {
            return;
        }
        int extensionRendererIndex = out.size();
        if (extensionRendererMode == 2) {
            --extensionRendererIndex;
        }
        try {
            FfmpegAudioRenderer renderer = new FfmpegAudioRenderer(eventHandler, eventListener, audioSink);
            out.add(extensionRendererIndex, (Renderer)renderer);
            ORPlayerLog.INSTANCE.i(TAG, "Loaded FfmpegAudioRenderer.", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ORPlayerLog.INSTANCE.e(TAG, "Error instantiating Ffmpeg extension :" + e, true);
        }
    }

    @NotNull
    protected AudioSink buildAudioSink(@NotNull Context context2, boolean enableFloatOutput, boolean enableAudioTrackPlaybackParams) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        SonicAudioProcessor[] sonicAudioProcessorArray = new SonicAudioProcessor[]{this.getVolumeAudioProcessor()};
        DefaultAudioSink defaultAudioSink = new DefaultAudioSink.Builder(context2).setEnableFloatOutput(enableFloatOutput).setEnableAudioTrackPlaybackParams(enableAudioTrackPlaybackParams).setAudioProcessors((AudioProcessor[])sonicAudioProcessorArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)defaultAudioSink, (String)"Builder(context)\n       \u2026or))\n            .build()");
        return (AudioSink)defaultAudioSink;
    }

    protected void buildVideoRenderers(@NotNull Context context2, int extensionRendererMode, @NotNull MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, @NotNull Handler eventHandler, @NotNull VideoRendererEventListener eventListener, long allowedVideoJoiningTimeMs, @NotNull ArrayList<Renderer> out) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaCodecSelector, (String)"mediaCodecSelector");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        Intrinsics.checkNotNullParameter(out, (String)"out");
        super.buildVideoRenderers(context2, extensionRendererMode, mediaCodecSelector, enableDecoderFallback, eventHandler, eventListener, allowedVideoJoiningTimeMs, out);
        ORPlayerLog.INSTANCE.i(TAG, "buildVideoRenderers, mode:" + extensionRendererMode, true);
        if (extensionRendererMode == 0) {
            return;
        }
        int extensionRendererIndex = out.size();
        if (extensionRendererMode == 2) {
            --extensionRendererIndex;
        }
        try {
            DecoderVideoRenderer renderer = WhenMappings.$EnumSwitchMapping$0[this.videoRendererType.ordinal()] == 1 ? (DecoderVideoRenderer)new Libgav1VideoRenderer(allowedVideoJoiningTimeMs, eventHandler, eventListener, 50) : (DecoderVideoRenderer)new FfmpegVideoRenderer(allowedVideoJoiningTimeMs, eventHandler, eventListener, 50);
            out.add(extensionRendererIndex, (Renderer)renderer);
            ORPlayerLog.INSTANCE.i(TAG, "Loaded FfmpegVideoRenderer.", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            ORPlayerLog.INSTANCE.e(TAG, "Error instantiating Ffmpeg extension :" + e, true);
        }
    }

    public void setVolume(float volume) {
        float fixVolume = volume > 1.0f ? (float)2 * volume - 1.0f : volume;
        this.getVolumeAudioProcessor().setVolume(fixVolume);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/transsion/player/exo/ORRenderersFactory$Companion;", "", "()V", "TAG", "", "Player_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ORExoDecoderType.values().length];
            try {
                nArray[ORExoDecoderType.AV1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

