/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.mediasession;

import android.os.Bundle;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import com.transsion.player.mediasession.MediaItem;
import com.transsion.player.mediasession.MediaNotification;
import com.transsion.player.mediasession.MediaService;
import com.transsion.player.mediasession.SessionLogger;
import com.transsion.player.orplayer.ORPlayer;
import com.transsion.player.orplayer.global.TnPlayerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/transsion/player/mediasession/MediaMediaSessionCompatCallBack;", "Landroid/support/v4/media/session/MediaSessionCompat$Callback;", "mediaSession", "Landroid/support/v4/media/session/MediaSessionCompat;", "mediaService", "Lcom/transsion/player/mediasession/MediaService;", "(Landroid/support/v4/media/session/MediaSessionCompat;Lcom/transsion/player/mediasession/MediaService;)V", "mediaItem", "Lcom/transsion/player/mediasession/MediaItem;", "changePlayState", "", "playbackStateCompat", "Landroid/support/v4/media/session/PlaybackStateCompat;", "getTagClass", "", "onCustomAction", "action", "extras", "Landroid/os/Bundle;", "onPause", "onPlay", "onSeekTo", "pos", "", "onSkipToNext", "onSkipToPrevious", "onStop", "setPlayState", "state", "", "Companion", "Player_release"})
public final class MediaMediaSessionCompatCallBack
extends MediaSessionCompat.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final MediaSessionCompat mediaSession;
    @NotNull
    private final MediaService mediaService;
    @Nullable
    private MediaItem mediaItem;
    @NotNull
    public static final String KEY_MEDIAITEM = "MediaItem";
    @NotNull
    public static final String ACTION_PLAY = "transsion_play";
    @NotNull
    public static final String ACTION_PAUSE = "transsion_pause";

    public MediaMediaSessionCompatCallBack(@Nullable MediaSessionCompat mediaSession, @NotNull MediaService mediaService) {
        Intrinsics.checkNotNullParameter((Object)((Object)mediaService), (String)"mediaService");
        this.mediaSession = mediaSession;
        this.mediaService = mediaService;
    }

    private final String getTagClass() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    public void onPlay() {
        block0: {
            super.onPlay();
            SessionLogger.INSTANCE.log(this.getTagClass() + " --> mediaSessionCallback --> onPlay()");
            this.changePlayState(this.setPlayState(3));
            ORPlayer oRPlayer = TnPlayerManager.INSTANCE.getCurrentFocusPlayer();
            if (oRPlayer == null) break block0;
            oRPlayer.play();
        }
    }

    public void onPause() {
        block0: {
            super.onPause();
            SessionLogger.INSTANCE.log(this.getTagClass() + " --> mediaSessionCallback --> onPause()");
            this.changePlayState(this.setPlayState(2));
            ORPlayer oRPlayer = TnPlayerManager.INSTANCE.getCurrentFocusPlayer();
            if (oRPlayer == null) break block0;
            oRPlayer.pause();
        }
    }

    public void onStop() {
        block0: {
            super.onStop();
            SessionLogger.INSTANCE.log(this.getTagClass() + " --> mediaSessionCallback --> onStop()");
            this.setPlayState(1);
            ORPlayer oRPlayer = TnPlayerManager.INSTANCE.getCurrentFocusPlayer();
            if (oRPlayer == null) break block0;
            oRPlayer.release();
        }
    }

    public void onSkipToNext() {
        super.onSkipToNext();
        SessionLogger.INSTANCE.log(this.getTagClass() + " --> mediaSessionCallback --> onSkipToNext() -- \u6682\u4e0d\u5904\u7406\u8be5\u4e8b\u4ef6");
    }

    public void onSkipToPrevious() {
        super.onSkipToPrevious();
        SessionLogger.INSTANCE.log(this.getTagClass() + " --> mediaSessionCallback --> onSkipToPrevious() -- \u6682\u4e0d\u5904\u7406\u8be5\u4e8b\u4ef6");
    }

    public void onSeekTo(long pos) {
        block1: {
            super.onSeekTo(pos);
            MediaItem mediaItem = this.mediaItem;
            if (mediaItem != null) {
                mediaItem.setPosition(pos);
            }
            SessionLogger.INSTANCE.log(this.getTagClass() + " --> mediaSessionCallback --> onSeekTo() --> mediaItem = " + this.mediaItem);
            ORPlayer oRPlayer = TnPlayerManager.INSTANCE.getCurrentFocusPlayer();
            if (oRPlayer == null) break block1;
            oRPlayer.seekTo(pos);
        }
    }

    public void onCustomAction(@Nullable String action2, @Nullable Bundle extras) {
        PlaybackStateCompat playbackStateCompat;
        super.onCustomAction(action2, extras);
        Bundle bundle = extras;
        this.mediaItem = bundle != null ? (MediaItem)bundle.getParcelable(KEY_MEDIAITEM) : null;
        String string = action2;
        if (Intrinsics.areEqual((Object)string, (Object)ACTION_PLAY)) {
            MediaSessionCompat mediaSessionCompat = this.mediaSession;
            if (mediaSessionCompat != null) {
                Object object;
                MediaItem mediaItem = this.mediaItem;
                mediaSessionCompat.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.MEDIA_ID", mediaItem != null ? mediaItem.getMediaId() : null).putLong("android.media.metadata.DURATION", (object = this.mediaItem) != null && (object = ((MediaItem)object).getDuration()) != null ? (Long)object : 0L).build());
            }
            playbackStateCompat = this.setPlayState(3);
        } else {
            playbackStateCompat = Intrinsics.areEqual((Object)string, (Object)ACTION_PAUSE) ? this.setPlayState(2) : null;
        }
        PlaybackStateCompat playbackStateCompat2 = playbackStateCompat;
        this.changePlayState(playbackStateCompat2);
    }

    private final PlaybackStateCompat setPlayState(int state) {
        Object object = this.mediaItem;
        long position = object != null && (object = ((MediaItem)object).getPosition()) != null ? (Long)object : 0L;
        PlaybackStateCompat playbackState = new PlaybackStateCompat.Builder().setActions(775L).setState(state, position, 1.0f).build();
        MediaSessionCompat mediaSessionCompat = this.mediaSession;
        if (mediaSessionCompat != null) {
            mediaSessionCompat.setPlaybackState(playbackState);
        }
        Intrinsics.checkNotNullExpressionValue((Object)playbackState, (String)"playbackState");
        return playbackState;
    }

    private final void changePlayState(PlaybackStateCompat playbackStateCompat) {
        block0: {
            PlaybackStateCompat playbackStateCompat2 = playbackStateCompat;
            if (playbackStateCompat2 == null) break block0;
            PlaybackStateCompat it = playbackStateCompat2;
            boolean bl = false;
            MediaNotification.INSTANCE.notifyNotification(this.mediaService, this.mediaItem, playbackStateCompat.getState(), this.mediaSession);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/transsion/player/mediasession/MediaMediaSessionCompatCallBack$Companion;", "", "()V", "ACTION_PAUSE", "", "ACTION_PLAY", "KEY_MEDIAITEM", "Player_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

