/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.mediasession;

import android.app.Application;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.media.session.MediaSessionCompat;
import android.text.TextUtils;
import androidx.core.app.NotificationCompat;
import androidx.core.app.ServiceCompat;
import androidx.media.app.NotificationCompat;
import androidx.media.session.MediaButtonReceiver;
import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.SizeUtils;
import com.blankj.utilcode.util.Utils;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.transsion.player.R;
import com.transsion.player.mediasession.MediaItem;
import com.transsion.player.mediasession.MediaNotification;
import com.transsion.player.mediasession.MediaService;
import com.transsion.player.mediasession.MusicNotificationBroadcastReceiver;
import com.transsion.player.mediasession.SessionLogger;
import com.transsion.player.utils.Resizer;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\f*\u0001\u001a\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u0004H\u0002J\u0006\u0010\u001f\u001a\u00020\bJ\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0006\u0010\"\u001a\u00020#J5\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010\u00182\b\u0010&\u001a\u0004\u0018\u00010\u00122\b\u0010'\u001a\u0004\u0018\u00010\b2\b\u0010(\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020#H\u0002J3\u0010+\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010\u00182\b\u0010&\u001a\u0004\u0018\u00010\u00122\b\u0010'\u001a\u0004\u0018\u00010\b2\b\u0010(\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010)J\u0006\u0010,\u001a\u00020#J\u0014\u0010-\u001a\u0004\u0018\u00010\u00102\b\u0010.\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/transsion/player/mediasession/MediaNotification;", "", "()V", "CHANNEL_ID", "", "DEFAULT_OPEN_PREV_NEXT_BUTTON", "", "NOTIFICATION_ID", "", "PAGE_NAME", "isCreate", "()Z", "setCreate", "(Z)V", "lastCoverUrl", "mCover", "Landroid/graphics/Bitmap;", "mMediaItem", "Lcom/transsion/player/mediasession/MediaItem;", "mMediaSession", "Landroid/support/v4/media/session/MediaSessionCompat;", "mState", "Ljava/lang/Integer;", "mediaService", "Lcom/transsion/player/mediasession/MediaService;", "target", "com/transsion/player/mediasession/MediaNotification$target$1", "Lcom/transsion/player/mediasession/MediaNotification$target$1;", "getBitmap", "path", "getClassTag", "getFlag", "getResizeUrl", "url", "initNotificationChannel", "", "innerNotify", "service", "mediaItem", "state", "mediaSession", "(Lcom/transsion/player/mediasession/MediaService;Lcom/transsion/player/mediasession/MediaItem;Ljava/lang/Integer;Landroid/support/v4/media/session/MediaSessionCompat;)V", "loadAlbum", "notifyNotification", "removeNotification", "resizedBitmap", "imagePath", "Player_release"})
public final class MediaNotification {
    @NotNull
    public static final MediaNotification INSTANCE = new MediaNotification();
    @NotNull
    public static final String PAGE_NAME = "media_notification";
    private static final boolean DEFAULT_OPEN_PREV_NEXT_BUTTON = false;
    @NotNull
    private static final String CHANNEL_ID = "MUSIC_NOTIFICATION_ID";
    private static boolean isCreate;
    private static final int NOTIFICATION_ID = 89757;
    @Nullable
    private static MediaSessionCompat mMediaSession;
    @Nullable
    private static MediaService mediaService;
    @Nullable
    private static MediaItem mMediaItem;
    @Nullable
    private static Integer mState;
    @Nullable
    private static Bitmap mCover;
    @Nullable
    private static String lastCoverUrl;
    @NotNull
    private static final target.1 target;

    private MediaNotification() {
    }

    private final String getClassTag() {
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.simpleName");
        return string2;
    }

    public final boolean isCreate() {
        return isCreate;
    }

    public final void setCreate(boolean bl) {
        isCreate = bl;
    }

    public final void initNotificationChannel() {
        SessionLogger.INSTANCE.log(this.getClassTag() + " --> initNotificationChannel() --> \u521d\u59cb\u5316 \u901a\u77e5\u7684 \u6e20\u9053");
        Object object = Utils.getApp().getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager manager = (NotificationManager)object;
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)Utils.getApp().getString(R.string.player_notification_name), 3);
            channel.setSound(null, null);
            channel.setDescription("playing media");
            manager.createNotificationChannel(channel);
        }
        MusicNotificationBroadcastReceiver.Companion.register();
    }

    public final int getFlag() {
        return Build.VERSION.SDK_INT >= 31 ? 0x4000000 : 0x8000000;
    }

    public final void removeNotification() {
        MediaService mediaService = MediaNotification.mediaService;
        if (mediaService != null) {
            MediaService it = mediaService;
            boolean bl = false;
            ServiceCompat.stopForeground((Service)((Service)it), (int)1);
        }
        Object object = Utils.getApp().getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager manager = (NotificationManager)object;
        manager.cancel(89757);
        isCreate = false;
    }

    public final void notifyNotification(@Nullable MediaService service, @Nullable MediaItem mediaItem, @Nullable Integer state, @Nullable MediaSessionCompat mediaSession) {
        if (mediaItem == null) {
            SessionLogger.INSTANCE.logE(this.getClassTag() + " --> notifyNotification() --> mediaItem == null --> return");
            this.removeNotification();
            return;
        }
        this.innerNotify(service, mediaItem, state, mediaSession);
    }

    private final void innerNotify(MediaService service, MediaItem mediaItem, Integer state, MediaSessionCompat mediaSession) {
        Notification notification;
        mediaService = service;
        mMediaItem = mediaItem;
        mState = state;
        mMediaSession = mediaSession;
        this.loadAlbum();
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp()");
        Context context2 = (Context)application;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context2, CHANNEL_ID);
        Object object = mediaItem;
        if (object == null || (object = ((MediaItem)object).getTitle()) == null) {
            object = "VideoPlayer";
        }
        NotificationCompat.Builder builder2 = builder.setContentTitle((CharSequence)object);
        Object object2 = mediaItem;
        if (object2 == null || (object2 = ((MediaItem)object2).getSubTitle()) == null) {
            object2 = "VideoPlayer";
        }
        NotificationCompat.Builder builder3 = builder2.setContentText((CharSequence)object2);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"Builder(context, CHANNEL\u2026ubTitle ?: \"VideoPlayer\")");
        NotificationCompat.Builder builder4 = builder3;
        if (mCover == null) {
            builder4.setLargeIcon(BitmapFactory.decodeResource((Resources)Utils.getApp().getResources(), (int)R.mipmap.player_ic_push_small_logo));
        } else {
            builder4.setLargeIcon(mCover);
        }
        builder4.setDeleteIntent(MusicNotificationBroadcastReceiver.Companion.getDeleteIntent());
        MediaItem mediaItem2 = mediaItem;
        if ((mediaItem2 != null ? mediaItem2.getPendingIntent() : null) != null) {
            builder4.setContentIntent(mediaItem.getPendingIntent());
        }
        builder4.setVisibility(1);
        Integer n = state;
        int n2 = 3;
        if (n != null && n == n2) {
            builder4.addAction(new NotificationCompat.Action.Builder(R.mipmap.player_pause, (CharSequence)"pause", MediaButtonReceiver.buildMediaButtonPendingIntent((Context)context2, (long)2L)).build());
        } else {
            builder4.addAction(new NotificationCompat.Action.Builder(R.mipmap.player_play, (CharSequence)"play", MediaButtonReceiver.buildMediaButtonPendingIntent((Context)context2, (long)4L)).build());
        }
        MediaSessionCompat mediaSessionCompat = mMediaSession;
        int[] nArray = new int[]{0};
        builder4.setStyle((NotificationCompat.Style)new NotificationCompat.MediaStyle().setMediaSession((MediaSessionCompat.Token)(mediaSessionCompat != null ? mediaSessionCompat.getSessionToken() : null)).setShowActionsInCompactView(nArray));
        builder4.setSmallIcon(R.mipmap.player_ic_push_small_logo);
        try {
            notification = builder4.build();
        }
        catch (Throwable e) {
            return;
        }
        Notification notification2 = notification;
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"try {\n            builde\u2026         return\n        }");
        Notification notification3 = notification2;
        notification3.flags = 224;
        if (isCreate) {
            try {
                MediaService mediaService = service;
                Object object3 = mediaService != null ? mediaService.getSystemService("notification") : null;
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                NotificationManager manager = (NotificationManager)object3;
                manager.notify(89757, notification3);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (AppUtils.isAppForeground()) {
            try {
                MediaService mediaService = service;
                if (mediaService != null) {
                    mediaService.startForeground(89757, notification3);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    MediaService mediaService = service;
                    Object object4 = mediaService != null ? mediaService.getSystemService("notification") : null;
                    Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type android.app.NotificationManager");
                    NotificationManager manager = (NotificationManager)object4;
                    manager.notify(89757, notification3);
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
            }
            isCreate = true;
        } else {
            SessionLogger.INSTANCE.logE("Service is restricted, cannot start foreground.");
        }
    }

    private final void loadAlbum() {
        String coverUrl;
        MediaItem mediaItem = mMediaItem;
        String string2 = coverUrl = mediaItem != null ? mediaItem.getCoverUrl() : null;
        if (TextUtils.isEmpty((CharSequence)coverUrl)) {
            return;
        }
        if (TextUtils.equals((CharSequence)lastCoverUrl, (CharSequence)coverUrl)) {
            return;
        }
        String string3 = lastCoverUrl = coverUrl;
        boolean bl = string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"http", (boolean)false, (int)2, null) : false;
        if (bl) {
            mCover = null;
            RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)Glide.with((Context)((Context)Utils.getApp())).asBitmap().centerInside()).diskCacheStrategy(DiskCacheStrategy.DATA);
            Object object = mMediaItem;
            if (object == null || (object = ((MediaItem)object).getCoverUrl()) == null) {
                object = "";
            }
            requestBuilder.load(this.getResizeUrl((String)object)).into((Target)target);
        } else {
            Object object;
            try {
                boolean bl2 = false;
                mCover = INSTANCE.getBitmap(lastCoverUrl);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl3 = false;
                mCover = BitmapFactory.decodeResource((Resources)Utils.getApp().getResources(), (int)R.mipmap.player_ic_push_small_logo);
            }
            this.innerNotify(mediaService, mMediaItem, mState, mMediaSession);
        }
    }

    private final String getResizeUrl(String url) {
        int width = SizeUtils.dp2px((float)48.0f);
        return Resizer.getReSizeUrl$default(Resizer.INSTANCE, url, width, true, false, 0, false, false, 120, null);
    }

    private final Bitmap getBitmap(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return this.resizedBitmap(path);
    }

    private final Bitmap resizedBitmap(String imagePath) {
        if (TextUtils.isEmpty((CharSequence)imagePath)) {
            return null;
        }
        int targetWidth = SizeUtils.dp2px((float)48.0f);
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
            int originalWidth = options.outWidth;
            int originalHeight = options.outHeight;
            if (originalWidth <= targetWidth && originalHeight <= targetWidth) {
                options.inJustDecodeBounds = false;
                return BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
            }
            int inSampleSize = 1;
            if (originalHeight > targetWidth || originalWidth > targetWidth) {
                float heightRatio = (float)originalHeight / (float)targetWidth;
                float widthRatio = (float)originalWidth / (float)targetWidth;
                inSampleSize = Math.round(RangesKt.coerceAtLeast((float)heightRatio, (float)widthRatio));
            }
            options.inSampleSize = inSampleSize;
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final /* synthetic */ String access$getLastCoverUrl$p() {
        return lastCoverUrl;
    }

    public static final /* synthetic */ MediaItem access$getMMediaItem$p() {
        return mMediaItem;
    }

    public static final /* synthetic */ void access$setMCover$p(Bitmap bitmap) {
        mCover = bitmap;
    }

    public static final /* synthetic */ MediaService access$getMediaService$p() {
        return mediaService;
    }

    public static final /* synthetic */ Integer access$getMState$p() {
        return mState;
    }

    public static final /* synthetic */ MediaSessionCompat access$getMMediaSession$p() {
        return mMediaSession;
    }

    public static final /* synthetic */ String access$getClassTag(MediaNotification $this) {
        return $this.getClassTag();
    }

    static {
        lastCoverUrl = "";
        target = new CustomTarget<Bitmap>(){

            public void onResourceReady(@NotNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                MediaItem mediaItem = MediaNotification.access$getMMediaItem$p();
                if (TextUtils.equals((CharSequence)MediaNotification.access$getLastCoverUrl$p(), (CharSequence)(mediaItem != null ? mediaItem.getCoverUrl() : null))) {
                    MediaNotification.access$setMCover$p(resource);
                    MediaNotification.INSTANCE.notifyNotification(MediaNotification.access$getMediaService$p(), MediaNotification.access$getMMediaItem$p(), MediaNotification.access$getMState$p(), MediaNotification.access$getMMediaSession$p());
                }
            }

            public void onLoadCleared(@Nullable Drawable placeholder) {
                SessionLogger.INSTANCE.log(MediaNotification.access$getClassTag(MediaNotification.INSTANCE) + " --> loadAlbum --> onLoadCleared() ---> \u52a0\u8f7d\u5931\u8d25");
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                super.onLoadFailed(errorDrawable);
                SessionLogger.INSTANCE.log(MediaNotification.access$getClassTag(MediaNotification.INSTANCE) + " --> loadAlbum --> onLoadFailed() ---> \u52a0\u8f7d\u5931\u8d25");
                MediaNotification.access$setMCover$p(BitmapFactory.decodeResource((Resources)Utils.getApp().getResources(), (int)R.mipmap.player_ic_notification_icon));
                MediaNotification.INSTANCE.notifyNotification(MediaNotification.access$getMediaService$p(), MediaNotification.access$getMMediaItem$p(), MediaNotification.access$getMState$p(), MediaNotification.access$getMMediaSession$p());
            }
        };
    }
}

