package com.transsion.player

import android.os.Bundle
import android.util.Log
import android.view.TextureView
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.media3.common.C
import androidx.media3.common.util.UnstableApi
import com.transsion.player.exo.ORExoPlayer
import com.transsion.player.orplayer.IPlayerListener
import com.transsion.player.tracks.TnTracks


@UnstableApi
class DashDemoActivity : AppCompatActivity(), IPlayerListener {
    private lateinit var textureView: TextureView
    var palyer: ORExoPlayer? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_dash)
        textureView = findViewById(R.id.tv)


        val path = filesDir.absolutePath + "/test265/1.mpd"

        palyer = ORExoPlayer(this).apply {
            setTextureView(textureView)
            addPlayerListener(this@DashDemoActivity)
            addStreamDataSource(MediaSource("11", path))
            prepare()
            play()
        }


        val textview = findViewById<TextView>(R.id.tv_index)
        textview.setOnClickListener {
            palyer?.let {
                it.getCurrentTracks().groups.firstOrNull { it.type == C.TRACK_TYPE_VIDEO }?.let { mediaTrackGroup ->
                    val count = mediaTrackGroup.length
                    val index = ++trackIndex % count

                    it.changeTrackSelection(mediaTrackGroup, index)
                    textview.text = mediaTrackGroup.formats[index].let {
                        "codecs:" + it.codecs + " peakBitrate:" + it.peakBitrate + "  " + it.width + "*" + it.height
                    }
                }

            }
        }

        findViewById<View>(R.id.tv_seek).setOnClickListener {
            val position = palyer?.getCurrentPosition() ?: return@setOnClickListener
            palyer?.seekTo(position + 10_000)
        }
        findViewById<View>(R.id.tv_speed).setOnClickListener {
            speed += 0.25f
            Log.e(TAG, "speed:$speed")
            palyer?.setSpeed(speed)
        }
    }

    private var speed = 0f
    private var trackIndex = 0


    val TAG = "DashActivity"


    override fun onTracksChange(tracks: TnTracks) {
        // Update UI using current tracks.
        Log.e(TAG, "onTracksChanged  tracks:$tracks")
        for (trackGroup in tracks.groups) {
            // Group level information.
            val trackType = trackGroup.type
            val trackInGroupIsSupported = trackGroup.adaptiveSupported
            for (format in trackGroup.formats) {
                // Individual track information.
                Log.e(
                    TAG, "onTracksChanged  trackInGroupIsSupported:$trackInGroupIsSupported \n" +
                            "trackFormat:$format \n"
                )
            }
            Log.e(
                TAG, "onTracksChanged  trackType:$trackType \n" +
                        "trackInGroupIsSupported:$trackInGroupIsSupported \n"
            )
        }
    }

    override fun onVideoSizeChanged(width: Int, height: Int) {
        Log.e(TAG, "onVideoSizeChanged  width:$width height:$height")
        if (width <= 0 && height <= 0) return
        val screenWith = 720
        val layoutParams = textureView.layoutParams as ConstraintLayout.LayoutParams?
        layoutParams?.width = screenWith
        layoutParams?.height = height * screenWith / width
        textureView.layoutParams = layoutParams
    }

}