package com.transsion.player

import androidx.media3.common.util.UnstableApi
import com.transsion.player.enum.PlayMimeType
import com.transsion.player.mediasession.MediaItem
import com.transsion.player.utils.MD5
import androidx.annotation.OptIn
import androidx.media3.common.util.Log


data class MediaSource(
    /**
     * 唯一标识
     */
    val id: String?,
    /**
     * 播放地址
     */
    val url: String,
    /**
     * 权重，影响在列表在位置
     */
    val weights: Int = -1,

    /**
     * 媒体类型-默认mp4
     */
    var mimeType: PlayMimeType = PlayMimeType.DEFAULT,

    /**
     * mediaSession显示的数据
     */
    val mediaItem: MediaItem? = null
) {
    /**
     * 本地地址，，下载后的
     */
    var localPath: String? = null

    /**
     * 缓存的key，下载地址指定
     */
    val key: String by lazy { getCacheKey() }

    var forceExo = false

    var isLive = false

    /**
     * 请求资源时用加上的headers
     */
    var headers: Map<String, String>? = null

    private fun getCacheKey(): String {
        val index = url.indexOf("?")
        val key = if (index >= 0) {
            MD5.getStringMD5(url.substring(0, index))
        } else {
            MD5.getStringMD5(url)
        }
        return key
    }

    val isStream: Boolean
        get() = mimeType == PlayMimeType.DASH || mimeType == PlayMimeType.HLS || url.contains(".mpd") || url.contains(".m3u8")


    @OptIn(UnstableApi::class)
    fun isUrlDash(): Boolean {
        if (mimeType == PlayMimeType.DASH || url.contains(".mpd")) {
            return true
        } else {
            return false
        }
    }

}