package com.transsion.player.orplayer

import com.transsion.player.MediaSource
import com.transsion.player.orplayer.global.TnPlayerType
import com.transsion.player.tracks.TnTracks


/**
 * @author xugaopan
 * @date 2022/8/9
 * 播放器回调统一处理
 */
interface IPlayerListener {

    fun onSetDataSource() = Unit

    /**
     * 播放器初始化
     * play/prepare之前调用
     */
    fun initPlayer() = Unit

    /**
     * 首帧渲染
     */
    fun onRenderFirstFrame() = Unit

    /**
     * 播放完成
     * 开启循环播放时，不会调用该方法
     */
    fun onCompletion(mediaSource: MediaSource? = null) = Unit

    fun onPlayerRelease(mediaSource: MediaSource? = null) = Unit

    /***准备播放新的音频 将唯一标识url回调*/
    fun onPrepare(mediaSource: MediaSource? = null) = Unit

    /**
     * 暂停
     */
    fun onVideoPause(mediaSource: MediaSource? = null) = Unit

    /**
     * 播放开始
     */
    fun onVideoStart(mediaSource: MediaSource? = null) = Unit

    /**
     * 自动开始播放开始
     */
    fun onLoopingStart() = Unit

    /**
     * 播放出错
     */
    fun onPlayError(errorInfo: PlayError, mediaSource: MediaSource? = null) = Unit

    /**
     * 视频大小改变
     */
    fun onVideoSizeChanged(width: Int, height: Int) = Unit

    /**
     * 缓冲开始
     */
    fun onLoadingBegin(mediaSource: MediaSource? = null) = Unit


    /**
     * 缓冲进度
     */
    fun onBufferedPosition(progress: Long, mediaSource: MediaSource? = null) = Unit

    fun onLoadingProgress(percent: Int, netSpeed: Float, mediaSource: MediaSource? = null) = Unit

    fun onProgress(progress: Long, mediaSource: MediaSource? = null) = Unit

    /**
     * 缓冲结束
     */
    fun onLoadingEnd(mediaSource: MediaSource? = null) = Unit

    fun onPlayerReset() = Unit

    fun onIsPlayingChanged(isPlaying:Boolean)  = Unit

    //focusLoss true：音频焦点丢失，false：音频焦点获取
    fun onFocusChange(focusLoss: Boolean) = Unit

    ///拖动结束
    fun setOnSeekCompleteListener() {


    }

    //视频切换回调，比如上一首，下一首
    fun onMediaItemTransition(uuid: String?) {


    }

    fun onTracksChange(tracks: TnTracks) {}

    fun onTracksChangeIJK(heightsMap: Map<String, Int>, currentHeightMap: Map<String, Int>) {}
    fun onTracksChangeIJKEnd() {}


    //播放失败，切换播放器错误回调，外部用于埋点
    fun onPlayErrorChangePayer(errorType: TnPlayerType, mediaSource: MediaSource? = null) {}

    //阿里云内部硬解失败，强制切到软解再重试播放(内部自动切换逻辑未生效)，外部用于埋点
    fun onAliyunDecodeErrorChangeSoftwareDecoder(mediaSource: MediaSource? = null) {}

    fun onTracksVideoBitrateChange(videoBitrate: Int) {}

    fun onTracksAudioBitrateChange(audioBitrate: Int) {}
}