package com.transsion.player.orplayer.global

import android.annotation.SuppressLint
import android.content.Context
import android.media.MediaExtractor
import android.media.MediaFormat
import android.net.Uri
import android.util.Log
import com.transsion.player.MediaSource
import com.transsion.player.mediasession.MediaBrowserCompatHelper
import com.transsion.player.orplayer.ORPlayer
import com.transsion.player.orplayer.ORPlayerFocusListener
import com.transsion.player.utils.ORPlayerLog
import java.io.IOException
import java.lang.ref.WeakReference
import java.util.concurrent.CopyOnWriteArrayList


object TnPlayerManager {
    private val singleInstancePlayer: TnPlayer by lazy { TnPlayer() }

    /**
     * 是否多播放器配置，
     */
    var isMultiplePlayerRequest: (() -> Boolean)? = null

    /**
     * 是否播放器异步调用
     */
    var isASyncPlayerRequest: (() -> Boolean)? = null


    val isASyncPlayer: Boolean by lazy {
        val result = isASyncPlayerRequest?.invoke() ?: false
        Log.i(TnAliPlayer.TAG, "isASyncPlayer:$result")
        result
    }

    /**
     * 是否多播放器
     */
    val isMultiplePlayer: Boolean by lazy {
        val result = isMultiplePlayerRequest?.invoke() ?: true
        Log.i(TnAliPlayer.TAG, "isMultiplePlayer:$result")
        result
    }

    var isUsePlayerTypeRequest: (() -> Int)? = null

    val isUsePlayerType get() = isUsePlayerTypeRequest?.invoke() ?: 1

    //测试用
//    val isUsePlayerType get() = 2


    var isMusicPlay: Boolean?= false

    var isScreenUIChange: Boolean?= false


    /**
     * 当前的播放器--单播放器时用
     */
    @SuppressLint("StaticFieldLeak")
    @Volatile
    private var currentPlayerProxy: TnSingleInstancePlayer? = null

    /**
     * 当前的获取焦点的播放器--
     */
    @Volatile
    var currentFocusPlayer: ORPlayer? = null
    var currentPlayerForm: String? = "exo_player"
    var currentPlayerFormShortTV: String? = "exo_player"
    var currentPlayerFormInt: Int? = 1


    private val playerList: CopyOnWriteArrayList<WeakReference<ORPlayer>> = CopyOnWriteArrayList()

    fun newPlayerInstance(): ORPlayer {
        val orPlayer = if (isMultiplePlayer) {
            TnPlayer()
        } else {
            TnSingleInstancePlayer()
        }
        playerList.add(WeakReference(orPlayer))
        return orPlayer
    }


    fun requestForce(tnPlayer: TnSingleInstancePlayer) {
        if (!isMultiplePlayer) {

            if (this.currentPlayerProxy != tnPlayer) {
                synchronized(this) {
                    if (this.currentPlayerProxy != tnPlayer) {
                        ORPlayerLog.d(
                            TnAliPlayer.TAG, "换boss啦:$currentPlayerProxy  to $tnPlayer", true
                        )
                        this.currentPlayerProxy?.onLossFocus(true)
                        tnPlayer.onLossFocus(false)
                        this.currentPlayerProxy?.mOrPlayer = null
                        this.currentPlayerProxy = tnPlayer.apply {
                            mOrPlayer = singleInstancePlayer
                        }
                    }
                }
            }
        }
    }


    /*********************************焦点相关start***********************************/

    private val playerFocusListeners: CopyOnWriteArrayList<ORPlayerFocusListener> =
        CopyOnWriteArrayList()

    fun addPlayerFocusListener(orPlayerFocusListener: ORPlayerFocusListener) {
        if (playerFocusListeners.contains(orPlayerFocusListener)) {
            playerFocusListeners.add(orPlayerFocusListener)
        }
    }

    fun removePlayerFocusListener(orPlayerFocusListener: ORPlayerFocusListener) {
        playerFocusListeners.remove(orPlayerFocusListener)
    }

    /**
     * 获取焦点，
     * @param orPlayer 获取焦点的播放器
     * @param reason 获取焦点的原因， setDataSource/play
     *
     */
    fun requestFocus(orPlayer: ORPlayer, reason: String) {
        if (currentFocusPlayer == orPlayer) return
        val lastPlayer = currentFocusPlayer
        //失去焦点的播放器自动暂停
        if (lastPlayer?.isPlaying() == true) {
            lastPlayer.pause()
        }
        this.currentFocusPlayer = orPlayer
        onFocusChange(lastPlayer, orPlayer)
        ORPlayerLog.d("TnPlayerManager", "requestFocus  orPlayer:$orPlayer  reason:$reason")
    }

    /**
     * 释放焦点
     */
    fun releaseFocus(orPlayer: ORPlayer) {
        if (currentFocusPlayer == orPlayer) {
            this.currentFocusPlayer = null
            onFocusChange(null, orPlayer)
            ORPlayerLog.d("TnPlayerManager", "releaseFocus  orPlayer:$orPlayer")
        }
        release(orPlayer)
    }

    private fun onFocusChange(focusPlayer: ORPlayer?, lossFocusPlayer: ORPlayer?) {
        for (playerFocusListener in playerFocusListeners) {
            playerFocusListener.onFocusChange(focusPlayer, lossFocusPlayer)
        }
    }

    /*********************************焦点相关end***********************************/


    /*********************************播放相关start***********************************/


//    /**
//     * 时间戳转换
//     */
//    @SuppressLint("SimpleDateFormat")
//    private fun millisecondToTimeWithHour(millisecond: Long): String {
//        val format = if (millisecond >= 3600_000) {
//            SimpleDateFormat("H:mm:ss")
//        } else {
//            SimpleDateFormat("mm:ss")
//        }
//        format.timeZone = TimeZone.getTimeZone("GMT+0:00")
//        return format.format(millisecond)
//    }

    /**
     * 刷新通知的方法放在 MusicFloatManager 中处理 临时处理方案
     */
    fun play(orPlayer: ORPlayer, mediaSource: MediaSource?) {
//        val mediaItem = mediaSource?.mediaItem
//        SessionORPlayerLog.log("TnPlayerManager --> play() --> 播放 --> mediaItem = $mediaItem")
//        mediaItem?.duration = orPlayer.getDuration()
//        //mediaItem?.position = orPlayer.getCurrentPosition()
//        //SessionORPlayerLog.log("TnPlayerManager --> play() --> 播放 --> mediaItem = $mediaItem")
//        MediaBrowserCompatHelper.instance.play(mediaItem)
    }

    /**
     * 刷新通知的方法放在 MusicFloatManager 中处理
     */
    fun seekTo(orPlayer: ORPlayer, mediaSource: MediaSource?) {
//        val mediaItem = mediaSource?.mediaItem
//        SessionORPlayerLog.log("TnPlayerManager --> seekTo() --> 快进 --> mediaItem = $mediaItem")
//        mediaItem?.duration = orPlayer.getDuration()
//        //mediaItem?.position = orPlayer.getCurrentPosition()
//        //SessionORPlayerLog.log("TnPlayerManager --> seekTo() --> 快进 --> mediaItem = $mediaItem")
//        MediaBrowserCompatHelper.instance.play(mediaItem)
    }

    fun removeNotification(mediaId: String) {
        MediaBrowserCompatHelper.instance.removeNotification(mediaId)
    }

    fun pause(orPlayer: ORPlayer, mediaSource: MediaSource?) {
//        val mediaItem = mediaSource?.mediaItem
//        mediaItem?.duration = orPlayer.getDuration()
//        mediaItem?.position = orPlayer.getCurrentPosition()
//        MediaBrowserCompatHelper.instance.pause(mediaItem)
    }

    private fun release(orPlayer: ORPlayer) {
        val index = playerList.indexOfFirst { it.get() == orPlayer }
        if (index >= 0) {
            playerList.removeAt(index)
        }
    }

    fun findPlayerByMediaId(mediaId: String): ORPlayer? {
        playerList.forEach {
            val orPlayer = it.get()
            if (orPlayer?.currentMediaSource()?.id == mediaId) {
                return orPlayer
            }
        }
        return null
    }

    /**
     * 使用 MediaExtractor 检测 content:// 视频是否为 AV1 编码
     */
    fun isAV1Encoded(context: Context, uri: String): Boolean {
        val videoUri = Uri.parse(uri)
        val extractor = MediaExtractor()
        return try {
            // 设置数据源（支持 content:// 协议）
            extractor.setDataSource(context, videoUri, null)

            // 遍历所有轨道，找到视频轨道
            for (i in 0 until extractor.trackCount) {
                val format = extractor.getTrackFormat(i)
                val mimeType = format.getString(MediaFormat.KEY_MIME) ?: continue

                // 判断是否为视频轨道
                if (mimeType.startsWith("video/")) {
                    // AV1 编码的 MIME 类型为 "video/av1"
                    Log.d("ijkPlayer3==", "找到视频轨道")
                    Log.d("ijkPlayer3==", "视频格式$mimeType")
                    return mimeType == "video/av1" ||mimeType == "video/av01"
                }else{
                    Log.d("ijkPlayer3==", "未找到视频轨道")
                }
            }
            false // 未找到视频轨道或非 AV1 编码
        } catch (e: IOException) {
            e.printStackTrace()
            false
        } finally {
            extractor.release() // 释放资源
        }
    }



    /*********************************播放相关end***********************************/

}