package com.transsion.player.control

import com.transsion.player.MediaSource
import com.transsion.player.enum.PipStatus
import com.transsion.player.enum.ScaleMode
import com.transsion.player.orplayer.IPlayerListener
import com.transsion.player.tracks.TnFormat
import com.transsion.player.tracks.TnTracksGroup
import com.transsion.player.ui.IORVideoView

/**
 *
 * Created by kun.xu on 2024/11/14 20:06
 * Description:
 *
 */
class ControlWrapper<Data, PlayStatus>(
    private val playerView: IORVideoView?,
    private val controller: IVideoController<Data, PlayStatus>
) : IVideoController<Data, PlayStatus>, IORVideoView {

    override fun setMediaData(data: MediaSource) {
        playerView?.setMediaData(data)
    }

    override fun prepare() {
        playerView?.prepare()
    }

    override fun play() {
        playerView?.play()
    }

    override fun pause() {
        playerView?.pause()
    }

    override fun addPlayerListener(listener: IPlayerListener) {
        playerView?.addPlayerListener(listener)
    }

    override fun removePayerListener(listener: IPlayerListener) {
        playerView?.removePayerListener(listener)
    }

    override fun seekTo(mills: Long) {
        playerView?.seekTo(mills)
    }

    override fun setSpeed(speed: Float) {
        playerView?.setSpeed(speed)
    }

    override fun reset() {
        playerView?.reset()
    }

    override fun release() {
        playerView?.release()
    }

    override fun clearScreen() {
        playerView?.clearScreen()
    }

    override fun setLooping(isLoop: Boolean) {
        playerView?.setLooping(isLoop)
    }

    override fun setScaleMode(scaleMode: ScaleMode) {
        playerView?.setScaleMode(scaleMode)
    }

    override fun setVolume(volume: Float) {
        playerView?.setVolume(volume)
    }

    override fun setMute(mute: Boolean) {
        playerView?.setMute(mute)
    }

    override fun enableHardwareDecoder(enable: Boolean) {
        playerView?.enableHardwareDecoder(enable)
    }


    override fun changeTrackSelection(mediaTrackGroup: TnTracksGroup, index: Int) {
        playerView?.changeTrackSelection(mediaTrackGroup, index)
    }

    override fun getMediaData(): MediaSource? = playerView?.getMediaData()

    override fun getDuration(): Long = playerView?.getDuration() ?: 0L

    override fun getPosition(): Long = playerView?.getPosition() ?: 0L

    override fun isPlaying(): Boolean = playerView?.isPlaying() ?: false

    override fun isComplete(): Boolean = playerView?.isComplete() ?: false

    override fun isMute(): Boolean = playerView?.isMute() ?: false

    override fun isBuffering(): Boolean = playerView?.isBuffering() ?: false

    override fun getVideoWidth(): Int = playerView?.getVideoWidth() ?: 0

    override fun getVideoHeight(): Int = playerView?.getVideoHeight() ?: 0

    override fun isPrepared(): Boolean = playerView?.isPrepared() ?: false

    override fun getVideoFormat(): TnFormat? = playerView?.getVideoFormat()

    override fun isLand(): Boolean = playerView?.isLand() ?: false

    override fun isFullscreen(): Boolean = playerView?.isFullscreen() ?: false

    override fun changeFullscreen(fullscreen: Boolean, land: Boolean) {
        playerView?.changeFullscreen(fullscreen, land)
    }

    override fun pipChangeFullscreen(pipStatus: PipStatus) {
        playerView?.pipChangeFullscreen(pipStatus)
    }

    override fun setPipStatus(pipStatus: PipStatus) {
        playerView?.setPipStatus(pipStatus)
    }

    override fun getCurPipStatus(): PipStatus = playerView?.getCurPipStatus() ?: PipStatus.DEFAULT

    override fun getControlComponentMap(): LinkedHashMap<IControlComponent<Data, PlayStatus>, Boolean> {
        return controller.getControlComponentMap()
    }

}