package com.transsion.player.orplayer

import android.content.Context
import android.view.SurfaceView
import android.view.TextureView
import com.transsion.player.MediaSource
import com.transsion.player.config.VodConfig
import com.transsion.player.enum.ScaleMode
import com.transsion.player.orplayer.global.TnErrorInterceptorListener
import com.transsion.player.tracks.TnFormat
import com.transsion.player.tracks.TnTracks
import com.transsion.player.tracks.TnTracksGroup

/**
 * @author xugaopan
 * @date 2022/8/9
 */
interface ORPlayer {


    fun setSurfaceView(surfaceView: SurfaceView?)

    fun setTextureView(textureView: TextureView?)

    fun setPlayerListener(listener: IPlayerListener)
    fun addPlayerListener(listener: IPlayerListener) {}
    fun removePlayerListener(listener: IPlayerListener) {}

    fun setDataSource(mediaSource: MediaSource)

    fun setPlayerConfig(vodConfig: VodConfig) {}

    fun prepare()

    fun play()

    //加载到最新位置-针对直播
    fun seekToDefaultPosition() = Unit

    fun pause()

    fun stop()

    fun release()

    fun release(id: String?) = Unit

    fun reset()

    fun clearScreen() = Unit

    fun seekTo(mills: Long)
    fun seekTo(uuid: String, mills: Long) {}

    /**
     * 获取视频总时长
     * 单位:毫秒
     */
    fun getDuration(): Long

    fun isPlaying(): Boolean

    fun isComplete(): Boolean

    /**
     * 设置循环播放
     * @param isLoop true:循环播放;false:相反
     */
    fun setLooping(isLoop: Boolean)

    fun isMute(): Boolean

    fun setScaleMode(scaleMode: ScaleMode) {}

    /**
     * @param volume 0-1
     */
    fun setVolume(volume: Float)

    fun getVolume(): Float?

    fun setAutoPlay(isAutoPlay: Boolean)

    /**
     * 是否使用硬解
     * 需要在播放之前设置，否则不生效
     * 默认true，使用硬解（阿里云文档说硬解失败会自动切软解，不过发现不生效）
     * false 强制切到软解
     */
    fun enableHardwareDecoder(enable: Boolean = true)

    fun setMute(mute: Boolean) {}

    fun isLoading(): Boolean = false

    fun getVideoWidth(): Int = 0

    fun getVideoHeight(): Int = 0

    fun isPrepared(): Boolean = false

    fun getBitrate(): Pair<Int, Int>

    /** 该Builder，只用于阿里云播放器创建，后续全部切换后可移除*/
    class Builder(private var context: Context) {
        private var vodConfig: VodConfig? = null

        fun vodConfig(config: VodConfig): Builder {
            vodConfig = config
            return this
        }

        fun builder(): ORPlayer {
            val mContext = context
            return ORPlayerImpl(mContext, vodConfig)
        }
    }

    fun getDownloadBitrate(): Any? = null

    open fun requestForce(): Boolean = false

    /**
     * Returns the current tracks.
     * This method must only be called if COMMAND_GET_TRACKS is available.
     * See Also:
     * Player.Listener.onTracksChanged(Tracks)
     */
    fun getCurrentTracks(): TnTracks? = null

    /**
     * Returns the current tracks.
     * This method must only be called if COMMAND_GET_TRACKS is available.
     * See Also:
     * Player.Listener.onTracksChanged(Tracks)
     */
    fun getCurrentPosition(): Long = 0

    fun getCurrentVideoFormat(): TnFormat? = null


    fun changeTrackSelection(
        mediaTrackGroup: TnTracksGroup, /* trackIndex= */
        index: Int
    ) {
    }


    /**
     *  Changes the rate at which playback occurs. The pitch is not changed.
     *     This is equivalent to setPlaybackParameters(getPlaybackParameters().withSpeed(speed)).
     *     This method must only be called if COMMAND_SET_SPEED_AND_PITCH is available.
     *     Params:
     *     speed – The linear factor by which playback will be sped up. Must be higher than 0. 1 is normal speed, 2 is twice as fast, 0.5 is half normal speed.
     *
     */
    fun setSpeed(speed: Float)

    fun currentMediaSource(): MediaSource? = null

    fun addDataSource(mediaSource: MediaSource): Boolean = false


    /**
     * 短剧
     */
    fun removeDataSource(mediaSource: MediaSource): Boolean = false


    fun setErrorInterceptor(listener: TnErrorInterceptorListener) = Unit

    fun clearSurfaceOnly() = Unit
}