package com.transsion.player.tracks

import androidx.media3.common.Format
import androidx.media3.common.TrackGroup
import androidx.media3.common.Tracks
import com.google.common.collect.ImmutableList


fun Tracks.toTnTracks(): TnTracks {
    return if (this.isEmpty) {
        TnTracks()
    } else {
        val arrayList: Array<TnTracksGroup> = Array(this.groups.size) {
            this.groups[it].toTnTracksGroup()
        }
        TnTracks(ImmutableList.copyOf(arrayList))
    }
}

fun Tracks.findTrackGroup(mediaTrackGroup: TnTracksGroup): TrackGroup? {
    for (group in groups) {
        if (group.mediaTrackGroup.id == mediaTrackGroup.id && group.mediaTrackGroup.type == mediaTrackGroup.type) {
            return group.mediaTrackGroup
        }
    }
    return null
}

fun Tracks.Group.toTnTracksGroup(): TnTracksGroup {
    val formats = Array<TnFormat>(length) {
        this.getTrackFormat(it).toTnFormat()
    }
    return TnTracksGroup(this.length, this.mediaTrackGroup.id, this.mediaTrackGroup.type, this.isAdaptiveSupported, formats)
}

fun Format.toTnFormat(): TnFormat {
    return TnFormat(
        this.id, this.label, this.language, this.selectionFlags,
        this.averageBitrate, this.peakBitrate, this.bitrate, this.codecs, this.width,
        this.height, this.frameRate, this.rotationDegrees, this.pixelWidthHeightRatio
    )
}


