package com.transsion.player.tracks

import androidx.annotation.IntDef
import com.google.common.collect.ImmutableList

data class TnTracks(val groups: ImmutableList<TnTracksGroup> = ImmutableList.of())


/** A type constant for a fake or empty track.  */
const val TRACK_TYPE_NONE = -2

/** A type constant for tracks of unknown type.  */
const val TRACK_TYPE_UNKNOWN = -1

/** A type constant for tracks of some default type, where the type itself is unknown.  */
const val TRACK_TYPE_DEFAULT = 0

/** A type constant for audio tracks.  */
const val TRACK_TYPE_AUDIO = 1

/** A type constant for video tracks.  */
const val TRACK_TYPE_VIDEO = 2

/** A type constant for text tracks.  */
const val TRACK_TYPE_TEXT = 3

/** A type constant for image tracks.  */
const val TRACK_TYPE_IMAGE = 4

/** A type constant for metadata tracks.  */
const val TRACK_TYPE_METADATA = 5

/** A type constant for camera motion tracks.  */
const val TRACK_TYPE_CAMERA_MOTION = 6

/**
 * Applications or extensions may define custom `TRACK_TYPE_*` constants greater than or
 * equal to this value.
 */
const val TRACK_TYPE_CUSTOM_BASE = 10000


@MustBeDocumented
@Retention(AnnotationRetention.SOURCE)
@Target(AnnotationTarget.CLASS, AnnotationTarget.TYPE, AnnotationTarget.TYPE_PARAMETER)
@IntDef(
    open = true,
    value = [TRACK_TYPE_UNKNOWN, TRACK_TYPE_DEFAULT, TRACK_TYPE_AUDIO, TRACK_TYPE_VIDEO, TRACK_TYPE_TEXT, TRACK_TYPE_IMAGE, TRACK_TYPE_METADATA, TRACK_TYPE_CAMERA_MOTION, TRACK_TYPE_NONE]
)
annotation class TnTrackType


@MustBeDocumented
@Retention(AnnotationRetention.SOURCE)
@Target(
    AnnotationTarget.FIELD,
    AnnotationTarget.FUNCTION,
    AnnotationTarget.PROPERTY_GETTER,
    AnnotationTarget.PROPERTY_SETTER,
    AnnotationTarget.VALUE_PARAMETER,
    AnnotationTarget.LOCAL_VARIABLE,
    AnnotationTarget.CLASS,
    AnnotationTarget.TYPE,
    AnnotationTarget.TYPE_PARAMETER
)
@IntDef(flag = true, value = [SELECTION_FLAG_DEFAULT, SELECTION_FLAG_FORCED, SELECTION_FLAG_AUTOSELECT])
annotation class TnSelectionFlags

// LINT.IfChange(selection_flags)
// LINT.IfChange(selection_flags)
/** Indicates that the track should be selected if user preferences do not state otherwise.  */
const val SELECTION_FLAG_DEFAULT = 1

/**
 * Indicates that the track should be selected if its language matches the language of the
 * selected audio track and user preferences do not state otherwise. Only applies to text tracks.
 *
 *
 * Tracks with this flag generally provide translation for elements that don't match the
 * declared language of the selected audio track (e.g. speech in an alien language). See [Netflix's summary](https://partnerhelp.netflixstudios.com/hc/en-us/articles/217558918)
 * for more info.
 */
const val SELECTION_FLAG_FORCED = 1 shl 1 // 2

/**
 * Indicates that the player may choose to play the track in absence of an explicit user
 * preference.
 */
const val SELECTION_FLAG_AUTOSELECT = 1 shl 2 // 4


