/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.orplayer;

import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import com.blankj.utilcode.util.ThreadUtils;
import com.blankj.utilcode.util.Utils;
import com.transsion.player.orplayer.AudioFocusPlay;
import com.transsion.player.utils.ORPlayerLog;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\nJ\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001e\u001a\u00020\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/transsion/player/orplayer/AudioFocusHelper;", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "player", "Lcom/transsion/player/orplayer/AudioFocusPlay;", "callback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "focusLoss", "", "(Lcom/transsion/player/orplayer/AudioFocusPlay;Lkotlin/jvm/functions/Function1;)V", "TAG", "", "focusRequest", "Landroid/media/AudioFocusRequest;", "isPlaying", "()Z", "setPlaying", "(Z)V", "isUserPause", "setUserPause", "mAudioManager", "Landroid/media/AudioManager;", "mStartRequested", "abandonFocus", "handleAudioFocusChange", "focusChange", "", "onAudioFocusChange", "requestFocus", "player_release"})
@SourceDebugExtension(value={"SMAP\nAudioFocusHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioFocusHelper.kt\ncom/transsion/player/orplayer/AudioFocusHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class AudioFocusHelper
implements AudioManager.OnAudioFocusChangeListener {
    @NotNull
    private final AudioFocusPlay player;
    @NotNull
    private final Function1<Boolean, Unit> callback;
    @NotNull
    private String TAG;
    @NotNull
    private final AudioManager mAudioManager;
    private boolean mStartRequested;
    private boolean isUserPause;
    private boolean isPlaying;
    @Nullable
    private AudioFocusRequest focusRequest;

    /*
     * WARNING - void declaration
     */
    public AudioFocusHelper(@NotNull AudioFocusPlay player, @NotNull Function1<? super Boolean, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.player = player;
        this.callback = callback;
        this.TAG = "AudioFocusHelper";
        Object object = Utils.getApp().getApplicationContext().getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        this.mAudioManager = (AudioManager)object;
        ORPlayerLog.d$default(ORPlayerLog.INSTANCE, this.TAG, "AudioFocusHelper orPlayer " + this, false, 4, null);
        if (Build.VERSION.SDK_INT >= 26) {
            void $this$lambda_u241_u24lambda_u240;
            void $this$_init__u24lambda_u241;
            AudioFocusRequest.Builder builder = new AudioFocusRequest.Builder(1);
            AudioFocusHelper audioFocusHelper = this;
            boolean bl = false;
            AudioAttributes.Builder builder2 = new AudioAttributes.Builder();
            void var6_7 = $this$_init__u24lambda_u241;
            boolean bl2 = false;
            $this$lambda_u241_u24lambda_u240.setUsage(14);
            $this$lambda_u241_u24lambda_u240.setContentType(2);
            var6_7.setAudioAttributes($this$lambda_u241_u24lambda_u240.build());
            $this$_init__u24lambda_u241.setAcceptsDelayedFocusGain(true);
            $this$_init__u24lambda_u241.setOnAudioFocusChangeListener((AudioManager.OnAudioFocusChangeListener)this);
            audioFocusHelper.focusRequest = $this$_init__u24lambda_u241.build();
        }
    }

    public final boolean isUserPause() {
        return this.isUserPause;
    }

    public final void setUserPause(boolean bl) {
        this.isUserPause = bl;
    }

    public final boolean isPlaying() {
        return this.isPlaying;
    }

    public final void setPlaying(boolean bl) {
        this.isPlaying = bl;
    }

    public void onAudioFocusChange(int focusChange) {
        ThreadUtils.runOnUiThread(() -> AudioFocusHelper.onAudioFocusChange$lambda$2(this, focusChange));
    }

    private final void handleAudioFocusChange(int focusChange) {
        ORPlayerLog.d$default(ORPlayerLog.INSTANCE, this.TAG, "handleAudioFocusChange ------------ " + this + ", focusChange = " + focusChange, false, 4, null);
        switch (focusChange) {
            case 1: 
            case 2: {
                ORPlayerLog.d$default(ORPlayerLog.INSTANCE, this.TAG, "handleAudioFocusChange GAIN, focusChange = " + focusChange + "\uff0c mStartRequested = " + this.mStartRequested + ", isUserPause = " + this.isUserPause, false, 4, null);
                this.callback.invoke((Object)false);
                if (this.mStartRequested && !this.isUserPause) {
                    this.player.play();
                }
                if (this.player.isMute()) break;
                this.player.setVolume(1.0f);
                break;
            }
            case -2: 
            case -1: {
                ORPlayerLog.v$default(ORPlayerLog.INSTANCE, this.TAG, "handleAudioFocusChange LOSS, focusChange = " + focusChange + ", isUserPause = " + this.isUserPause, false, 4, null);
                this.callback.invoke((Object)true);
                if (!this.isPlaying) break;
                this.player.pause();
                break;
            }
            case -3: {
                if (!this.isPlaying || this.player.isMute()) break;
                ORPlayerLog.d$default(ORPlayerLog.INSTANCE, this.TAG, "handleAudioFocusChange AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK, focusChange = " + focusChange, false, 4, null);
                this.player.setVolume(1.0f);
            }
        }
    }

    public final void requestFocus() {
        ORPlayerLog.d$default(ORPlayerLog.INSTANCE, this.TAG, "requestFocus " + this, false, 4, null);
        if (Build.VERSION.SDK_INT >= 26) {
            AudioFocusRequest audioFocusRequest = this.focusRequest;
            if (audioFocusRequest != null) {
                AudioFocusRequest it = audioFocusRequest;
                boolean bl = false;
                int result = this.mAudioManager.requestAudioFocus(it);
                ORPlayerLog.d$default(ORPlayerLog.INSTANCE, this.TAG, "requestFocus, result:" + result, false, 4, null);
            }
        } else {
            int result = this.mAudioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
            ORPlayerLog.d$default(ORPlayerLog.INSTANCE, this.TAG, "requestFocus, result:" + result, false, 4, null);
        }
        this.mStartRequested = true;
    }

    public final void abandonFocus() {
        ORPlayerLog.d$default(ORPlayerLog.INSTANCE, this.TAG, "abandonFocus " + this, false, 4, null);
        if (Build.VERSION.SDK_INT >= 26) {
            AudioFocusRequest audioFocusRequest = this.focusRequest;
            if (audioFocusRequest != null) {
                AudioFocusRequest it = audioFocusRequest;
                boolean bl = false;
                this.mAudioManager.abandonAudioFocusRequest(it);
            }
        } else {
            this.mAudioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
        }
        this.mStartRequested = false;
    }

    private static final void onAudioFocusChange$lambda$2(AudioFocusHelper this$0, int $focusChange) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleAudioFocusChange($focusChange);
    }
}

