package com.transsion.player.shorttv.preload

import androidx.media3.common.C
import androidx.media3.common.MediaItem
import androidx.media3.common.util.UnstableApi
import androidx.media3.common.util.Util
import androidx.media3.datasource.cache.CacheDataSource
import androidx.media3.exoplayer.offline.DefaultDownloaderFactory
import androidx.media3.exoplayer.offline.DownloadRequest
import androidx.media3.exoplayer.offline.Downloader
import java.util.concurrent.Executor

@UnstableApi
class VideoDownloadFactory(
    private val cacheDataSourceFactory: CacheDataSource.Factory,
    private val executor: Executor
) :
    DefaultDownloaderFactory(cacheDataSourceFactory, executor) {

    override fun createDownloader(request: DownloadRequest): Downloader {
        return when (val contentType =
            Util.inferContentTypeForUriAndMimeType(request.uri, request.mimeType)) {
            C.CONTENT_TYPE_DASH, C.CONTENT_TYPE_HLS, C.CONTENT_TYPE_SS -> super.createDownloader(
                request
            )

            C.CONTENT_TYPE_OTHER -> VideoProgressiveDownloader(
                MediaItem.Builder()
                    .setUri(request.uri)
                    .setCustomCacheKey(request.customCacheKey)
                    .build(),
                cacheDataSourceFactory,
                executor
            )

            else -> throw IllegalArgumentException("Unsupported type: $contentType")
        }
    }
}