/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.decoder.av1;

import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.decoder.DecoderOutputBuffer;
import androidx.media3.decoder.SimpleDecoder;
import androidx.media3.decoder.VideoDecoderOutputBuffer;
import androidx.media3.decoder.av1.Gav1DecoderException;
import androidx.media3.decoder.av1.Gav1Library;
import java.nio.ByteBuffer;

@VisibleForTesting(otherwise=3)
@UnstableApi
public final class Gav1Decoder
extends SimpleDecoder<DecoderInputBuffer, VideoDecoderOutputBuffer, Gav1DecoderException> {
    private static final int GAV1_ERROR = 0;
    private static final int GAV1_OK = 1;
    private static final int GAV1_DECODE_ONLY = 2;
    private final long gav1DecoderContext;
    private volatile int outputMode;

    public Gav1Decoder(int numInputBuffers, int numOutputBuffers, int initialInputBufferSize, int threads) throws Gav1DecoderException {
        super(new DecoderInputBuffer[numInputBuffers], (DecoderOutputBuffer[])new VideoDecoderOutputBuffer[numOutputBuffers]);
        if (!Gav1Library.isAvailable()) {
            throw new Gav1DecoderException("Failed to load decoder native library.");
        }
        if (threads == 0 && (threads = this.gav1GetThreads()) <= 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        this.gav1DecoderContext = this.gav1Init(threads);
        if (this.gav1DecoderContext == 0L || this.gav1CheckError(this.gav1DecoderContext) == 0) {
            throw new Gav1DecoderException("Failed to initialize decoder. Error: " + this.gav1GetErrorMessage(this.gav1DecoderContext));
        }
        this.setInitialInputBufferSize(initialInputBufferSize);
    }

    public String getName() {
        return "libgav1";
    }

    protected DecoderInputBuffer createInputBuffer() {
        return new DecoderInputBuffer(2);
    }

    protected VideoDecoderOutputBuffer createOutputBuffer() {
        return new VideoDecoderOutputBuffer(this::releaseOutputBuffer);
    }

    @Nullable
    protected Gav1DecoderException decode(DecoderInputBuffer inputBuffer, VideoDecoderOutputBuffer outputBuffer, boolean reset) {
        int getFrameResult;
        boolean decodeOnly;
        int inputSize;
        ByteBuffer inputData = (ByteBuffer)Util.castNonNull((Object)inputBuffer.data);
        if (this.gav1Decode(this.gav1DecoderContext, inputData, inputSize = inputData.limit()) == 0) {
            return new Gav1DecoderException("gav1Decode error: " + this.gav1GetErrorMessage(this.gav1DecoderContext));
        }
        boolean bl = decodeOnly = !this.isAtLeastOutputStartTimeUs(inputBuffer.timeUs);
        if (!decodeOnly) {
            outputBuffer.init(inputBuffer.timeUs, this.outputMode, null);
        }
        if ((getFrameResult = this.gav1GetFrame(this.gav1DecoderContext, outputBuffer, decodeOnly)) == 0) {
            return new Gav1DecoderException("gav1GetFrame error: " + this.gav1GetErrorMessage(this.gav1DecoderContext));
        }
        if (getFrameResult == 2) {
            outputBuffer.shouldBeSkipped = true;
        }
        if (!decodeOnly) {
            outputBuffer.format = inputBuffer.format;
        }
        return null;
    }

    protected Gav1DecoderException createUnexpectedDecodeException(Throwable error) {
        return new Gav1DecoderException("Unexpected decode error", error);
    }

    public void release() {
        super.release();
        this.gav1Close(this.gav1DecoderContext);
    }

    protected void releaseOutputBuffer(VideoDecoderOutputBuffer outputBuffer) {
        if (outputBuffer.mode == 1 && !outputBuffer.shouldBeSkipped) {
            this.gav1ReleaseFrame(this.gav1DecoderContext, outputBuffer);
        }
        super.releaseOutputBuffer((DecoderOutputBuffer)outputBuffer);
    }

    public void setOutputMode(int outputMode) {
        this.outputMode = outputMode;
    }

    public void renderToSurface(VideoDecoderOutputBuffer outputBuffer, Surface surface) throws Gav1DecoderException {
        if (outputBuffer.mode != 1) {
            throw new Gav1DecoderException("Invalid output mode.");
        }
        if (this.gav1RenderFrame(this.gav1DecoderContext, surface, outputBuffer) == 0) {
            throw new Gav1DecoderException("Buffer render error: " + this.gav1GetErrorMessage(this.gav1DecoderContext));
        }
    }

    private native long gav1Init(int var1);

    private native void gav1Close(long var1);

    private native int gav1Decode(long var1, ByteBuffer var3, int var4);

    private native int gav1GetFrame(long var1, VideoDecoderOutputBuffer var3, boolean var4);

    private native int gav1RenderFrame(long var1, Surface var3, VideoDecoderOutputBuffer var4);

    private native void gav1ReleaseFrame(long var1, VideoDecoderOutputBuffer var3);

    private native String gav1GetErrorMessage(long var1);

    private native int gav1CheckError(long var1);

    private native int gav1GetThreads();
}

