/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.shorttv.preload;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.offline.Download;
import androidx.media3.exoplayer.offline.DownloadManager;
import androidx.media3.exoplayer.offline.DownloadRequest;
import androidx.media3.exoplayer.offline.DownloadService;
import androidx.media3.exoplayer.scheduler.Requirements;
import com.blankj.utilcode.util.Utils;
import com.transsion.player.MediaSource;
import com.transsion.player.exo.DemoDownloadService;
import com.transsion.player.exo.DemoUtil;
import com.transsion.player.shorttv.preload.VideoDownloadBean;
import com.transsion.player.shorttv.preload.VideoPreloadManager;
import com.transsion.player.utils.MD5;
import com.transsion.player.utils.ORPlayerLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000*\u0001\u0019\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\u000e\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u000e\u0010 \u001a\u00020\b2\u0006\u0010$\u001a\u00020\bJ\u000e\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0005J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0005J\u0006\u0010(\u001a\u00020\u0017J\u000e\u0010)\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u0010\u0010*\u001a\u00020\u001c2\b\u0010+\u001a\u0004\u0018\u00010\u0005J\u0010\u0010,\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010\u0005J\u000e\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/transsion/player/shorttv/preload/VideoPreloadManager;", "", "<init>", "()V", "TAG", "", "activeTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/transsion/player/shorttv/preload/VideoDownloadBean;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "context$delegate", "Lkotlin/Lazy;", "videoPreloadThread", "Landroid/os/HandlerThread;", "handler", "Landroid/os/Handler;", "updateInterval", "", "updateIntervalRunnable", "Lkotlin/Function0;", "", "listener", "com/transsion/player/shorttv/preload/VideoPreloadManager$listener$1", "Lcom/transsion/player/shorttv/preload/VideoPreloadManager$listener$1;", "isStartLoop", "", "startLoop", "stopLoop", "loop", "preloadVideo", "shortTVItem", "Lcom/transsion/player/MediaSource;", "preloadVideoAsync", "shortTVDownloadBean", "stopPreload", "key", "removePreload", "stopALlPreload", "createDownloadRequest", "isCache", "url", "urlToCacheKey", "runOnPreloadThread", "runnable", "Ljava/lang/Runnable;", "Player_release"})
@UnstableApi
public final class VideoPreloadManager {
    @NotNull
    public static final VideoPreloadManager INSTANCE = new VideoPreloadManager();
    @NotNull
    private static final String TAG = "VideoPreloadUtil";
    @NotNull
    private static final ConcurrentHashMap<String, VideoDownloadBean> activeTasks = new ConcurrentHashMap();
    @NotNull
    private static final Lazy context$delegate = LazyKt.lazy(VideoPreloadManager::context_delegate$lambda$0);
    @NotNull
    private static final HandlerThread videoPreloadThread = new HandlerThread("VideoPreloadUtil");
    @NotNull
    private static final Handler handler;
    private static final long updateInterval;
    @NotNull
    private static final Function0<Unit> updateIntervalRunnable;
    @NotNull
    private static final listener.1 listener;
    private static boolean isStartLoop;

    private VideoPreloadManager() {
    }

    private final Context getContext() {
        Lazy lazy = context$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Context)object;
    }

    private final void startLoop() {
        if (isStartLoop) {
            return;
        }
        isStartLoop = true;
        this.loop();
    }

    private final void stopLoop() {
        isStartLoop = false;
        handler.removeCallbacks(() -> VideoPreloadManager.stopLoop$lambda$3(updateIntervalRunnable));
    }

    private final void loop() {
        handler.removeCallbacks(() -> VideoPreloadManager.loop$lambda$4(updateIntervalRunnable));
        handler.postDelayed(() -> VideoPreloadManager.loop$lambda$5(updateIntervalRunnable), updateInterval);
    }

    public final void preloadVideo(@NotNull MediaSource shortTVItem) {
        Intrinsics.checkNotNullParameter((Object)shortTVItem, (String)"shortTVItem");
        this.runOnPreloadThread(() -> VideoPreloadManager.preloadVideo$lambda$6(shortTVItem));
    }

    @NotNull
    public final VideoDownloadBean preloadVideoAsync(@NotNull MediaSource shortTVItem) {
        Intrinsics.checkNotNullParameter((Object)shortTVItem, (String)"shortTVItem");
        VideoDownloadBean shortTVDownloadBean = this.createDownloadRequest(shortTVItem);
        this.preloadVideo(shortTVDownloadBean);
        return shortTVDownloadBean;
    }

    @NotNull
    public final VideoDownloadBean preloadVideo(@NotNull VideoDownloadBean shortTVDownloadBean) {
        Intrinsics.checkNotNullParameter((Object)shortTVDownloadBean, (String)"shortTVDownloadBean");
        this.runOnPreloadThread(() -> VideoPreloadManager.preloadVideo$lambda$7(shortTVDownloadBean));
        return shortTVDownloadBean;
    }

    public final void stopPreload(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.runOnPreloadThread(() -> VideoPreloadManager.stopPreload$lambda$8(key));
    }

    public final void removePreload(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        activeTasks.remove(key);
        this.runOnPreloadThread(() -> VideoPreloadManager.removePreload$lambda$9(key));
    }

    public final void stopALlPreload() {
        ORPlayerLog.e$default(ORPlayerLog.INSTANCE, TAG, "stopALlPreload  ", false, 4, null);
        DownloadService.sendSetStopReason((Context)this.getContext(), DemoDownloadService.class, null, (int)10086, (boolean)false);
    }

    @NotNull
    public final VideoDownloadBean createDownloadRequest(@NotNull MediaSource shortTVItem) {
        Intrinsics.checkNotNullParameter((Object)shortTVItem, (String)"shortTVItem");
        VideoDownloadBean data = activeTasks.get(shortTVItem.getKey());
        if (data != null) {
            ORPlayerLog.d$default(ORPlayerLog.INSTANCE, TAG, "createDownloadRequest [from map]  shortTVItem:" + shortTVItem, false, 4, null);
            return data;
        }
        Download currentDownload = DemoUtil.getDownloadManager((Context)Utils.getApp()).getDownloadIndex().getDownload(shortTVItem.getKey());
        Download download = currentDownload;
        if (Intrinsics.areEqual((Object)(download != null && (download = download.request) != null ? download.id : null), (Object)shortTVItem.getKey())) {
            ORPlayerLog.d$default(ORPlayerLog.INSTANCE, TAG, "createDownloadRequest [from currentDownloads]   shortTVItem:" + shortTVItem, false, 4, null);
            String string2 = shortTVItem.getKey();
            String string3 = shortTVItem.getUrl();
            DownloadRequest downloadRequest = currentDownload.request;
            Intrinsics.checkNotNullExpressionValue((Object)downloadRequest, (String)"request");
            return new VideoDownloadBean(string2, string3, downloadRequest, currentDownload.contentLength, currentDownload.getBytesDownloaded(), 307200L, true);
        }
        String cacheKey = shortTVItem.getKey();
        String url = shortTVItem.getUrl();
        DownloadRequest downloadRequest = new DownloadRequest.Builder(cacheKey, Uri.parse((String)url)).setCustomCacheKey(cacheKey).build();
        Intrinsics.checkNotNullExpressionValue((Object)downloadRequest, (String)"build(...)");
        VideoDownloadBean shortTVDownloadBean = new VideoDownloadBean(cacheKey, url, downloadRequest, -1L, 0L, 307200L, false);
        ((Map)activeTasks).put(cacheKey, shortTVDownloadBean);
        ORPlayerLog.d$default(ORPlayerLog.INSTANCE, TAG, "createDownloadRequest [from new]  shortTVItem:" + shortTVItem, false, 4, null);
        return shortTVDownloadBean;
    }

    public final boolean isCache(@Nullable String url) {
        CharSequence charSequence = url;
        return charSequence == null || charSequence.length() == 0 ? false : (StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null) ? DemoUtil.getDownloadCache((Context)Utils.getApp()).isCached(this.urlToCacheKey(url), 0L, 200L) : true);
    }

    @NotNull
    public final String urlToCacheKey(@Nullable String url) {
        String string2;
        int index;
        String string3 = url;
        int n = index = string3 != null ? StringsKt.indexOf$default((CharSequence)string3, (String)"?", (int)0, (boolean)false, (int)6, null) : -1;
        if (url != null && index >= 0) {
            String[] stringArray = new String[]{"?"};
            string2 = MD5.Companion.getStringMD5((String)StringsKt.split$default((CharSequence)url, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0));
        } else {
            String string4 = url;
            if (string4 == null) {
                string4 = "";
            }
            string2 = MD5.Companion.getStringMD5(string4);
        }
        String key = string2;
        return key;
    }

    public final void runOnPreloadThread(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        handler.post(runnable);
    }

    private static final Application context_delegate$lambda$0() {
        return Utils.getApp();
    }

    private static final Unit updateIntervalRunnable$lambda$2() {
        for (Object e : DemoUtil.getDownloadManager(INSTANCE.getContext()).getCurrentDownloads()) {
            VideoDownloadBean videoDownloadBean;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Download currentDownload = (Download)e;
            if (currentDownload.state != 2) continue;
            Log.d((String)TAG, (String)("progress 111:  download.requestId:" + currentDownload.request.id + "     bytesDownloaded:" + currentDownload.getBytesDownloaded() + "  contentLength:" + currentDownload.contentLength + "  percentDownloaded:" + currentDownload.getPercentDownloaded()));
            if (activeTasks.get(currentDownload.request.id) == null) continue;
            VideoDownloadBean $this$updateIntervalRunnable_u24lambda_u242_u24lambda_u241 = videoDownloadBean;
            boolean bl = false;
            $this$updateIntervalRunnable_u24lambda_u242_u24lambda_u241.setDownloadLength(currentDownload.getBytesDownloaded());
            $this$updateIntervalRunnable_u24lambda_u242_u24lambda_u241.setContentLength(currentDownload.contentLength);
            long l = $this$updateIntervalRunnable_u24lambda_u242_u24lambda_u241.getDownloadLength();
            long l2 = $this$updateIntervalRunnable_u24lambda_u242_u24lambda_u241.getMaxLength();
            boolean bl2 = 1L <= l2 ? l2 < l : false;
            if (!bl2) continue;
            String string2 = $this$updateIntervalRunnable_u24lambda_u242_u24lambda_u241.getRequest().id;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
            INSTANCE.removePreload(string2);
        }
        if (isStartLoop) {
            INSTANCE.loop();
        }
        return Unit.INSTANCE;
    }

    private static final void stopLoop$lambda$3(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void loop$lambda$4(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void loop$lambda$5(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void preloadVideo$lambda$6(MediaSource $shortTVItem) {
        VideoDownloadBean shortTVDownloadBean = INSTANCE.createDownloadRequest($shortTVItem);
        INSTANCE.preloadVideo(shortTVDownloadBean);
    }

    private static final void preloadVideo$lambda$7(VideoDownloadBean $shortTVDownloadBean) {
        Log.e((String)TAG, (String)("preloadVideo id:" + $shortTVDownloadBean.getId() + " downloadLength:" + $shortTVDownloadBean.getDownloadLength() + "  maxLength:" + $shortTVDownloadBean.getMaxLength() + " contentLength:" + $shortTVDownloadBean.getContentLength()));
        if ($shortTVDownloadBean.getMaxLength() == -1L || $shortTVDownloadBean.getDownloadLength() < $shortTVDownloadBean.getMaxLength()) {
            if ($shortTVDownloadBean.isAdd()) {
                DownloadService.sendSetStopReason((Context)INSTANCE.getContext(), DemoDownloadService.class, (String)$shortTVDownloadBean.getId(), (int)0, (boolean)false);
                v0 = Log.e((String)TAG, (String)("checkToStart restart  shortTVItem:" + $shortTVDownloadBean));
            } else {
                DownloadService.sendAddDownload((Context)INSTANCE.getContext(), DemoDownloadService.class, (DownloadRequest)$shortTVDownloadBean.getRequest(), (boolean)false);
                v0 = Log.e((String)TAG, (String)("checkToStart add    shortTVItem:" + $shortTVDownloadBean));
            }
        }
    }

    private static final void stopPreload$lambda$8(String $key) {
        ORPlayerLog.e$default(ORPlayerLog.INSTANCE, TAG, "stopPreload   key:" + $key, false, 4, null);
        DownloadService.sendSetStopReason((Context)INSTANCE.getContext(), DemoDownloadService.class, (String)$key, (int)10086, (boolean)false);
    }

    private static final void removePreload$lambda$9(String $key) {
        ORPlayerLog.e$default(ORPlayerLog.INSTANCE, TAG, "removePreload   key:" + $key, false, 4, null);
        DownloadService.sendRemoveDownload((Context)INSTANCE.getContext(), DemoDownloadService.class, (String)$key, (boolean)false);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getActiveTasks$p() {
        return activeTasks;
    }

    public static final /* synthetic */ void access$startLoop(VideoPreloadManager $this) {
        $this.startLoop();
    }

    public static final /* synthetic */ void access$stopLoop(VideoPreloadManager $this) {
        $this.stopLoop();
    }

    static {
        updateInterval = 100L;
        updateIntervalRunnable = VideoPreloadManager::updateIntervalRunnable$lambda$2;
        listener = new DownloadManager.Listener(){

            public void onInitialized(DownloadManager downloadManager) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
            }

            public void onDownloadChanged(DownloadManager downloadManager, Download download, Exception finalException) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)download, (String)"download");
                Log.e((String)"VideoPreloadUtil", (String)("onDownloadChanged:  download.requestId:" + download.request.id + "     bytesDownloaded:" + download.getBytesDownloaded() + "  contentLength:" + download.contentLength + "  percentDownloaded:" + download.getPercentDownloaded()));
                VideoDownloadBean videoDownloadBean = (VideoDownloadBean)VideoPreloadManager.access$getActiveTasks$p().get(download.request.id);
                if (videoDownloadBean != null) {
                    VideoDownloadBean videoDownloadBean2;
                    VideoDownloadBean $this$onDownloadChanged_u24lambda_u240 = videoDownloadBean2 = videoDownloadBean;
                    boolean bl = false;
                    $this$onDownloadChanged_u24lambda_u240.setDownloadLength(download.getBytesDownloaded());
                    $this$onDownloadChanged_u24lambda_u240.setContentLength(download.contentLength);
                    if (download.state == 2) {
                        long l = $this$onDownloadChanged_u24lambda_u240.getDownloadLength();
                        long l2 = $this$onDownloadChanged_u24lambda_u240.getMaxLength();
                        boolean bl2 = 1L <= l2 ? l2 < l : false;
                        if (bl2) {
                            String string2 = $this$onDownloadChanged_u24lambda_u240.getRequest().id;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
                            VideoPreloadManager.INSTANCE.stopPreload(string2);
                        }
                    } else if (download.state == 1 || download.state == 3) {
                        String string3 = $this$onDownloadChanged_u24lambda_u240.getRequest().id;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"id");
                        VideoPreloadManager.INSTANCE.removePreload(string3);
                    }
                }
                VideoPreloadManager.access$startLoop(VideoPreloadManager.INSTANCE);
            }

            public void onIdle(DownloadManager downloadManager) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Log.e((String)"VideoPreloadUtil", (String)"onIdle:");
                VideoPreloadManager.access$stopLoop(VideoPreloadManager.INSTANCE);
            }

            public void onDownloadsPausedChanged(DownloadManager downloadManager, boolean downloadsPaused) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Log.e((String)"VideoPreloadUtil", (String)"onDownloadsPausedChanged:");
            }

            public void onDownloadRemoved(DownloadManager downloadManager, Download download) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)download, (String)"download");
                Log.e((String)"VideoPreloadUtil", (String)"onDownloadRemoved:");
            }

            public void onRequirementsStateChanged(DownloadManager downloadManager, Requirements requirements, int notMetRequirements) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
                Log.e((String)"VideoPreloadUtil", (String)"onRequirementsStateChanged:");
            }

            public void onWaitingForRequirementsChanged(DownloadManager downloadManager, boolean waitingForRequirements) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Log.e((String)"VideoPreloadUtil", (String)"onWaitingForRequirementsChanged:");
            }
        };
        videoPreloadThread.start();
        Looper looper = videoPreloadThread.getLooper();
        handler = new Handler(looper){

            public void dispatchMessage(Message msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                try {
                    super.dispatchMessage(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        DemoUtil.getDownloadManager(INSTANCE.getContext()).addListener((DownloadManager.Listener)listener);
    }
}

