/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.utils;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.blankj.utilcode.util.BarUtils;
import com.transsion.player.utils.PlayerOrientationEventListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/transsion/player/utils/LandSpaceHelper;", "", "startView", "Landroid/view/View;", "endView", "<init>", "(Landroid/view/View;Landroid/view/View;)V", "curIsLand", "", "onScreenChange", "", "isLand", "enable", "disable", "orientationEventListener", "Lcom/transsion/player/utils/PlayerOrientationEventListener;", "getOrientationEventListener", "()Lcom/transsion/player/utils/PlayerOrientationEventListener;", "orientationEventListener$delegate", "Lkotlin/Lazy;", "setSpace", "rotation", "", "Player_release"})
public final class LandSpaceHelper {
    @NotNull
    private final View startView;
    @NotNull
    private final View endView;
    private boolean curIsLand;
    @NotNull
    private final Lazy orientationEventListener$delegate;

    public LandSpaceHelper(@NotNull View startView, @NotNull View endView) {
        Intrinsics.checkNotNullParameter((Object)startView, (String)"startView");
        Intrinsics.checkNotNullParameter((Object)endView, (String)"endView");
        this.startView = startView;
        this.endView = endView;
        this.orientationEventListener$delegate = LazyKt.lazy(() -> LandSpaceHelper.orientationEventListener_delegate$lambda$1(this));
    }

    public final void onScreenChange(boolean isLand) {
        this.curIsLand = isLand;
        int rotation = isLand ? 1 : 0;
        this.setSpace(isLand, rotation);
    }

    public final void enable() {
        block0: {
            PlayerOrientationEventListener playerOrientationEventListener = this.getOrientationEventListener();
            if (playerOrientationEventListener == null) break block0;
            playerOrientationEventListener.enable();
        }
    }

    public final void disable() {
        block0: {
            PlayerOrientationEventListener playerOrientationEventListener = this.getOrientationEventListener();
            if (playerOrientationEventListener == null) break block0;
            playerOrientationEventListener.disable();
        }
    }

    private final PlayerOrientationEventListener getOrientationEventListener() {
        Lazy lazy = this.orientationEventListener$delegate;
        return (PlayerOrientationEventListener)((Object)lazy.getValue());
    }

    private final void setSpace(boolean isLand, int rotation) {
        int spaceStart;
        int space = BarUtils.getStatusBarHeight();
        int n = isLand ? (rotation == 1 ? space : 0) : (spaceStart = 0);
        int spaceEnd = isLand ? (rotation == 3 ? space : 0) : 0;
        ViewGroup.LayoutParams lpStart = this.startView.getLayoutParams();
        lpStart.width = spaceStart;
        this.startView.setLayoutParams(lpStart);
        ViewGroup.LayoutParams lpEnd = this.endView.getLayoutParams();
        lpEnd.width = spaceEnd;
        this.endView.setLayoutParams(lpEnd);
    }

    private static final Unit orientationEventListener_delegate$lambda$1$lambda$0(LandSpaceHelper this$0, int rotation) {
        switch (rotation) {
            case 0: 
            case 1: 
            case 3: {
                this$0.setSpace(this$0.curIsLand, rotation);
            }
        }
        return Unit.INSTANCE;
    }

    private static final PlayerOrientationEventListener orientationEventListener_delegate$lambda$1(LandSpaceHelper this$0) {
        Context context = this$0.startView.getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Activity");
        return new PlayerOrientationEventListener((Activity)context, (Function1<? super Integer, Unit>)((Function1)arg_0 -> LandSpaceHelper.orientationEventListener_delegate$lambda$1$lambda$0(this$0, arg_0)));
    }
}

