package com.transsion.player.control

import android.view.View
import android.view.animation.Animation
import com.transsion.player.enum.PipStatus

/**
 *
 * Created by kun.xu on 2024/11/14 20:08
 * Description:
 *IControlComponent
 */
interface IControlComponent<Data, PlayStatus> {

    fun setVideoData(videoData: Data) = Unit

    /**
     * 将 ControlWrapper 传递到当前 ControlComponent 中
     */
    fun attach(controlWrapper: ControlWrapper<Data,PlayStatus>)

    /**
     * 如果 ControlComponent 是 View，返回当前控件（this）即可
     * 如果不是，返回null
     */
    fun getView(): View?

    fun release()

    /**
     * 回调控制器显示和隐藏状态，
     * 此方法可用于控制 ControlComponent 中的控件的跟随手指点击显示和隐藏
     * @param isVisible true 代表要显示， false 代表要隐藏
     * @param anim 显示和隐藏的动画，是一个补间Alpha动画
     */
    fun onVisibilityChanged(isVisible: Boolean, anim: Animation?) = Unit

    /**
     * 回调播放器的播放器状态
     * @param playState 播放状态
     */
    fun onPlayStateChanged(playState: PlayStatus) = Unit

    fun onFullscreenChanged(fullscreen: Boolean, land: Boolean) = Unit

    /**
     * 回调控制器是否被锁定，锁定后会产生如下影响：
     * 无法响应滑动手势，双击事件，点击显示和隐藏控制UI，跟随重力感应切换横竖屏
     * @param isLocked 是否锁定
     */
    fun onLockStateChanged(isLocked: Boolean) = Unit

    fun onPipStatusChange(pipStatus: PipStatus) = Unit
}