/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.decoder.av1;

import android.os.Handler;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.TraceUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.CryptoConfig;
import androidx.media3.decoder.VideoDecoderOutputBuffer;
import androidx.media3.decoder.av1.Gav1Decoder;
import androidx.media3.decoder.av1.Gav1DecoderException;
import androidx.media3.decoder.av1.Gav1Library;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.video.DecoderVideoRenderer;
import androidx.media3.exoplayer.video.VideoRendererEventListener;

@UnstableApi
public class Libgav1VideoRenderer
extends DecoderVideoRenderer {
    public static final int THREAD_COUNT_AUTODETECT = 0;
    private static final String TAG = "Libgav1VideoRenderer";
    private static final int DEFAULT_NUM_OF_INPUT_BUFFERS = 4;
    private static final int DEFAULT_NUM_OF_OUTPUT_BUFFERS = 4;
    private static final int DEFAULT_INPUT_BUFFER_SIZE = Util.ceilDivide((int)1280, (int)64) * Util.ceilDivide((int)720, (int)64) * 6144 / 2;
    private final int numInputBuffers;
    private final int numOutputBuffers;
    private final int threads;
    @Nullable
    private Gav1Decoder decoder;

    public Libgav1VideoRenderer(long allowedJoiningTimeMs, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify) {
        this(allowedJoiningTimeMs, eventHandler, eventListener, maxDroppedFramesToNotify, 0, 4, 4);
    }

    public Libgav1VideoRenderer(long allowedJoiningTimeMs, @Nullable Handler eventHandler, @Nullable VideoRendererEventListener eventListener, int maxDroppedFramesToNotify, int threads, int numInputBuffers, int numOutputBuffers) {
        super(allowedJoiningTimeMs, eventHandler, eventListener, maxDroppedFramesToNotify);
        this.threads = threads;
        this.numInputBuffers = numInputBuffers;
        this.numOutputBuffers = numOutputBuffers;
    }

    public String getName() {
        return TAG;
    }

    public final int supportsFormat(Format format) {
        if (!"video/av01".equalsIgnoreCase(format.sampleMimeType) || !Gav1Library.isAvailable()) {
            return Libgav1VideoRenderer.createCapabilities(0);
        }
        if (format.cryptoType != 0) {
            return Libgav1VideoRenderer.createCapabilities(2);
        }
        return Libgav1VideoRenderer.createCapabilities(4, 16, 0);
    }

    private static int createCapabilities(int formatSupport, int adaptiveSupport, int tunnelingSupport) {
        return formatSupport | adaptiveSupport << 4 | tunnelingSupport << 8;
    }

    private static int createCapabilities(int formatSupport) {
        return Libgav1VideoRenderer.createCapabilities(formatSupport, 0, 0);
    }

    protected final Gav1Decoder createDecoder(Format format, @Nullable CryptoConfig cryptoConfig) throws Gav1DecoderException {
        Gav1Decoder decoder;
        TraceUtil.beginSection((String)"createGav1Decoder");
        int initialInputBufferSize = format.maxInputSize != -1 ? format.maxInputSize : DEFAULT_INPUT_BUFFER_SIZE;
        this.decoder = decoder = new Gav1Decoder(this.numInputBuffers, this.numOutputBuffers, initialInputBufferSize, this.threads);
        TraceUtil.endSection();
        return decoder;
    }

    protected void renderOutputBufferToSurface(VideoDecoderOutputBuffer outputBuffer, Surface surface) throws Gav1DecoderException {
        if (this.decoder == null) {
            throw new Gav1DecoderException("Failed to render output buffer to surface: decoder is not initialized.");
        }
        this.decoder.renderToSurface(outputBuffer, surface);
        outputBuffer.release();
    }

    protected void setDecoderOutputMode(int outputMode) {
        if (this.decoder != null) {
            this.decoder.setOutputMode(outputMode);
        }
    }

    protected DecoderReuseEvaluation canReuseDecoder(String decoderName, Format oldFormat, Format newFormat) {
        return new DecoderReuseEvaluation(decoderName, oldFormat, newFormat, 3, 0);
    }
}

