/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.exo;

import android.app.Notification;
import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.offline.Download;
import androidx.media3.exoplayer.offline.DownloadManager;
import androidx.media3.exoplayer.offline.DownloadNotificationHelper;
import androidx.media3.exoplayer.offline.DownloadService;
import androidx.media3.exoplayer.scheduler.PlatformScheduler;
import androidx.media3.exoplayer.scheduler.Requirements;
import androidx.media3.exoplayer.scheduler.Scheduler;
import com.transsion.player.R;
import com.transsion.player.exo.DemoUtil;
import java.util.List;

@OptIn(markerClass={UnstableApi.class})
public class DemoDownloadService
extends DownloadService {
    private static final int JOB_ID = 1;
    private static final int FOREGROUND_NOTIFICATION_ID = 1;

    public DemoDownloadService() {
        super(0, 1000L, "download_channel", R.string.exo_download_notification_channel_name, 0);
    }

    protected DownloadManager getDownloadManager() {
        DownloadManager downloadManager = DemoUtil.getDownloadManager((Context)this);
        DownloadNotificationHelper downloadNotificationHelper = DemoUtil.getDownloadNotificationHelper((Context)this);
        return downloadManager;
    }

    protected Scheduler getScheduler() {
        return Util.SDK_INT >= 21 ? new PlatformScheduler((Context)this, 1) : null;
    }

    protected Notification getForegroundNotification(List<Download> downloads, int notMetRequirements) {
        return DemoUtil.getDownloadNotificationHelper((Context)this).buildProgressNotification((Context)this, R.mipmap.player_ic_download, null, null, downloads, notMetRequirements);
    }

    private static final class TerminalStateNotificationHelper
    implements DownloadManager.Listener {
        private final Context context;
        private final DownloadNotificationHelper notificationHelper;
        private int nextNotificationId;

        public TerminalStateNotificationHelper(Context context, DownloadNotificationHelper notificationHelper, int firstNotificationId) {
            this.context = context.getApplicationContext();
            this.notificationHelper = notificationHelper;
            this.nextNotificationId = firstNotificationId;
        }

        public void onInitialized(DownloadManager downloadManager) {
        }

        public void onDownloadsPausedChanged(DownloadManager downloadManager, boolean downloadsPaused) {
        }

        public void onDownloadChanged(DownloadManager downloadManager, Download download, @Nullable Exception finalException) {
        }

        public void onDownloadRemoved(DownloadManager downloadManager, Download download) {
        }

        public void onIdle(DownloadManager downloadManager) {
        }

        public void onRequirementsStateChanged(DownloadManager downloadManager, Requirements requirements, int notMetRequirements) {
        }

        public void onWaitingForRequirementsChanged(DownloadManager downloadManager, boolean waitingForRequirements) {
        }
    }
}

