/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.exo;

import android.content.Context;
import androidx.annotation.OptIn;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.database.DatabaseProvider;
import androidx.media3.database.StandaloneDatabaseProvider;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultDataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.datasource.cache.Cache;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.datasource.cache.CacheEvictor;
import androidx.media3.datasource.cache.LeastRecentlyUsedCacheEvictor;
import androidx.media3.datasource.cache.SimpleCache;
import androidx.media3.datasource.cronet.CronetDataSource;
import androidx.media3.datasource.cronet.CronetUtil;
import androidx.media3.exoplayer.RenderersFactory;
import androidx.media3.exoplayer.offline.DefaultDownloadIndex;
import androidx.media3.exoplayer.offline.DownloadManager;
import androidx.media3.exoplayer.offline.DownloadNotificationHelper;
import androidx.media3.exoplayer.offline.DownloaderFactory;
import androidx.media3.exoplayer.offline.WritableDownloadIndex;
import com.transsion.player.exo.ORExoDecoderType;
import com.transsion.player.exo.ORRenderersFactory;
import com.transsion.player.shorttv.preload.VideoDownloadFactory;
import java.io.File;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.chromium.net.CronetEngine;

@UnstableApi
public final class DemoUtil {
    public static final String DOWNLOAD_NOTIFICATION_CHANNEL_ID = "download_channel";
    private static final boolean USE_CRONET_FOR_NETWORKING = true;
    private static final String TAG = "DemoUtil";
    private static final String DOWNLOAD_CONTENT_DIRECTORY = "downloads";
    private static // Could not load outer class - annotation placement on inner may be incorrect
     @MonotonicNonNull DataSource.Factory dataSourceFactory;
    private static // Could not load outer class - annotation placement on inner may be incorrect
     @MonotonicNonNull DataSource.Factory httpDataSourceFactory;
    private static @MonotonicNonNull DatabaseProvider databaseProvider;
    private static @MonotonicNonNull File downloadDirectory;
    private static @MonotonicNonNull Cache downloadCache;
    private static @MonotonicNonNull DownloadManager downloadManager;
    private static @MonotonicNonNull DownloadNotificationHelper downloadNotificationHelper;

    @OptIn(markerClass={UnstableApi.class})
    public static RenderersFactory buildRenderersFactory(Context context, ORExoDecoderType extRendererType) {
        int extensionRendererMode = switch (extRendererType) {
            default -> throw new IncompatibleClassChangeError();
            case ORExoDecoderType.HARDWARE -> 1;
            case ORExoDecoderType.FFMPEG, ORExoDecoderType.AV1 -> 2;
        };
        return new ORRenderersFactory(context.getApplicationContext(), extRendererType).setEnableDecoderFallback(true).setExtensionRendererMode(extensionRendererMode).forceEnableMediaCodecAsynchronousQueueing();
    }

    public static synchronized DataSource.Factory getHttpDataSourceFactory(Context context) {
        if (httpDataSourceFactory == null) {
            CronetEngine cronetEngine = CronetUtil.buildCronetEngine((Context)(context = context.getApplicationContext()));
            if (cronetEngine != null) {
                httpDataSourceFactory = new CronetDataSource.Factory(cronetEngine, (Executor)Executors.newSingleThreadExecutor());
            }
            if (httpDataSourceFactory == null) {
                CookieManager cookieManager = new CookieManager();
                cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
                CookieHandler.setDefault(cookieManager);
                httpDataSourceFactory = new DefaultHttpDataSource.Factory();
            }
        }
        return httpDataSourceFactory;
    }

    public static synchronized DataSource.Factory getDataSourceFactory(Context context) {
        if (dataSourceFactory == null) {
            context = context.getApplicationContext();
            DefaultDataSource.Factory upstreamFactory = new DefaultDataSource.Factory(context, DemoUtil.getHttpDataSourceFactory(context));
            dataSourceFactory = DemoUtil.buildReadOnlyCacheDataSource((DataSource.Factory)upstreamFactory, DemoUtil.getDownloadCache(context));
        }
        return dataSourceFactory;
    }

    @OptIn(markerClass={UnstableApi.class})
    public static synchronized DownloadNotificationHelper getDownloadNotificationHelper(Context context) {
        if (downloadNotificationHelper == null) {
            downloadNotificationHelper = new DownloadNotificationHelper(context, DOWNLOAD_NOTIFICATION_CHANNEL_ID);
        }
        return downloadNotificationHelper;
    }

    public static synchronized DownloadManager getDownloadManager(Context context) {
        DemoUtil.ensureDownloadManagerInitialized(context);
        return downloadManager;
    }

    @OptIn(markerClass={UnstableApi.class})
    public static synchronized Cache getDownloadCache(Context context) {
        if (downloadCache == null) {
            File downloadContentDirectory = new File(DemoUtil.getDownloadDirectory(context), DOWNLOAD_CONTENT_DIRECTORY);
            downloadCache = new SimpleCache(downloadContentDirectory, (CacheEvictor)new LeastRecentlyUsedCacheEvictor(314572800L), DemoUtil.getDatabaseProvider(context));
        }
        return downloadCache;
    }

    @OptIn(markerClass={UnstableApi.class})
    private static synchronized void ensureDownloadManagerInitialized(Context context) {
        if (downloadManager == null) {
            VideoDownloadFactory downloaderFactory = new VideoDownloadFactory(new CacheDataSource.Factory().setCache(DemoUtil.getDownloadCache(context)).setUpstreamDataSourceFactory(DemoUtil.getHttpDataSourceFactory(context)), Executors.newFixedThreadPool(6));
            downloadManager = new DownloadManager(context, (WritableDownloadIndex)new DefaultDownloadIndex(DemoUtil.getDatabaseProvider(context)), (DownloaderFactory)downloaderFactory);
            downloadManager.removeAllDownloads();
        }
    }

    @OptIn(markerClass={UnstableApi.class})
    private static synchronized DatabaseProvider getDatabaseProvider(Context context) {
        if (databaseProvider == null) {
            databaseProvider = new StandaloneDatabaseProvider(context);
        }
        return databaseProvider;
    }

    private static synchronized File getDownloadDirectory(Context context) {
        if (downloadDirectory == null && (downloadDirectory = context.getExternalFilesDir(null)) == null) {
            downloadDirectory = context.getFilesDir();
        }
        return downloadDirectory;
    }

    @OptIn(markerClass={UnstableApi.class})
    private static CacheDataSource.Factory buildReadOnlyCacheDataSource(DataSource.Factory upstreamFactory, Cache cache) {
        return new CacheDataSource.Factory().setCache(cache).setUpstreamDataSourceFactory(upstreamFactory);
    }

    private DemoUtil() {
    }
}

