/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.shorttv.preload;

import android.content.Context;
import android.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.offline.Download;
import androidx.media3.exoplayer.offline.DownloadManager;
import androidx.media3.exoplayer.scheduler.Requirements;
import com.transsion.player.MediaSource;
import com.transsion.player.exo.DemoUtil;
import com.transsion.player.shorttv.preload.VideoDownloadBean;
import com.transsion.player.shorttv.preload.VideoPreloadHelper;
import com.transsion.player.shorttv.preload.VideoPreloadManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010*\u0001\u000e\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\fJ\u0006\u0010\u001a\u001a\u00020\u0014J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0006\u0010\u001f\u001a\u00020\u0014J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\bJ\u0016\u0010 \u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\n2\u0006\u0010!\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/transsion/player/shorttv/preload/VideoPreloadHelper;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "shortTVItemList", "", "Lcom/transsion/player/MediaSource;", "currentPosition", "", "currentDownloadingUuid", "", "listener", "com/transsion/player/shorttv/preload/VideoPreloadHelper$listener$1", "Lcom/transsion/player/shorttv/preload/VideoPreloadHelper$listener$1;", "activeTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/transsion/player/shorttv/preload/VideoDownloadBean;", "changeSelect", "", "position", "pause", "resume", "remove", "key", "loadNext", "createDownloadRequest", "shortTVItem", "checkToPause", "checkToStart", "release", "add", "mediaSource", "index", "Companion", "Player_release"})
@UnstableApi
public final class VideoPreloadHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final List<MediaSource> shortTVItemList;
    private int currentPosition;
    @Nullable
    private String currentDownloadingUuid;
    @NotNull
    private final listener.1 listener;
    @NotNull
    private final ConcurrentHashMap<String, VideoDownloadBean> activeTasks;
    public static final int PRELOAD_COUNT = 5;
    public static final long PRELOAD_FIRST_SIZE = 307200L;
    public static final int PAUSE_REASON = 10086;
    public static final boolean PRELOAD_ALL = false;
    @NotNull
    public static final String TAG = "VideoPreloadHelper";

    public VideoPreloadHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.shortTVItemList = new CopyOnWriteArrayList();
        this.listener = new DownloadManager.Listener(this){
            final /* synthetic */ VideoPreloadHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onInitialized(DownloadManager downloadManager) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
            }

            public void onDownloadsPausedChanged(DownloadManager downloadManager, boolean downloadsPaused) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
            }

            public void onDownloadChanged(DownloadManager downloadManager, Download download, Exception finalException) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)download, (String)"download");
                Log.e((String)"VideoPreloadHelper", (String)("onDownloadChanged:  download.requestId:" + download.request.id + "     bytesDownloaded:" + download.getBytesDownloaded() + "  contentLength:" + download.contentLength + "  percentDownloaded:" + download.getPercentDownloaded()));
                VideoDownloadBean videoDownloadBean = (VideoDownloadBean)VideoPreloadHelper.access$getActiveTasks$p(this.this$0).get(download.request.id);
                if (videoDownloadBean != null) {
                    VideoDownloadBean videoDownloadBean2;
                    VideoDownloadBean $this$onDownloadChanged_u24lambda_u240 = videoDownloadBean2 = videoDownloadBean;
                    boolean bl = false;
                    $this$onDownloadChanged_u24lambda_u240.setDownloadLength(download.getBytesDownloaded());
                    $this$onDownloadChanged_u24lambda_u240.setContentLength(download.contentLength);
                }
                if (Intrinsics.areEqual((Object)download.request.id, (Object)VideoPreloadHelper.access$getCurrentDownloadingUuid$p(this.this$0)) && (download.state == 1 || download.state == 3 || download.state == 4)) {
                    VideoPreloadHelper.access$setCurrentDownloadingUuid$p(this.this$0, null);
                    this.this$0.loadNext();
                }
            }

            public void onDownloadRemoved(DownloadManager downloadManager, Download download) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)download, (String)"download");
            }

            public void onIdle(DownloadManager downloadManager) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Log.e((String)"VideoPreloadHelper", (String)"onIdle:");
                this.this$0.loadNext();
            }

            public void onRequirementsStateChanged(DownloadManager downloadManager, Requirements requirements, int notMetRequirements) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
            }

            public void onWaitingForRequirementsChanged(DownloadManager downloadManager, boolean waitingForRequirements) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
            }
        };
        this.activeTasks = new ConcurrentHashMap();
        DemoUtil.getDownloadManager(this.context).addListener((DownloadManager.Listener)this.listener);
    }

    public final void changeSelect(int position) {
        Log.e((String)TAG, (String)("changeSelect  position:" + position));
        if (this.currentPosition == position) {
            return;
        }
        this.currentDownloadingUuid = null;
        this.currentPosition = position;
        this.checkToPause(this.currentPosition);
        this.checkToStart(this.currentPosition + 1);
    }

    public final void pause() {
        this.checkToPause(this.currentPosition);
        this.currentPosition = -1;
    }

    public final void resume(int position) {
        this.checkToStart(position);
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.activeTasks.remove(key);
        VideoPreloadManager.INSTANCE.removePreload(key);
    }

    public final void loadNext() {
        if (this.currentPosition < 0) {
            return;
        }
        int position = this.currentPosition;
        if (this.currentDownloadingUuid != null) {
            return;
        }
        VideoPreloadManager.INSTANCE.runOnPreloadThread(() -> VideoPreloadHelper.loadNext$lambda$2(this, position));
    }

    private final VideoDownloadBean createDownloadRequest(int position, MediaSource shortTVItem) {
        VideoDownloadBean data = this.activeTasks.get(shortTVItem.getKey());
        if (data != null) {
            Log.e((String)TAG, (String)("createDownloadRequest [from map] position:" + position + "  shortTVItem:" + shortTVItem));
            return data;
        }
        String cacheKey = shortTVItem.getKey();
        VideoDownloadBean shortTVDownloadBean = VideoPreloadManager.INSTANCE.createDownloadRequest(shortTVItem);
        ((Map)this.activeTasks).put(cacheKey, shortTVDownloadBean);
        Log.e((String)TAG, (String)("createDownloadRequest [from new] position:" + position + "  shortTVItem:" + shortTVItem));
        return shortTVDownloadBean;
    }

    private final void checkToPause(int position) {
        boolean bl = 0 <= position ? position < this.shortTVItemList.size() : false;
        if (bl) {
            MediaSource mediaSource = this.shortTVItemList.get(position);
            if (mediaSource == null) {
                return;
            }
            MediaSource shortTVItem = mediaSource;
            Log.e((String)TAG, (String)("checkToPause   position:" + position + "  shortTVItem:" + shortTVItem));
            VideoPreloadManager.INSTANCE.stopPreload(shortTVItem.getKey());
        }
    }

    private final void checkToStart(int position) {
        boolean bl = 0 <= position ? position < this.shortTVItemList.size() : false;
        if (bl) {
            MediaSource mediaSource = this.shortTVItemList.get(position);
            if (mediaSource == null) {
                return;
            }
            MediaSource shortTVItem = mediaSource;
            VideoPreloadManager.INSTANCE.runOnPreloadThread(() -> VideoPreloadHelper.checkToStart$lambda$4(shortTVItem, this));
        }
    }

    public final void release() {
        DemoUtil.getDownloadManager(this.context).removeListener((DownloadManager.Listener)this.listener);
        this.pause();
    }

    public final void add(@NotNull MediaSource mediaSource) {
        Intrinsics.checkNotNullParameter((Object)mediaSource, (String)"mediaSource");
        this.shortTVItemList.add(mediaSource);
        this.loadNext();
    }

    public final void add(int index, @NotNull MediaSource mediaSource) {
        Intrinsics.checkNotNullParameter((Object)mediaSource, (String)"mediaSource");
        if (index <= this.shortTVItemList.size()) {
            this.shortTVItemList.add(index, mediaSource);
        }
        this.loadNext();
    }

    private static final void loadNext$lambda$2(VideoPreloadHelper this$0, int $position) {
        int start;
        int size = this$0.shortTVItemList.size();
        int skipCount = 0;
        skipCount = 1;
        boolean isCurrentComplete = false;
        Log.e((String)TAG, (String)("loadNext\uff0c position:" + $position + "   size:" + size));
        int n = RangesKt.coerceAtMost((int)(start + 5), (int)size);
        for (int index = start = $position + 1; index < n; ++index) {
            MediaSource shortTVItem;
            if (this$0.shortTVItemList.get(index) == null) continue;
            VideoDownloadBean it = this$0.createDownloadRequest(index, shortTVItem);
            boolean bl = false;
            it.setMaxLength(307200L);
            if (it.getDownloadLength() < it.getMaxLength()) {
                Log.e((String)TAG, (String)("\u975e\u5f53\u524d\u9009\u4e2d  \u4e0b\u8f7d\u5927\u5c0f downloadLength:" + it.getDownloadLength() + "  index:" + index));
                this$0.currentDownloadingUuid = it.getId();
                VideoPreloadManager.INSTANCE.preloadVideo(it);
                return;
            }
            if (it.getDownloadLength() == it.getContentLength()) {
                ++skipCount;
            }
            Log.e((String)TAG, (String)("\u975e\u5f53\u524d\u9009\u4e2d  \u4e0b\u8f7d\u5927\u5c0f downloadLength:" + it.getDownloadLength() + " \u5927\u4e8e\u6700\u5c0f\u4e0b\u8f7d\uff0c\u8df3\u8fc7 index:" + index));
        }
        Log.e((String)TAG, (String)"\u4e0d\u7528\u5168\u91cf\u4e0b\u8f7d");
    }

    private static final void checkToStart$lambda$4(MediaSource $shortTVItem, VideoPreloadHelper this$0) {
        VideoDownloadBean videoDownloadBean;
        VideoDownloadBean $this$checkToStart_u24lambda_u244_u24lambda_u243 = videoDownloadBean = VideoPreloadManager.INSTANCE.preloadVideoAsync($shortTVItem);
        boolean bl = false;
        ((Map)this$0.activeTasks).put($shortTVItem.getKey(), $this$checkToStart_u24lambda_u244_u24lambda_u243);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getActiveTasks$p(VideoPreloadHelper $this) {
        return $this.activeTasks;
    }

    public static final /* synthetic */ String access$getCurrentDownloadingUuid$p(VideoPreloadHelper $this) {
        return $this.currentDownloadingUuid;
    }

    public static final /* synthetic */ void access$setCurrentDownloadingUuid$p(VideoPreloadHelper $this, String string2) {
        $this.currentDownloadingUuid = string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/transsion/player/shorttv/preload/VideoPreloadHelper$Companion;", "", "<init>", "()V", "PRELOAD_COUNT", "", "PRELOAD_FIRST_SIZE", "", "PAUSE_REASON", "PRELOAD_ALL", "", "TAG", "", "Player_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

