package com.transsion.player.utils

import android.app.Activity
import android.view.OrientationEventListener
import android.view.Surface

class PlayerOrientationEventListener(val activity: Activity, val callback: (rotation: Int) -> Unit) : OrientationEventListener(activity) {
    private var currentType = Surface.ROTATION_0
    override fun onOrientationChanged(orientation: Int) {
        if (orientation in 71..109) {
            //90
            if (currentType == Surface.ROTATION_270) {
                return
            }
            val angle = getScreenRotation(activity)
            if (angle == Surface.ROTATION_270) {
                onRotationChange(Surface.ROTATION_270)
            }
        } else if (orientation in 251..289) {
            //270
            if (currentType == Surface.ROTATION_90) {
                return
            }
            val angle = getScreenRotation(activity)
            if (angle == Surface.ROTATION_90) {
                onRotationChange(Surface.ROTATION_90)
            }
        }
    }


    private fun getScreenRotation(activity: Activity): Int {
        return activity.windowManager.defaultDisplay.rotation
    }

    private fun onRotationChange(rotation: Int) {
        if (currentType == rotation) return
        currentType = rotation
        callback.invoke(rotation)
    }
}
