/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.exo;

import androidx.annotation.Nullable;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.transsion.player.exo.Sonic;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

@UnstableApi
public final class SonicAudioProcessor
implements AudioProcessor {
    public static final float MAXIMUM_SPEED = 8.0f;
    public static final float MINIMUM_SPEED = 0.1f;
    public static final float MAXIMUM_PITCH = 8.0f;
    public static final float MINIMUM_PITCH = 0.1f;
    public static final int SAMPLE_RATE_NO_CHANGE = -1;
    private static final float CLOSE_THRESHOLD = 0.01f;
    private static final int MIN_BYTES_FOR_SPEEDUP_CALCULATION = 1024;
    private int pendingOutputSampleRate = -1;
    private float speed = 1.0f;
    private float pitch = 1.0f;
    private float volume = 1.0f;
    private AudioProcessor.AudioFormat pendingInputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
    private AudioProcessor.AudioFormat pendingOutputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
    private AudioProcessor.AudioFormat inputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
    private AudioProcessor.AudioFormat outputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
    private boolean pendingSonicRecreation;
    @Nullable
    private Sonic sonic;
    private ByteBuffer buffer = EMPTY_BUFFER;
    private ShortBuffer shortBuffer = this.buffer.asShortBuffer();
    private ByteBuffer outputBuffer = EMPTY_BUFFER;
    private long inputBytes;
    private long outputBytes;
    private boolean inputEnded;

    public float setSpeed(float speed) {
        if (this.speed != (speed = Util.constrainValue((float)speed, (float)0.1f, (float)8.0f))) {
            this.speed = speed;
            this.pendingSonicRecreation = true;
        }
        return speed;
    }

    public float setPitch(float pitch) {
        if (this.pitch != (pitch = Util.constrainValue((float)pitch, (float)0.1f, (float)8.0f))) {
            this.pitch = pitch;
            this.pendingSonicRecreation = true;
        }
        return pitch;
    }

    public float setVolume(float volume) {
        if (this.volume != volume) {
            this.volume = volume;
            this.pendingSonicRecreation = true;
            if (this.sonic != null) {
                this.sonic.setVolume(volume);
            }
        }
        return volume;
    }

    public void setOutputSampleRateHz(int sampleRateHz) {
        this.pendingOutputSampleRate = sampleRateHz;
    }

    public long scaleDurationForSpeedup(long duration) {
        if (this.outputBytes >= 1024L) {
            return this.outputAudioFormat.sampleRate == this.inputAudioFormat.sampleRate ? Util.scaleLargeTimestamp((long)duration, (long)this.inputBytes, (long)this.outputBytes) : Util.scaleLargeTimestamp((long)duration, (long)(this.inputBytes * (long)this.outputAudioFormat.sampleRate), (long)(this.outputBytes * (long)this.inputAudioFormat.sampleRate));
        }
        return (long)((double)this.speed * (double)duration);
    }

    public AudioProcessor.AudioFormat configure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        if (inputAudioFormat.encoding != 2) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        int outputSampleRateHz = this.pendingOutputSampleRate == -1 ? inputAudioFormat.sampleRate : this.pendingOutputSampleRate;
        this.pendingInputAudioFormat = inputAudioFormat;
        this.pendingOutputAudioFormat = new AudioProcessor.AudioFormat(outputSampleRateHz, inputAudioFormat.channelCount, 2);
        this.pendingSonicRecreation = true;
        return this.pendingOutputAudioFormat;
    }

    public boolean isActive() {
        boolean isActive = this.pendingOutputAudioFormat.sampleRate != -1 && (Math.abs(this.speed - 1.0f) >= 0.01f || Math.abs(this.pitch - 1.0f) >= 0.01f || Math.abs(this.volume) >= 0.01f || this.pendingOutputAudioFormat.sampleRate != this.pendingInputAudioFormat.sampleRate);
        return isActive;
    }

    public void queueInput(ByteBuffer inputBuffer) {
        int outputSize;
        Sonic sonic = (Sonic)Assertions.checkNotNull((Object)this.sonic);
        boolean hasRemaining = inputBuffer.hasRemaining();
        if (hasRemaining) {
            ShortBuffer shortBuffer = inputBuffer.asShortBuffer();
            int inputSize = inputBuffer.remaining();
            this.inputBytes += (long)inputSize;
            sonic.queueInput(shortBuffer);
            inputBuffer.position(inputBuffer.position() + inputSize);
        }
        if ((outputSize = sonic.getOutputSize()) > 0) {
            if (this.buffer.capacity() < outputSize) {
                this.buffer = ByteBuffer.allocateDirect(outputSize).order(ByteOrder.nativeOrder());
                this.shortBuffer = this.buffer.asShortBuffer();
            } else {
                this.buffer.clear();
                this.shortBuffer.clear();
            }
            sonic.getOutput(this.shortBuffer);
            this.outputBytes += (long)outputSize;
            this.buffer.limit(outputSize);
            this.outputBuffer = this.buffer;
        }
    }

    public void queueEndOfStream() {
        if (this.sonic != null) {
            this.sonic.queueEndOfStream();
        }
        this.inputEnded = true;
    }

    public ByteBuffer getOutput() {
        ByteBuffer outputBuffer = this.outputBuffer;
        this.outputBuffer = EMPTY_BUFFER;
        return outputBuffer;
    }

    public boolean isEnded() {
        boolean isEnded = this.inputEnded && (this.sonic == null || this.sonic.getOutputSize() == 0);
        return isEnded;
    }

    public void flush() {
        if (this.isActive()) {
            this.inputAudioFormat = this.pendingInputAudioFormat;
            this.outputAudioFormat = this.pendingOutputAudioFormat;
            if (this.pendingSonicRecreation) {
                this.sonic = new Sonic(this.inputAudioFormat.sampleRate, this.inputAudioFormat.channelCount, this.speed, this.pitch, this.volume, this.outputAudioFormat.sampleRate);
            } else if (this.sonic != null) {
                this.sonic.flush();
            }
        }
        this.outputBuffer = EMPTY_BUFFER;
        this.inputBytes = 0L;
        this.outputBytes = 0L;
        this.inputEnded = false;
    }

    public void reset() {
        this.speed = 1.0f;
        this.pitch = 1.0f;
        this.volume = 1.0f;
        this.pendingInputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.pendingOutputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.inputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.outputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.buffer = EMPTY_BUFFER;
        this.shortBuffer = this.buffer.asShortBuffer();
        this.outputBuffer = EMPTY_BUFFER;
        this.pendingOutputSampleRate = -1;
        this.pendingSonicRecreation = false;
        this.sonic = null;
        this.inputBytes = 0L;
        this.outputBytes = 0L;
        this.inputEnded = false;
    }
}

