/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.shorttv.preload;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.offline.Download;
import androidx.media3.exoplayer.offline.DownloadManager;
import androidx.media3.exoplayer.offline.DownloadRequest;
import androidx.media3.exoplayer.offline.DownloadService;
import androidx.media3.exoplayer.scheduler.Requirements;
import com.blankj.utilcode.util.Utils;
import com.transsion.player.MediaSource;
import com.transsion.player.exo.DemoDownloadService;
import com.transsion.player.exo.DemoUtil;
import com.transsion.player.shorttv.preload.VideoDownloadBean;
import com.transsion.player.shorttv.preload.VideoPreloadManager;
import com.transsion.player.utils.MD5;
import com.transsion.player.utils.ORPlayerLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u0013\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010\u0004J\b\u0010!\u001a\u00020\u0019H\u0002J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020\u0019H\u0002J\u0006\u0010+\u001a\u00020\u0019J\b\u0010,\u001a\u00020\u0019H\u0002J\u000e\u0010-\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0004J\u0010\u0010.\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/transsion/player/shorttv/preload/VideoPreloadManager;", "", "()V", "TAG", "", "activeTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/transsion/player/shorttv/preload/VideoDownloadBean;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "context$delegate", "Lkotlin/Lazy;", "handler", "Landroid/os/Handler;", "isStartLoop", "", "listener", "com/transsion/player/shorttv/preload/VideoPreloadManager$listener$1", "Lcom/transsion/player/shorttv/preload/VideoPreloadManager$listener$1;", "updateInterval", "", "updateIntervalRunnable", "Lkotlin/Function0;", "", "videoPreloadThread", "Landroid/os/HandlerThread;", "createDownloadRequest", "shortTVItem", "Lcom/transsion/player/MediaSource;", "isCache", "url", "loop", "preloadVideo", "shortTVDownloadBean", "preloadVideoAsync", "removePreload", "key", "runOnPreloadThread", "runnable", "Ljava/lang/Runnable;", "startLoop", "stopALlPreload", "stopLoop", "stopPreload", "urlToCacheKey", "Player_release"})
@UnstableApi
public final class VideoPreloadManager {
    @NotNull
    public static final VideoPreloadManager INSTANCE = new VideoPreloadManager();
    @NotNull
    private static final String TAG = "VideoPreloadUtil";
    @NotNull
    private static final ConcurrentHashMap<String, VideoDownloadBean> activeTasks = new ConcurrentHashMap();
    @NotNull
    private static final Lazy context$delegate = LazyKt.lazy((Function0)context.2.INSTANCE);
    @NotNull
    private static final HandlerThread videoPreloadThread = new HandlerThread("VideoPreloadUtil");
    @NotNull
    private static final Handler handler;
    private static final long updateInterval;
    @NotNull
    private static final Function0<Unit> updateIntervalRunnable;
    @NotNull
    private static final listener.1 listener;
    private static boolean isStartLoop;

    private VideoPreloadManager() {
    }

    private final Context getContext() {
        Lazy lazy = context$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-context>(...)");
        return (Context)object;
    }

    private final void startLoop() {
        if (isStartLoop) {
            return;
        }
        isStartLoop = true;
        this.loop();
    }

    private final void stopLoop() {
        isStartLoop = false;
        handler.removeCallbacks(() -> VideoPreloadManager.stopLoop$lambda$0(updateIntervalRunnable));
    }

    private final void loop() {
        handler.removeCallbacks(() -> VideoPreloadManager.loop$lambda$1(updateIntervalRunnable));
        handler.postDelayed(() -> VideoPreloadManager.loop$lambda$2(updateIntervalRunnable), updateInterval);
    }

    public final void preloadVideo(@NotNull MediaSource shortTVItem) {
        Intrinsics.checkNotNullParameter((Object)shortTVItem, (String)"shortTVItem");
        this.runOnPreloadThread(() -> VideoPreloadManager.preloadVideo$lambda$3(shortTVItem));
    }

    @NotNull
    public final VideoDownloadBean preloadVideoAsync(@NotNull MediaSource shortTVItem) {
        Intrinsics.checkNotNullParameter((Object)shortTVItem, (String)"shortTVItem");
        VideoDownloadBean shortTVDownloadBean = this.createDownloadRequest(shortTVItem);
        this.preloadVideo(shortTVDownloadBean);
        return shortTVDownloadBean;
    }

    @NotNull
    public final VideoDownloadBean preloadVideo(@NotNull VideoDownloadBean shortTVDownloadBean) {
        Intrinsics.checkNotNullParameter((Object)shortTVDownloadBean, (String)"shortTVDownloadBean");
        this.runOnPreloadThread(() -> VideoPreloadManager.preloadVideo$lambda$4(shortTVDownloadBean));
        return shortTVDownloadBean;
    }

    public final void stopPreload(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.runOnPreloadThread(() -> VideoPreloadManager.stopPreload$lambda$5(key2));
    }

    public final void removePreload(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        activeTasks.remove(key2);
        this.runOnPreloadThread(() -> VideoPreloadManager.removePreload$lambda$6(key2));
    }

    public final void stopALlPreload() {
        ORPlayerLog.e$default(ORPlayerLog.INSTANCE, TAG, "stopALlPreload  ", false, 4, null);
        DownloadService.sendSetStopReason((Context)this.getContext(), DemoDownloadService.class, null, (int)10086, (boolean)false);
    }

    @NotNull
    public final VideoDownloadBean createDownloadRequest(@NotNull MediaSource shortTVItem) {
        Intrinsics.checkNotNullParameter((Object)shortTVItem, (String)"shortTVItem");
        VideoDownloadBean data = activeTasks.get(shortTVItem.getKey());
        if (data != null) {
            ORPlayerLog.d$default(ORPlayerLog.INSTANCE, TAG, "createDownloadRequest [from map]  shortTVItem:" + shortTVItem, false, 4, null);
            return data;
        }
        Download currentDownload = DemoUtil.getDownloadManager((Context)Utils.getApp()).getDownloadIndex().getDownload(shortTVItem.getKey());
        Download download = currentDownload;
        if (Intrinsics.areEqual((Object)(download != null && (download = download.request) != null ? download.id : null), (Object)shortTVItem.getKey())) {
            ORPlayerLog.d$default(ORPlayerLog.INSTANCE, TAG, "createDownloadRequest [from currentDownloads]   shortTVItem:" + shortTVItem, false, 4, null);
            String string2 = shortTVItem.getKey();
            String string3 = shortTVItem.getUrl();
            DownloadRequest downloadRequest = currentDownload.request;
            Intrinsics.checkNotNullExpressionValue((Object)downloadRequest, (String)"currentDownload.request");
            return new VideoDownloadBean(string2, string3, downloadRequest, currentDownload.contentLength, currentDownload.getBytesDownloaded(), 307200L, true);
        }
        String cacheKey = shortTVItem.getKey();
        String url = shortTVItem.getUrl();
        DownloadRequest downloadRequest = new DownloadRequest.Builder(cacheKey, Uri.parse((String)url)).setCustomCacheKey(cacheKey).build();
        Intrinsics.checkNotNullExpressionValue((Object)downloadRequest, (String)"Builder(cacheKey, Uri.pa\u2026\n                .build()");
        VideoDownloadBean shortTVDownloadBean = new VideoDownloadBean(cacheKey, url, downloadRequest, -1L, 0L, 307200L, false);
        ((Map)activeTasks).put(cacheKey, shortTVDownloadBean);
        ORPlayerLog.d$default(ORPlayerLog.INSTANCE, TAG, "createDownloadRequest [from new]  shortTVItem:" + shortTVItem, false, 4, null);
        return shortTVDownloadBean;
    }

    public final boolean isCache(@Nullable String url) {
        CharSequence charSequence = url;
        return charSequence == null || charSequence.length() == 0 ? false : (StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null) ? DemoUtil.getDownloadCache((Context)Utils.getApp()).isCached(this.urlToCacheKey(url), 0L, 200L) : true);
    }

    @NotNull
    public final String urlToCacheKey(@Nullable String url) {
        String string2;
        int index;
        String string3 = url;
        int n = index = string3 != null ? StringsKt.indexOf$default((CharSequence)string3, (String)"?", (int)0, (boolean)false, (int)6, null) : -1;
        if (url != null && index >= 0) {
            String[] stringArray = new String[]{"?"};
            string2 = MD5.Companion.getStringMD5((String)StringsKt.split$default((CharSequence)url, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0));
        } else {
            String string4 = url;
            if (string4 == null) {
                string4 = "";
            }
            string2 = MD5.Companion.getStringMD5(string4);
        }
        String key2 = string2;
        return key2;
    }

    public final void runOnPreloadThread(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        handler.post(runnable);
    }

    private static final void stopLoop$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void loop$lambda$1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void loop$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void preloadVideo$lambda$3(MediaSource $shortTVItem) {
        Intrinsics.checkNotNullParameter((Object)$shortTVItem, (String)"$shortTVItem");
        VideoDownloadBean shortTVDownloadBean = INSTANCE.createDownloadRequest($shortTVItem);
        INSTANCE.preloadVideo(shortTVDownloadBean);
    }

    private static final void preloadVideo$lambda$4(VideoDownloadBean $shortTVDownloadBean) {
        Intrinsics.checkNotNullParameter((Object)$shortTVDownloadBean, (String)"$shortTVDownloadBean");
        Log.e((String)TAG, (String)("preloadVideo id:" + $shortTVDownloadBean.getId() + " downloadLength:" + $shortTVDownloadBean.getDownloadLength() + "  maxLength:" + $shortTVDownloadBean.getMaxLength() + " contentLength:" + $shortTVDownloadBean.getContentLength()));
        if ($shortTVDownloadBean.getMaxLength() == -1L || $shortTVDownloadBean.getDownloadLength() < $shortTVDownloadBean.getMaxLength()) {
            if ($shortTVDownloadBean.isAdd()) {
                DownloadService.sendSetStopReason((Context)INSTANCE.getContext(), DemoDownloadService.class, (String)$shortTVDownloadBean.getId(), (int)0, (boolean)false);
                Log.e((String)TAG, (String)("checkToStart restart  shortTVItem:" + $shortTVDownloadBean));
            } else {
                DownloadService.sendAddDownload((Context)INSTANCE.getContext(), DemoDownloadService.class, (DownloadRequest)$shortTVDownloadBean.getRequest(), (boolean)false);
                Log.e((String)TAG, (String)("checkToStart add    shortTVItem:" + $shortTVDownloadBean));
            }
        }
    }

    private static final void stopPreload$lambda$5(String $key) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        ORPlayerLog.e$default(ORPlayerLog.INSTANCE, TAG, "stopPreload   key:" + $key, false, 4, null);
        DownloadService.sendSetStopReason((Context)INSTANCE.getContext(), DemoDownloadService.class, (String)$key, (int)10086, (boolean)false);
    }

    private static final void removePreload$lambda$6(String $key) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        ORPlayerLog.e$default(ORPlayerLog.INSTANCE, TAG, "removePreload   key:" + $key, false, 4, null);
        DownloadService.sendRemoveDownload((Context)INSTANCE.getContext(), DemoDownloadService.class, (String)$key, (boolean)false);
    }

    public static final /* synthetic */ Context access$getContext(VideoPreloadManager $this) {
        return $this.getContext();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getActiveTasks$p() {
        return activeTasks;
    }

    public static final /* synthetic */ boolean access$isStartLoop$p() {
        return isStartLoop;
    }

    public static final /* synthetic */ void access$loop(VideoPreloadManager $this) {
        $this.loop();
    }

    public static final /* synthetic */ void access$startLoop(VideoPreloadManager $this) {
        $this.startLoop();
    }

    public static final /* synthetic */ void access$stopLoop(VideoPreloadManager $this) {
        $this.stopLoop();
    }

    static {
        updateInterval = 100L;
        updateIntervalRunnable = updateIntervalRunnable.1.INSTANCE;
        listener = new DownloadManager.Listener(){

            public void onInitialized(@NotNull DownloadManager downloadManager) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
            }

            public void onDownloadChanged(@NotNull DownloadManager downloadManager, @NotNull Download download, @Nullable Exception finalException) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)download, (String)"download");
                Log.e((String)"VideoPreloadUtil", (String)("onDownloadChanged:  download.requestId:" + download.request.id + "     bytesDownloaded:" + download.getBytesDownloaded() + "  contentLength:" + download.contentLength + "  percentDownloaded:" + download.getPercentDownloaded()));
                VideoDownloadBean videoDownloadBean = (VideoDownloadBean)VideoPreloadManager.access$getActiveTasks$p().get(download.request.id);
                if (videoDownloadBean != null) {
                    VideoDownloadBean videoDownloadBean2;
                    VideoDownloadBean $this$onDownloadChanged_u24lambda_u240 = videoDownloadBean2 = videoDownloadBean;
                    boolean bl = false;
                    $this$onDownloadChanged_u24lambda_u240.setDownloadLength(download.getBytesDownloaded());
                    $this$onDownloadChanged_u24lambda_u240.setContentLength(download.contentLength);
                    if (download.state == 2) {
                        long l = $this$onDownloadChanged_u24lambda_u240.getDownloadLength();
                        long l2 = $this$onDownloadChanged_u24lambda_u240.getMaxLength();
                        boolean bl2 = 1L <= l2 ? l2 < l : false;
                        if (bl2) {
                            String string2 = $this$onDownloadChanged_u24lambda_u240.getRequest().id;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.id");
                            VideoPreloadManager.INSTANCE.stopPreload(string2);
                        }
                    } else if (download.state == 1 || download.state == 3) {
                        String string3 = $this$onDownloadChanged_u24lambda_u240.getRequest().id;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"request.id");
                        VideoPreloadManager.INSTANCE.removePreload(string3);
                    }
                }
                VideoPreloadManager.access$startLoop(VideoPreloadManager.INSTANCE);
            }

            public void onIdle(@NotNull DownloadManager downloadManager) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Log.e((String)"VideoPreloadUtil", (String)"onIdle:");
                VideoPreloadManager.access$stopLoop(VideoPreloadManager.INSTANCE);
            }

            public void onDownloadsPausedChanged(@NotNull DownloadManager downloadManager, boolean downloadsPaused) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Log.e((String)"VideoPreloadUtil", (String)"onDownloadsPausedChanged:");
            }

            public void onDownloadRemoved(@NotNull DownloadManager downloadManager, @NotNull Download download) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)download, (String)"download");
                Log.e((String)"VideoPreloadUtil", (String)"onDownloadRemoved:");
            }

            public void onRequirementsStateChanged(@NotNull DownloadManager downloadManager, @NotNull Requirements requirements, int notMetRequirements) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
                Log.e((String)"VideoPreloadUtil", (String)"onRequirementsStateChanged:");
            }

            public void onWaitingForRequirementsChanged(@NotNull DownloadManager downloadManager, boolean waitingForRequirements) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Log.e((String)"VideoPreloadUtil", (String)"onWaitingForRequirementsChanged:");
            }
        };
        videoPreloadThread.start();
        Looper looper = videoPreloadThread.getLooper();
        handler = new Handler(looper){

            public void dispatchMessage(@NotNull Message msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                try {
                    super.dispatchMessage(msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        DemoUtil.getDownloadManager(INSTANCE.getContext()).addListener((DownloadManager.Listener)listener);
    }
}

