package com.transsion.player.utils

import android.util.Log

/**
 *
 * Created by kun.xu on 2025/3/26 10:24
 * Description:
 *
 */
object ORPlayerLog {

    private var callback: ORPlayerLogCallback? = null
    fun setLogCallback(callback: ORPlayerLogCallback) {
        this.callback = callback
    }

    fun d(tag: String, msg: String, writeToFile: Boolean = false) {
        callback?.d(tag, msg, writeToFile) ?: run {
            Log.d(tag, msg)
        }
    }

    fun i(tag: String, msg: String, writeToFile: Boolean = false) {
        callback?.i(tag, msg, writeToFile) ?: run {
            Log.d(tag, msg)
        }
    }

    fun v(tag: String, msg: String, writeToFile: Boolean = false) {
        callback?.v(tag, msg, writeToFile) ?: run {
            Log.d(tag, msg)
        }
    }

    fun w(tag: String, msg: String, writeToFile: Boolean = false) {
        callback?.w(tag, msg, writeToFile) ?: run {
            Log.d(tag, msg)
        }
    }

    fun e(tag: String, msg: String, writeToFile: Boolean = false) {
        callback?.e(tag, msg, writeToFile) ?: run {
            Log.d(tag, msg)
        }
    }


}

interface ORPlayerLogCallback {
    fun d(tag: String, msg: String, writeToFile: Boolean)
    fun i(tag: String, msg: String, writeToFile: Boolean)
    fun v(tag: String, msg: String, writeToFile: Boolean)
    fun w(tag: String, msg: String, writeToFile: Boolean)
    fun e(tag: String, msg: String, writeToFile: Boolean)
}