/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.control;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.transsion.player.control.ControlWrapper;
import com.transsion.player.control.IControlComponent;
import com.transsion.player.control.IVideoController;
import com.transsion.player.enum.PipStatus;
import com.transsion.player.ui.IORVideoView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0007\u0010\u000bB#\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0013\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"J7\u0010*\u001a\u00020%2*\u0010+\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00130,\"\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0013\u00a2\u0006\u0002\u0010-J\"\u0010*\u001a\u00020%2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00132\u0006\u0010.\u001a\u00020\u0014J\u001a\u0010/\u001a\u00020%2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0013J\u0006\u00100\u001a\u00020%J\u0006\u00101\u001a\u00020%J<\u00102\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0013\u0012\u0004\u0012\u00020\u0014`\u0015H\u0016J\u000e\u00103\u001a\u00020%2\u0006\u00104\u001a\u000205R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000RN\u0010\u0011\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0013\u0012\u0004\u0012\u00020\u0014`\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R&\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00130\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0004\u0018\u00018\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010#\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00066"}, d2={"Lcom/transsion/player/control/BaseVideoController;", "Data", "PlayStatus", "Landroid/widget/FrameLayout;", "Lcom/transsion/player/control/IVideoController;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "controlWrapper", "Lcom/transsion/player/control/ControlWrapper;", "controlComponents", "Ljava/util/LinkedHashMap;", "Lcom/transsion/player/control/IControlComponent;", "", "Lkotlin/collections/LinkedHashMap;", "getControlComponents", "()Ljava/util/LinkedHashMap;", "setControlComponents", "(Ljava/util/LinkedHashMap;)V", "pipStatusVisibilityComponents", "", "getPipStatusVisibilityComponents", "()Ljava/util/List;", "videoContentData", "getVideoContentData", "()Ljava/lang/Object;", "setVideoContentData", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "setPayerView", "", "playerView", "Lcom/transsion/player/ui/IORVideoView;", "setVideoData", "videoData", "addControlComponent", "component", "", "([Lcom/transsion/player/control/IControlComponent;)V", "isDissociate", "removeControlComponent", "removeAllControlComponent", "removeAllDissociateComponents", "getControlComponentMap", "onPipStatusChange", "pipStatus", "Lcom/transsion/player/enum/PipStatus;", "player_release"})
@SourceDebugExtension(value={"SMAP\nBaseVideoController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseVideoController.kt\ncom/transsion/player/control/BaseVideoController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,134:1\n1869#2:135\n1870#2:138\n257#3,2:136\n255#3:139\n257#3,2:140\n*S KotlinDebug\n*F\n+ 1 BaseVideoController.kt\ncom/transsion/player/control/BaseVideoController\n*L\n118#1:135\n118#1:138\n119#1:136,2\n125#1:139\n126#1:140,2\n*E\n"})
public abstract class BaseVideoController<Data, PlayStatus>
extends FrameLayout
implements IVideoController<Data, PlayStatus> {
    @Nullable
    private ControlWrapper<Data, PlayStatus> controlWrapper;
    @NotNull
    private LinkedHashMap<IControlComponent<Data, PlayStatus>, Boolean> controlComponents;
    @NotNull
    private final List<IControlComponent<Data, PlayStatus>> pipStatusVisibilityComponents;
    @Nullable
    private Data videoContentData;

    @NotNull
    protected final LinkedHashMap<IControlComponent<Data, PlayStatus>, Boolean> getControlComponents() {
        return this.controlComponents;
    }

    protected final void setControlComponents(@NotNull LinkedHashMap<IControlComponent<Data, PlayStatus>, Boolean> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, (String)"<set-?>");
        this.controlComponents = linkedHashMap;
    }

    @NotNull
    protected final List<IControlComponent<Data, PlayStatus>> getPipStatusVisibilityComponents() {
        return this.pipStatusVisibilityComponents;
    }

    @Nullable
    protected final Data getVideoContentData() {
        return this.videoContentData;
    }

    protected final void setVideoContentData(@Nullable Data Data) {
        this.videoContentData = Data;
    }

    public BaseVideoController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public BaseVideoController(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public BaseVideoController(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.controlComponents = new LinkedHashMap();
        this.pipStatusVisibilityComponents = new ArrayList();
    }

    public final void setPayerView(@NotNull IORVideoView playerView) {
        Intrinsics.checkNotNullParameter((Object)playerView, (String)"playerView");
        this.controlWrapper = new ControlWrapper(playerView, this);
        for (Map.Entry<IControlComponent<Data, PlayStatus>, Boolean> entry : this.controlComponents.entrySet()) {
            IControlComponent<Data, PlayStatus> component;
            Intrinsics.checkNotNullExpressionValue(entry, (String)"next(...)");
            Intrinsics.checkNotNullExpressionValue(entry.getKey(), (String)"component1(...)");
            ControlWrapper<Data, PlayStatus> controlWrapper = this.controlWrapper;
            Intrinsics.checkNotNull(controlWrapper);
            component.attach(controlWrapper);
        }
    }

    public final void setVideoData(Data videoData) {
        this.videoContentData = videoData;
        for (Map.Entry<IControlComponent<Data, PlayStatus>, Boolean> entry : this.controlComponents.entrySet()) {
            IControlComponent<Data, PlayStatus> component;
            Intrinsics.checkNotNullExpressionValue(entry, (String)"next(...)");
            Intrinsics.checkNotNullExpressionValue(entry.getKey(), (String)"component1(...)");
            component.setVideoData(videoData);
        }
    }

    public final void addControlComponent(IControlComponent<Data, PlayStatus> ... component) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        for (IControlComponent<Data, PlayStatus> item : component) {
            this.addControlComponent(item, false);
        }
    }

    public final void addControlComponent(@NotNull IControlComponent<Data, PlayStatus> component, boolean isDissociate) {
        View view;
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Boolean bl = isDissociate;
        ((Map)this.controlComponents).put(component, bl);
        if (this.controlWrapper != null) {
            ControlWrapper<Data, PlayStatus> controlWrapper = this.controlWrapper;
            Intrinsics.checkNotNull(controlWrapper);
            component.attach(controlWrapper);
        }
        if ((view = component.getView()) != null && !isDissociate) {
            this.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
    }

    public final void removeControlComponent(@NotNull IControlComponent<Data, PlayStatus> component) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        this.removeView(component.getView());
        this.controlComponents.remove(component);
    }

    public final void removeAllControlComponent() {
        for (Map.Entry<IControlComponent<Data, PlayStatus>, Boolean> entry : this.controlComponents.entrySet()) {
            IControlComponent<Data, PlayStatus> key;
            Intrinsics.checkNotNullExpressionValue(entry, (String)"next(...)");
            Intrinsics.checkNotNullExpressionValue(entry.getKey(), (String)"component1(...)");
            this.removeView(key.getView());
        }
        this.controlComponents.clear();
    }

    public final void removeAllDissociateComponents() {
        Iterator<Map.Entry<IControlComponent<Data, PlayStatus>, Boolean>> it = this.controlComponents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IControlComponent<Data, PlayStatus>, Boolean> next = it.next();
            if (!next.getValue().booleanValue()) continue;
            it.remove();
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<IControlComponent<Data, PlayStatus>, Boolean> getControlComponentMap() {
        return this.controlComponents;
    }

    /*
     * WARNING - void declaration
     */
    public final void onPipStatusChange(@NotNull PipStatus pipStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)pipStatus), (String)"pipStatus");
        if (pipStatus == PipStatus.DEFAULT) {
            Iterable $this$forEach$iv = this.pipStatusVisibilityComponents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$isVisible$iv;
                IControlComponent it = (IControlComponent)element$iv;
                boolean bl = false;
                if (it.getView() == null) continue;
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
            }
        } else {
            this.pipStatusVisibilityComponents.clear();
            for (Map.Entry<IControlComponent<Data, PlayStatus>, Boolean> entry : this.controlComponents.entrySet()) {
                boolean bl;
                View $this$isVisible$iv;
                IControlComponent<Data, PlayStatus> component;
                Intrinsics.checkNotNullExpressionValue(entry, (String)"next(...)");
                Intrinsics.checkNotNullExpressionValue(entry.getKey(), (String)"component1(...)");
                View view = component.getView();
                if (view != null) {
                    boolean $i$f$isVisible = false;
                    bl = $this$isVisible$iv.getVisibility() == 0;
                } else {
                    bl = false;
                }
                if (!bl) continue;
                $this$isVisible$iv = view;
                boolean value$iv = false;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
                this.pipStatusVisibilityComponents.add(component);
            }
        }
    }
}

