/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.shorttv.preload;

import android.net.Uri;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.exoplayer.offline.DefaultDownloaderFactory;
import androidx.media3.exoplayer.offline.DownloadRequest;
import androidx.media3.exoplayer.offline.Downloader;
import com.transsion.player.shorttv.preload.VideoProgressiveDownloader;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/transsion/player/shorttv/preload/VideoDownloadFactory;", "Landroidx/media3/exoplayer/offline/DefaultDownloaderFactory;", "cacheDataSourceFactory", "Landroidx/media3/datasource/cache/CacheDataSource$Factory;", "executor", "Ljava/util/concurrent/Executor;", "<init>", "(Landroidx/media3/datasource/cache/CacheDataSource$Factory;Ljava/util/concurrent/Executor;)V", "createDownloader", "Landroidx/media3/exoplayer/offline/Downloader;", "request", "Landroidx/media3/exoplayer/offline/DownloadRequest;", "player_release"})
@UnstableApi
public final class VideoDownloadFactory
extends DefaultDownloaderFactory {
    @NotNull
    private final CacheDataSource.Factory cacheDataSourceFactory;
    @NotNull
    private final Executor executor;

    public VideoDownloadFactory(@NotNull CacheDataSource.Factory cacheDataSourceFactory, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)cacheDataSourceFactory, (String)"cacheDataSourceFactory");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        super(cacheDataSourceFactory, executor);
        this.cacheDataSourceFactory = cacheDataSourceFactory;
        this.executor = executor;
    }

    @NotNull
    public Downloader createDownloader(@NotNull DownloadRequest request) {
        Downloader downloader;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        int contentType = Util.inferContentTypeForUriAndMimeType((Uri)request.uri, (String)request.mimeType);
        switch (contentType) {
            case 0: 
            case 1: 
            case 2: {
                Downloader downloader2 = super.createDownloader(request);
                downloader = downloader2;
                Intrinsics.checkNotNullExpressionValue((Object)downloader2, (String)"createDownloader(...)");
                break;
            }
            case 4: {
                downloader = new VideoProgressiveDownloader(new MediaItem.Builder().setUri(request.uri).setCustomCacheKey(request.customCacheKey).build(), this.cacheDataSourceFactory, this.executor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + contentType);
            }
        }
        return downloader;
    }
}

