/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.ui.render;

import android.view.View;
import com.transsion.player.ui.render.RenderScaleMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/transsion/player/ui/render/MeasureHelper;", "", "<init>", "()V", "mVideoWidth", "", "mVideoHeight", "mCurrentScreenScale", "Lcom/transsion/player/ui/render/RenderScaleMode;", "mVideoRotationDegree", "setVideoRotation", "", "videoRotationDegree", "setVideoSize", "width", "height", "setScreenScale", "screenScale", "doMeasure", "", "widthMeasureSpecP", "heightMeasureSpecP", "player_release"})
public final class MeasureHelper {
    private int mVideoWidth;
    private int mVideoHeight;
    @NotNull
    private RenderScaleMode mCurrentScreenScale = RenderScaleMode.SCREEN_SCALE_DEFAULT;
    private int mVideoRotationDegree;

    public final void setVideoRotation(int videoRotationDegree) {
        this.mVideoRotationDegree = videoRotationDegree;
    }

    public final void setVideoSize(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    public final void setScreenScale(@NotNull RenderScaleMode screenScale) {
        Intrinsics.checkNotNullParameter((Object)((Object)screenScale), (String)"screenScale");
        if (screenScale == this.mCurrentScreenScale) {
            return;
        }
        this.mCurrentScreenScale = screenScale;
    }

    @NotNull
    public final int[] doMeasure(int widthMeasureSpecP, int heightMeasureSpecP) {
        int widthMeasureSpec = widthMeasureSpecP;
        int heightMeasureSpec = heightMeasureSpecP;
        int middle = 0;
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            middle = widthMeasureSpec;
            widthMeasureSpec = heightMeasureSpec;
            heightMeasureSpec = middle;
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mVideoHeight == 0 || this.mVideoWidth == 0) {
            int[] nArray = new int[]{width, height};
            return nArray;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.mCurrentScreenScale.ordinal()]) {
            case 1: {
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                    break;
                }
                if (this.mVideoWidth * height <= width * this.mVideoHeight) break;
                height = width * this.mVideoHeight / this.mVideoWidth;
                break;
            }
            case 2: {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                break;
            }
            case 3: {
                if (height > width / 16 * 9) {
                    height = width / 16 * 9;
                    break;
                }
                width = height / 9 * 16;
                break;
            }
            case 4: {
                if (height > width / 4 * 3) {
                    height = width / 4 * 3;
                    break;
                }
                width = height / 3 * 4;
                break;
            }
            case 5: {
                width = widthMeasureSpec;
                height = heightMeasureSpec;
                break;
            }
            case 6: {
                if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                    break;
                }
                height = width * this.mVideoHeight / this.mVideoWidth;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int[] nArray = new int[]{width, height};
        return nArray;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RenderScaleMode.values().length];
            try {
                nArray[RenderScaleMode.SCREEN_SCALE_DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderScaleMode.SCREEN_SCALE_ORIGINAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderScaleMode.SCREEN_SCALE_16_9.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderScaleMode.SCREEN_SCALE_4_3.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderScaleMode.SCREEN_SCALE_MATCH_PARENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderScaleMode.SCREEN_SCALE_CENTER_CROP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

