/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.ui.render;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.transsion.player.config.RenderType;
import com.transsion.player.ui.render.IRenderView;
import com.transsion.player.ui.render.MeasureHelper;
import com.transsion.player.ui.render.RenderScaleMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tB%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\fB-\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\u000fJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\u0018\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0014R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/transsion/player/ui/render/TextureRenderView;", "Landroid/view/TextureView;", "Lcom/transsion/player/ui/render/IRenderView;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "renderType", "Lcom/transsion/player/config/RenderType;", "(Landroid/content/Context;Lcom/transsion/player/config/RenderType;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;Lcom/transsion/player/config/RenderType;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;ILcom/transsion/player/config/RenderType;)V", "mMeasureHelper", "Lcom/transsion/player/ui/render/MeasureHelper;", "mSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mSurface", "Landroid/view/Surface;", "getView", "Landroid/view/View;", "setVideoSize", "", "videoWidth", "videoHeight", "setVideoRotation", "degree", "setScaleType", "scaleType", "Lcom/transsion/player/ui/render/RenderScaleMode;", "doScreenShot", "Landroid/graphics/Bitmap;", "release", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "player_release"})
public final class TextureRenderView
extends TextureView
implements IRenderView {
    @NotNull
    private final MeasureHelper mMeasureHelper;
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    @Nullable
    private Surface mSurface;

    public TextureRenderView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public TextureRenderView(@NotNull Context context, @Nullable RenderType renderType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, renderType);
    }

    public TextureRenderView(@NotNull Context context, @Nullable AttributeSet attrs, @Nullable RenderType renderType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, renderType);
    }

    public TextureRenderView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable RenderType renderType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mMeasureHelper = new MeasureHelper();
    }

    @Override
    @NotNull
    public View getView() {
        return (View)this;
    }

    @Override
    public void setVideoSize(int videoWidth, int videoHeight) {
        if (videoWidth > 0 && videoHeight > 0) {
            this.mMeasureHelper.setVideoSize(videoWidth, videoHeight);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int degree) {
        this.mMeasureHelper.setVideoRotation(degree);
        this.setRotation(degree);
    }

    @Override
    public void setScaleType(@NotNull RenderScaleMode scaleType) {
        Intrinsics.checkNotNullParameter((Object)((Object)scaleType), (String)"scaleType");
        this.mMeasureHelper.setScreenScale(scaleType);
        this.requestLayout();
    }

    @Override
    @Nullable
    public Bitmap doScreenShot() {
        return this.getBitmap();
    }

    @Override
    public void release() {
        block1: {
            Surface surface = this.mSurface;
            if (surface != null) {
                surface.release();
            }
            SurfaceTexture surfaceTexture = this.mSurfaceTexture;
            if (surfaceTexture == null) break block1;
            surfaceTexture.release();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int[] measuredSize = this.mMeasureHelper.doMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(measuredSize[0], measuredSize[1]);
    }
}

