package com.transsion.player.config

import android.content.Context
import com.cicada.player.utils.Logger

/**
 * @author xugaopan
 * @date 2022/8/9
 * 播放配置管理
 */
object ORPlayerConfig {


    private var vodConfig: VodConfig? = null

    fun setConfig(vodConfig: VodConfig?) {
        this.vodConfig = vodConfig
    }

    fun openLogger(context: Context) {
        Logger.getInstance(context).enableConsoleLog(true)
        Logger.getInstance(context).logLevel = Logger.LogLevel.AF_LOG_LEVEL_TRACE
    }

    fun isUsingSurfaceView(): Boolean {
        return vodConfig?.type == RenderType.SURFACE_VIEW
    }


    /**
     * 默认开启
     */
    fun openCache(): Boolean {
        return vodConfig?.openCache ?: true
    }

    fun getVodConfig(): VodConfig {
        if (vodConfig == null) {
            vodConfig = VodConfig(type = RenderType.SURFACE_VIEW, traceId = "")
        }
        return vodConfig!!
    }

}