package com.transsion.player.config

/**
 * @author xugaopan
 * @date 2022/8/9
 * 播放配置
 */
data class VodConfig(
    val type: RenderType = RenderType.SURFACE_VIEW,
    val openCache: Boolean = true,
    val positionTimerIntervalMs: Int = 50,//回调进度的间隔，毫秒，时间越短进度条越顺滑
    val maxBufferDuration: Int = 50000,//最大缓冲区时长。单位ms。播放器每次最多加载这么长时间的缓冲数据。
    val highBufferDuration: Int = 3000,//高缓冲时长。单位ms。当网络不好导致加载数据时，如果加载的缓冲时长到达这个值，结束加载状态。
    val startBufferDuration: Int = 500,// 起播缓冲区时长。单位ms。这个时间设置越短，起播越快。也可能会导致播放之后很快就会进入加载状态。
    val retryCount: Int = 2,//失败后重试次数
    val preloadCount: Int = 3,//预加载个数
    val preloadDuration: Long = 4000,//预加载时长
    val cacheMaxSizeMB: Int = 50,//本地缓存的最大值
    val networkTimeout: Int = 30000,//加载超时时长，30秒
    var enableHardwareDecoder: Boolean = true,//是否开启就硬解
    var clearFrameWhenStop: Boolean = false,//停止后是否显示最后一帧
    var disableVideo: Boolean = false,//禁用视频-需要在prepare之前设置
    var disableAudio: Boolean = false,//禁用音频-需要在prepare之前设置
    var openAudioFocus: Boolean = true,//是否设置音频焦点监听，默认开启，包断广告不需要开启，本身就静音设置会影响视频播放
    val traceId: String = "",
)