package com.transsion.player.enum

enum class ScaleMode(val value: Int) {
    /**
     * 设置宽高比适应（将按照视频宽高比等比缩小到view内部，不会有画面变形）
     */
    SCALE_ASPECT_FIT(0),

    /**
     * 设置宽高比填充（将按照视频宽高比等比放大，充满view，不会有画面变形）
     */
    SCALE_ASPECT_FILL(1),

    /**
     * 设置拉伸填充（如果视频宽高比例与view比例不一致，会导致画面变形）
     */
    SCALE_TO_FILL(2)
}