package com.transsion.player.ijk

import android.content.Context
import android.graphics.SurfaceTexture
import android.os.Handler
import android.os.HandlerThread
import android.os.Looper
import android.util.Log
import android.view.Surface
import android.view.SurfaceHolder
import android.view.SurfaceView
import android.view.TextureView
import androidx.core.net.toUri
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleObserver
import androidx.lifecycle.OnLifecycleEvent
import androidx.lifecycle.ProcessLifecycleOwner
import com.aliyun.player.source.UrlSource
import com.blankj.utilcode.util.Utils
//import com.jeffmony.videocache.VideoProxyCacheManager
//import com.jeffmony.videocache.common.VideoParams
//import com.jeffmony.videocache.listener.IVideoCacheListener
//import com.jeffmony.videocache.model.VideoCacheInfo
//import com.jeffmony.videocache.utils.ProxyCacheUtils
//import com.jeffmony.videocache.utils.StorageUtils
import com.transsion.player.MediaSource
import com.transsion.player.enum.ScaleMode
import com.transsion.player.exo.DefaultConfig
import com.transsion.player.exo.VideoConfig
import com.transsion.player.orplayer.AudioFocusHelper
import com.transsion.player.orplayer.AudioFocusPlay
import com.transsion.player.orplayer.IPlayerListener
import com.transsion.player.orplayer.ORPlayer
import com.transsion.player.orplayer.PlayError
import com.transsion.player.orplayer.global.TnErrorInterceptorListener
import com.transsion.player.orplayer.global.TnPlayerManager
import com.transsion.player.orplayer.global.TnPlayerPool
import com.transsion.player.ui.render.RenderScaleMode
import com.transsion.player.ui.render.SurfaceRenderView
import com.transsion.player.ui.render.TextureRenderView
import com.transsion.player.utils.ORPlayerLog
import tv.danmaku.ijk.media.player.IMediaPlayer
import tv.danmaku.ijk.media.player.IjkMediaPlayer
import tv.danmaku.ijk.media.player.misc.IMediaFormat
import tv.danmaku.ijk.media.player.misc.ITrackInfo
import tv.danmaku.ijk.media.player.misc.IjkTrackInfo
import java.io.FileNotFoundException
import java.util.concurrent.CopyOnWriteArrayList


/**
 *
 * Created by chenlong.wang on 2025/7/21 16:52
 * Description:ijkPlayer 接入到MovieBox的实现类
 *
 */
class IjkPlayer(
    val context: Context,
    val config: VideoConfig = DefaultConfig(),
    openAudioFocus: Boolean = true
) : ORPlayer {
    private val TAG = "ijkPlayer"
    private var ijkMediaPlayer: IjkMediaPlayer? = null
    private var audioFocusHelper: AudioFocusHelper? = null
    private var onPlayerListener: IPlayerListener? = null
    private var listeners: CopyOnWriteArrayList<IPlayerListener> = CopyOnWriteArrayList()
    private var textureView: TextureRenderView? = null
    private var surfaceView: SurfaceRenderView? = null
    private var handler: Handler? = null
    private var mute: Boolean = false
    private var isRenderFirstFrame = false
    private var curUrl = ""
    private var playUrl = ""
    private var speed: Float = 1f
    private var isSeekBegin: Boolean = false
    private var isLoop: Boolean = false
    private var volume: Float? = null
    private var mediaSource: MediaSource? = null
    private var isPrepare = false
    private var isCompletion = false//防止Completion多次回调
    private var currentPosition = 0L
    private var isLoading = false
    private var isVideoRending: Boolean? = false
    private val progressHandler = Handler(Looper.myLooper()!!)
    private var isAppForeground = true // 标记应用是否在前台
    protected var isVideoCompletion = false//防止Completion多次回调
    private var isAutoPlay: Boolean = false
    private var updateTextureNumber: Int = 0
    private var allResolutions: List<String> = emptyList()
    private var allHeightMap: Map<String, Int> = emptyMap()
    private var accurateSeekPosition: Long = 0L
    private var isVideoStartStreaming: Boolean? = true
    private var isScreenUIChange: Int? = 0
    private var isCodecHardCodec: Boolean? = false
    private var isCacheManagerEnabled: Boolean? = false

    // 标记第二帧是否已渲染
    private var secondFrameRendered = false

    /** 当前播放器使用的解码器*/
    private var curDecoderType = ORIjkDecoderType.HARDWARE

    //是否是内部解码错误切换视频
    private var isInnerChangeDecoder = false
    private var isReset = false
    private var isPlaying = false
    private var isComplete = false
    private var currentVolume = 1.0f
    private var errorInterceptorListener: TnErrorInterceptorListener? = null
    private val mainHandler = Handler(Looper.getMainLooper())

    protected var curVideoWidth = 0//视频宽
    protected var curVideoHeight = 0//视频高

    private var videoBitrate = 0
    private var audioBitrate = 0

    private var isChangeResolution: Boolean? = false

    // 定义状态枚举（对应ijkplayer核心状态）
    enum class PlayerState {
        IDLE,  // 初始状态
        PREPARING,  // 准备中
        PREPARED,  // 准备完成
        PLAYING,  // 播放中
        PAUSED,  // 暂停
        COMPLETED,  // 播放完成
        STOPPED,  // 停止
        ERROR,  // 错误
        RELEASED // 已释放
    }

    private var currentState = PlayerState.IDLE // 当前状态

    init {
        Log.d(TAG, "初始化Ijk播放器")
        if (openAudioFocus) {
            initAudioFocus()
        } else {

        }
        if (isCacheManagerEnabled == true) {
            Log.d(TAG, "setDataSource 开启CacheManager")
            initCacheManager()
        } else {
            Log.d(TAG, "setDataSource 未开启CacheManager")
        }

//        val isSupportH264 = HardwareDecoderChecker.isHardwareDecoderSupported("video/avc")
//        Log.d("ijkPlayer==", "硬解是否支持H264:$isSupportH264")
//        val isSupportHevc = HardwareDecoderChecker.isHardwareDecoderSupported("video/hevc")
//        Log.d("ijkPlayer==", "硬解是否支持Hevc:$isSupportHevc")
//        val isSupportMp4 = HardwareDecoderChecker.isHardwareDecoderSupported("video/mp4v-es")
//        Log.d("ijkPlayer==", "硬解是否支持Mp4:$isSupportMp4")
//        val isSupportVp9 = HardwareDecoderChecker.isHardwareDecoderSupported("video/vp9")
//        Log.d("ijkPlayer==", "硬解是否支持Vp9:$isSupportVp9")
        createPlayer(ORIjkDecoderType.HARDWARE)
        IjkMediaPlayer.native_setLogLevel(IjkMediaPlayer.IJK_LOG_ERROR)
    }

//    private val mListener: IVideoCacheListener = object : IVideoCacheListener {
//        override fun onCacheStart(cacheInfo: VideoCacheInfo?) {
//            Log.d(TAG, "onCacheStart: $cacheInfo")
//        }
//
//        override fun onCacheProgress(cacheInfo: VideoCacheInfo) {
//            val params: MutableMap<String?, Any?> = HashMap<String?, Any?>()
//            params.put(VideoParams.PERCENT, cacheInfo.percent)
//            params.put(VideoParams.CACHE_SIZE, cacheInfo.cachedSize)
////            Log.d(TAG, "onCacheProgress PERCENT: " +cacheInfo.percent)
////            Log.d(TAG, "onCacheProgress CACHE_SIZE: " +cacheInfo.cachedSize)
////            mPlayer.notifyOnProxyCacheInfo(ProxyMessage.MSG_VIDEO_PROXY_PROGRESS, params)
//        }
//
//        override fun onCacheError(cacheInfo: VideoCacheInfo?, msg: String?, errorCode: Int) {
//            Log.e(TAG, "onCacheError: $msg")
//        }
//
//        override fun onCacheForbidden(cacheInfo: VideoCacheInfo?) {
//            Log.e(
//                TAG,
//                "onCacheForbidden: $cacheInfo"
//            )
//        }
//
//        override fun onCacheFinished(cacheInfo: VideoCacheInfo) {
//            val params: MutableMap<String?, Any?> = HashMap<String?, Any?>()
//            params.put(VideoParams.PERCENT, 100f)
//            params.put(VideoParams.TOTAL_SIZE, cacheInfo.totalSize)
////            mPlayer.notifyOnProxyCacheInfo(ProxyMessage.MSG_VIDEO_PROXY_COMPLETED, params)
//        }
//    }


    private fun initCacheManager() {
//        Log.d(TAG, "初始化Ijk的缓存管理器")
//        //视频缓存设置
//        val saveFile = StorageUtils.getVideoFileDir(context)
//        if (!saveFile.exists()) {
//            saveFile.mkdir()
//        }
//        val builder = VideoProxyCacheManager.Builder(context)
//            .setFilePath(saveFile.getAbsolutePath())
//            .setConnTimeOut(60 * 1000)
//            .setReadTimeOut(60 * 1000)
//            .setExpireTime((2 * 24 * 60 * 60 * 1000).toLong())
//            .setMaxCacheSize((2 * 1024 * 1024 * 1024).toLong()) //2G的存储上限
//        VideoProxyCacheManager.getInstance().initProxyConfig(builder.build())
        //视频缓存设置
    }

    private fun createPlayer(decoderType: ORIjkDecoderType) {
        ijkMediaPlayer = IjkMediaPlayer().apply {
            currentState = PlayerState.IDLE;

            // 设置通用选项
            if (decoderType == ORIjkDecoderType.HARDWARE) {
                Log.d(TAG, "开启了HardDecoder")
                setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "mediacodec", 1)
//                setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "mediacodec-auto-rotate", 1)

                // 启用精确 seek（默认关闭）
                setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "enable-accurate-seek", 1)
                // 关键：启用硬解码器与消息队列同步
//                setOption(IjkMediaPlayer.OPT_CATEGORY_CODEC, "mediacodec-sync", 1)
//                setOption(
//                    IjkMediaPlayer.OPT_CATEGORY_PLAYER,
//                    "mediacodec-handle-resolution-change",
//                    1
//                )
                //1.5s后精准seek失败的话切为普通seek
                setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "accurate-seek-timeout", 1500)
                // 3. 优化TextureView渲染性能
                setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "hwaccel", 1) // 启用硬件加速渲染
            } else {
                Log.d(TAG, "开启了SoftDecoder")
                // 启用精确 seek（默认关闭）
                setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "mediacodec", 0)
                setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "mediacodec-auto-rotate", 0)
                setOption(
                    IjkMediaPlayer.OPT_CATEGORY_PLAYER,
                    "mediacodec-handle-resolution-change",
                    0
                )
                setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "enable-accurate-seek", 1)
                // 2. 设置精确 Seek 超时时间为 3000 毫秒（3 秒）
//                setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "accurate-seek-timeout", 1500)


            }
            setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "dns_cache_timeout", 10000);
            setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "framedrop", -1)
            setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "start-on-prepared", 0L)
            setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "http-detect-range-support", 0L)

            setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "reconnect", 1)
            setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "sync-av-start", 1);

            setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "framedrop", 1)

//            setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "probesize", 2048 * 1024) // 2MB
//            setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "analyzeduration", 1000000) // 1s
//            setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "seek-at-start", 90000);


            // 网络优化（针对HTTP/HTTPS）
//            setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "flush_packets", 1);
//            setOption(IjkMediaPlayer.OPT_CATEGORY_FORMAT, "http-detect-range-support", 1)// 支持断点续传

            // 解码器优化
//            setOption(IjkMediaPlayer.OPT_CATEGORY_CODEC, "skip_loop_filter", 4) // 跳过部分滤波
//            setOption(IjkMediaPlayer.OPT_CATEGORY_CODEC, "codec_fast", 1) // 快速解码模式
//            setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "start-on-prepared", 1)
//            setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "max-buffer-size", 2 * 1024 * 1024)
        }
//        ijkMediaPlayer?.setIsCodecReused(0)

        initListener()

        ProcessLifecycleOwner.get().lifecycle.addObserver(object : LifecycleObserver {
            // 应用进入前台（所有Activity可见）
            @OnLifecycleEvent(Lifecycle.Event.ON_START)
            fun onAppForeground() {
                if (!isAppForeground) {
//                    Log.d("ijkPlayer1==", "从后台回到前台")
                    progressHandler.post(timerTask)
                }
                isAppForeground = true
//                Log.d("ijkPlayer1==", "前台")
            }

            // 应用进入后台（所有Activity不可见）
            @OnLifecycleEvent(Lifecycle.Event.ON_STOP)
            fun onAppBackground() {
                isAppForeground = false
//                Log.d("ijkPlayer1==", "后台")
            }
        })
    }

    private fun progressLoop() {
        progressHandler.removeCallbacks(timerTask)
        progressHandler.postDelayed(timerTask, 200)
    }


    //监测网络情况
    private fun monitorNetLoop() {
        Log.d("ijkPlayer", "网络情况循环监测")
        mainHandler.removeCallbacks(monitorNetTask)
        mainHandler.postDelayed(monitorNetTask, 1000)

    }


    private val timerTask = Runnable {
        val isPlaying = ijkMediaPlayer?.isPlaying
//        Log.d("ijkPlayer1==", "isPlaying:$isPlaying")
//        Log.d("ijkPlayer1==", "isVideoRending:$isVideoRending")
        if (ijkMediaPlayer?.isPlaying != false && isVideoRending == true) {
            val progress = ijkMediaPlayer?.currentPosition ?: 0L
//            Log.d("ijkPlayer1==", "进度$progress")
            currentPos = progress
            listeners.forEach {
//                Log.d("ijkPlayer==", "current progress: =$progress")
                it.onProgress(progress, mediaSource)
            }
            progressLoop()
        }
    }

    private val monitorNetTask = Runnable {
        // 若2000ms内未触发第二次帧更新，强制检测网络状况
        Log.d(TAG, "网络监测，帧是否上屏::$secondFrameRendered ")
        if (secondFrameRendered == false) {
            Log.d(TAG, "第二帧render太慢,可能无网络")
            onPlayerListener?.setOnSeekCompleteListener()
            listeners.forEach { listener ->
                listener.setOnSeekCompleteListener()
            }
            monitorNetLoop()
        } else {
            Log.d(TAG, "第二帧render很快，无需监测网络")
        }
    }

    private fun initListener() {
//        IjkMediaPlayer.setOnCodecSelectListener { codecName, rankLevel ->
//            Log.d(TAG, "选中的解码器是:$codecName")
//            Log.d(TAG, "选中的解码器等级是:$rankLevel")
//            if (rankLevel == 200) {
//                isCodecHardCodec = false
//            } else {
//                isCodecHardCodec = true
//            }
//            null
//        }
        ijkMediaPlayer?.setOnCompletionListener {
            Log.d("ijkPlayer", "onCompletion: 播放完成")
            if (isCompletion.not()) {
                updateState(PlayerState.COMPLETED);
                // 处理播放完成逻辑
                onPlayerListener?.onCompletion(mediaSource)
                listeners.forEach { listener ->
                    listener.onCompletion(mediaSource)
                }
                isComplete = true
            }
        }

        ijkMediaPlayer?.setOnInfoListener { mp, what, extra ->
            when (what) {
                IjkMediaPlayer.MEDIA_INFO_METADATA_UPDATE -> {

                }


                IjkMediaPlayer.MEDIA_ERROR_TIMED_OUT -> {
                    Log.d(TAG, "MEDIA_ERROR_TIMED_OUT")
                }

                IjkMediaPlayer.MEDIA_ERROR_IO -> {
                    Log.d(TAG, "MEDIA_ERROR_IO")
                }

                IjkMediaPlayer.MEDIA_ERROR_SERVER_DIED -> {
                    Log.d(TAG, "MEDIA_ERROR_SERVER_DIED")
                }


                IjkMediaPlayer.MEDIA_INFO_BAD_INTERLEAVING -> {
                    Log.d(TAG, "MEDIA_INFO_BAD_INTERLEAVING")
                }

                IjkMediaPlayer.MEDIA_INFO_VIDEO_TRACK_LAGGING -> {
                    Log.d(TAG, "MEDIA_INFO_VIDEO_TRACK_LAGGING")
                }


                IjkMediaPlayer.MEDIA_INFO_STARTED_AS_NEXT -> {
                    Log.d(TAG, "MEDIA_INFO_STARTED_AS_NEXT")
                }


                IjkMediaPlayer.MEDIA_INFO_UNKNOWN -> {
                    Log.d(TAG, "MEDIA_INFO_UNKNOWN")
                }

                IjkMediaPlayer.MEDIA_INFO_VIDEO_DECODED_START -> {
                    Log.d(TAG, "decoder is working")
                }


                IjkMediaPlayer.MEDIA_INFO_BUFFERING_START -> {
                    Log.d(TAG, "onInfo: 开始缓冲")
                    Log.d(TAG, "onLoadingBegin--->")
                    updateTextureNumber = 0
                    isLoading = true
                    val isPlaying = ijkMediaPlayer?.isPlaying
                    listeners.forEach { listener ->
                        listener?.onLoadingBegin(mediaSource)
                        Log.d(TAG, "onInfo: 开始缓冲 监听回调")
                    }
                }


                IjkMediaPlayer.MEDIA_INFO_BUFFERING_END -> {
                    Log.d(TAG, "onInfo: 缓冲结束")
                    Log.d(TAG, "onLoadingEnd----->")
                    isLoading = false
                    val isPlaying = ijkMediaPlayer?.isPlaying
                    if (!isSeekBegin) {
                        Log.d(TAG, "onInfo: 缓冲结束，结束loading")
                        onPlayerListener?.onLoadingEnd(mediaSource)
                        listeners.forEach { listener ->
                            listener.onLoadingEnd(mediaSource)
                            Log.d(TAG, "onInfo: 缓冲结束，结束loading")
                        }
                    } else {
//                        Log.d(TAG, "onInfo: 缓冲结束,开始播放")
//                        ijkMediaPlayer?.start()
                    }
                }

                IjkMediaPlayer.MEDIA_INFO_VIDEO_RENDERING_START -> {
                    Log.d(TAG, "onInfo: 视频开始渲染")
                    onPlayerListener?.onRenderFirstFrame()
                    updateTextureNumber = 0
                    listeners.forEach { listener ->
                        listener.onRenderFirstFrame()
                    }
                    isRenderFirstFrame = true
                    updateState(PlayerState.PLAYING);
                    progressHandler.post(timerTask)
                    isVideoRending = true
                    isPlaying = true
                    onPlayerListener?.onIsPlayingChanged(isPlaying)
                    listeners.forEach { listener ->
                        listener.onIsPlayingChanged(isPlaying)
                    }
                    audioFocusHelper?.isPlaying = isPlaying
                    onPlayerListener?.onVideoStart(mediaSource)
                    listeners.forEach { listener ->
                        listener.onVideoStart(mediaSource)
                    }

                }

                IjkMediaPlayer.MEDIA_INFO_AUDIO_RENDERING_START -> {
                    Log.d(TAG, "onInfo: 音频开始渲染")
                }

                IjkMediaPlayer.MEDIA_INFO_MEDIA_ACCURATE_SEEK_COMPLETE -> {
                    Log.d(TAG, "onInfo: 精准seek结束")
                    val isMusicPlay = TnPlayerManager.isMusicPlay
                    if (isMusicPlay == true) {
                        Log.d(TAG, "onInfo Music: 精准seek结束")
                        onPlayerListener?.onLoadingEnd(mediaSource)
                        listeners.forEach { listener ->
                            listener.onLoadingEnd(mediaSource)
                            Log.d(TAG, "onInfo Music: 精准seek结束 OnLoading")
                        }
                    }
                }
            }
            false
        }

        ijkMediaPlayer?.setOnVideoSizeChangedListener { _, width, height, _, _ ->
            Log.d(TAG, "onVideoSizeChanged: 视频宽度=$width, 高度=$height")
            curVideoWidth = width
            curVideoHeight = height
            textureView?.setVideoSize(curVideoWidth, curVideoHeight)
            textureView?.requestLayout()
            // 调整视频视图尺寸
            onPlayerListener?.onVideoSizeChanged(width, height)
            listeners.forEach { listener ->
                listener.onVideoSizeChanged(width, height)
            }

            if (isChangeResolution == true) {
                Log.d(TAG, "切换分辨率，切换完成，loading结束")
//                ijkMediaPlayer?.seekTo(currentPos!!)
                onPlayerListener?.onLoadingEnd(mediaSource)
                listeners.forEach { listener ->
                    listener.onLoadingEnd()
                }
            }

        }

        ijkMediaPlayer?.setOnBufferingUpdateListener { _, percent ->
//            Log.d("ijkPlayer", "onBufferingUpdate: 缓冲进度=$percent%")
            // 更新缓冲进度条

        }

        ijkMediaPlayer?.setOnSeekCompleteListener {
            Log.d(TAG, "seek结束")
            onPlayerListener?.setOnSeekCompleteListener()
            listeners.forEach {
                it.setOnSeekCompleteListener()
            }
            netWorkMonitor()


            progressHandler.post(timerTask)

            var isPlaying = ijkMediaPlayer?.isPlaying
            if (isPlaying == true) {
                updateTextureNumber = 0
                Log.d(TAG, "恢复播放")
                if (!isSeekBegin) {
                    Log.d(TAG, "恢复播放，不是seek")
                    onPlayerListener?.onVideoStart(mediaSource)
                    listeners.forEach { listener ->
                        listener.onVideoStart(mediaSource)
                    }
                }
            }


        }

        ijkMediaPlayer?.setOnPreparedListener { mp ->
            if (isTrackSelected == true) {
                Log.d(TAG, "changeResolution setOnInfoListener onPrepare")
//                ijkMediaPlayer?.setNewVideoTrack(selectedTrackIndex)
                Log.d(TAG, "changeResolution setOnInfoListener onPrepare seekTo $currentPos")
                seekTo(currentPos!!)
                ijkMediaPlayer?.start()
                isTrackSelected = false
                return@setOnPreparedListener
            }
            isPrepare = true
            Log.d(TAG, "setOnInfoListener onPrepare")
            listeners.forEach { listener ->
                listener?.onLoadingBegin(mediaSource)
                Log.d(TAG, "prepare: 开始转圈")
            }
            val ijkMp = mp as IjkMediaPlayer
            var mediaInfo = ijkMp.mediaInfo
            allHeightMap = parseAllResolutions(ijkMp)
//            Log.d(TAG, "setOnInfoListener allHeightMap $allHeightMap")
            var currentHeight: Int = 0
            currentHeight = ijkMediaPlayer?.videoHeight!!
            val mapCurrentHeight = mutableMapOf<String, Int>()
//            mapCurrentHeight[mapCurrentHeight] =
            for (key in allHeightMap.keys) {
                if (key.equals(currentHeight.toString())) {
                    mapCurrentHeight[currentHeight.toString()] = allHeightMap[key] as Int
//                    Log.d(TAG, "setOnInfoListener currentHeightMap $mapCurrentHeight")
                }
            }
//            Log.d("ijkPlayer", "视频轨道的信息当前的Height prepare为:$currentHeight")
            listeners.forEach { listener ->
                listener?.onTracksChangeIJK(allHeightMap, mapCurrentHeight)
            }
            if (errorInterceptorListener?.onPrepare(mediaSource) == true) {
                ORPlayerLog.d(TAG, "ijk onPrepare 被外部拦截掉", true)
                Log.d(TAG, "setOnInfoListener onPrepare 1")
            } else if (isInnerChangeDecoder && currentPosition > 0) {
                //没有播放进度则为首次，直接抛出去处理
                ORPlayerLog.d(
                    TAG,
                    "ijk onPrepare 内部的解码切换，已有播放进度，直接播放",
                    true
                )
                seekTo(currentPosition)
                play()
            } else {
                onPlayerListener?.onPrepare(mediaSource)
                listeners.forEach { listener ->
                    listener.onPrepare(mediaSource)
                }
            }
            updateState(PlayerState.PREPARED);
        }

        ijkMediaPlayer?.setOnErrorListener { _, what, extra ->
            Log.d(TAG, "onError code:${what},msg:${extra}")
            updateState(PlayerState.ERROR);
            val errorInfo = PlayError(what, extra.toString())
            if (handleDecodeError(errorInfo)) {
                Log.d(TAG, "尝试切软解")
                true
            }
            Log.d(TAG, "上报错误")
            onPlayerListener?.onPlayError(errorInfo, mediaSource)
            listeners.forEach { listener ->
                Log.d(TAG, "上报错误1")
                listener.onPlayError(errorInfo, mediaSource)
            }

            if (what == IMediaPlayer.MEDIA_ERROR_UNSUPPORTED) {
                prepare()
                play()
            }
            true
        }
    }

    override fun setPlayerListener(listener: IPlayerListener) {
        onPlayerListener = listener
    }

    override fun addPlayerListener(listener: IPlayerListener) {
        Log.d(TAG, "ijk 添加监听器")
        if (listeners.contains(listener).not()) {
            listeners.add(listener)
        }
    }

    override fun removePlayerListener(listener: IPlayerListener) {
        Log.d(TAG, "ijk 移除监听器")
        listeners.remove(listener)
    }

    // 更新状态并触发回调（可自定义状态变化监听）
    private fun updateState(newState: PlayerState) {
        if (currentState == newState) return  // 状态未变化则忽略

        val oldState = currentState
        currentState = newState
        Log.d(TAG, "状态变化: $oldState -> $newState")
        // 此处可添加自定义监听器，通知外部状态变化
        if (stateChangeListener != null) {
            stateChangeListener!!.onStateChanged(oldState, newState)
        }
    }

    // 获取当前状态
    fun getCurrentState(): PlayerState {
        return currentState
    }

    // 自定义状态变化监听器（供外部使用）
    interface OnPlayerStateChangeListener {
        fun onStateChanged(oldState: PlayerState?, newState: PlayerState?)
    }

    private var stateChangeListener: OnPlayerStateChangeListener? = null

    fun setOnPlayerStateChangeListener(listener: OnPlayerStateChangeListener?) {
        this.stateChangeListener = listener
    }

    private fun parsetHeightFromTrackInfo(trackInfo: String): Int {
        val resolutionPattern = Regex("(\\d+)x(\\d+)")
        val matchResult = resolutionPattern.find(trackInfo)

        return matchResult?.groupValues?.getOrNull(2)?.toIntOrNull() ?: 0
    }

    private fun parseAllResolutions(player: IjkMediaPlayer): Map<String, Int> {
        val resolutionHeights = mutableListOf<String>()
        val mIjktrackInfos = player.trackInfo
        val heightMap = mutableMapOf<String, Int>()

        var audioId: Int? = 0
        mIjktrackInfos.forEachIndexed { index, trackinfo ->
            if (trackinfo.trackType == ITrackInfo.MEDIA_TRACK_TYPE_VIDEO) {
                Log.d("ijkPlayer", "视频轨道的信息为:$trackinfo")
                Log.d("ijkPlayer", "视频轨道的信息为:$index")
                val heightFormat = trackinfo.format.getString(IMediaFormat.KEY_HEIGHT)
                val height = parsetHeightFromTrackInfo(trackinfo.infoInline)
//                Log.d("ijkPlayer", "视频轨道的信息Height为:$heightFormat")
                val currentHeight = ijkMediaPlayer?.videoHeight
//                Log.d("ijkPlayer", "视频轨道的信息当前的Height为:$currentHeight")
                if (heightFormat != null) {
                    heightMap[heightFormat] = index
                    resolutionHeights.add(heightFormat)
                }
            }

            if (trackinfo.trackType == ITrackInfo.MEDIA_TRACK_TYPE_AUDIO) {
//                Log.d("ijkPlayer", "音频轨道的信息为:$trackinfo")
//                Log.d("ijkPlayer", "音频轨道的信息为:$index")
                audioTrackIds[audioId!!] = index
                audioId++
            }


            if (trackinfo.trackType == ITrackInfo.MEDIA_TRACK_TYPE_TIMEDTEXT) {
//                Log.d("ijkPlayer", "Text轨道的信息为:$trackinfo")
//                Log.d("ijkPlayer", "Text轨道的信息为:$index")
            }

            if (trackinfo.trackType == ITrackInfo.MEDIA_TRACK_TYPE_SUBTITLE) {
//                Log.d("ijkPlayer", "SUBTITL轨道的信息为:$trackinfo")
//                Log.d("ijkPlayer", "SUBTITL轨道的信息为:$index")
            }
        }
        val currentAudioTrack = ijkMediaPlayer?.getSelectedTrack(ITrackInfo.MEDIA_TRACK_TYPE_AUDIO)
        Log.d("ijkPlayer", "被选中的音频轨道为:$currentAudioTrack")
        val currentVideoTrack = ijkMediaPlayer?.getSelectedTrack(ITrackInfo.MEDIA_TRACK_TYPE_VIDEO)
        Log.d("ijkPlayer", "被选中的视频轨道为:$currentVideoTrack")
        val currentTextTrack =
            ijkMediaPlayer?.getSelectedTrack(ITrackInfo.MEDIA_TRACK_TYPE_TIMEDTEXT)
        Log.d("ijkPlayer", "被选中的Text轨道为:$currentTextTrack")
        val currentSUBTITLETrack =
            ijkMediaPlayer?.getSelectedTrack(ITrackInfo.MEDIA_TRACK_TYPE_SUBTITLE)
        Log.d("ijkPlayer", "被选中的SUBTITLE轨道为:$currentSUBTITLETrack")
        currentAudioTrackId = 1
        return heightMap
    }

    private fun handleDecodeError(info: PlayError): Boolean {
        //视频，音频解码失败
        if (isInnerChangeDecoder) {
            //已经切过软解，还是出错不再处理
            ORPlayerLog.d(TAG, "ijk 已经切过软解，还是出错不再处理", writeToFile = true)
            return false
        }
        ORPlayerLog.e(TAG, "onError -- 解码失败，强制切到软解", true)
        //重置
        stop()
        reset()
        ijkMediaPlayer?.setOption(IjkMediaPlayer.OPT_CATEGORY_PLAYER, "mediacodec", 0)
        mediaSource?.let { mediaSource ->
            setDataSource(mediaSource)
            prepare()
        }
        isInnerChangeDecoder = true
        return true
    }


    private fun initAudioFocus() {
        val audioFocusPlayer = object : AudioFocusPlay {
            override fun play() {
                Log.d(TAG, "Audio start")
                ijkMediaPlayer?.start()
            }

            override fun pause() {
                Log.d(TAG, "Audio pause")
                ijkMediaPlayer?.pause()
            }

            override fun isMute(): Boolean {
//                return ijkMediaPlayer?.isMute ?: false
                return false
            }

            override fun setVolume(volume: Float) {
                ijkMediaPlayer?.setVolume(volume, volume)
            }
        }
        audioFocusHelper = AudioFocusHelper(audioFocusPlayer) { focusLoss ->
            onPlayerListener?.onFocusChange(focusLoss)
            listeners.forEach { listener ->
                listener.onFocusChange(focusLoss)
            }
        }
    }

    private fun runOnPlayerThread(block: () -> Unit) {
        val h = handler
        if (null == h || Thread.currentThread() == h.looper.thread) {
            block()
        } else {
            h.post {
                block()
            }
        }
    }

    private val mSurfaceCallback = object : SurfaceHolder.Callback {
        override fun surfaceCreated(holder: SurfaceHolder) {
            handler?.post {
                val surface = holder.surface
                if (surface.isValid) {
                    Log.d(TAG, "surfaceCreated")
                    Log.d("IJKMEDIA", "surfaceCreated")
                    ijkMediaPlayer?.setSurface(surface)
                }
            }
        }

        override fun surfaceChanged(
            holder: SurfaceHolder,
            format: Int,
            width: Int,
            height: Int
        ) {
//            runOnPlayerThread {
//                ijkMediaPlayer?.surfaceChanged()
//            }
            Log.d(TAG, "surfaceChanged")
            Log.d("IJKMEDIA", "surfaceChanged")
        }

        override fun surfaceDestroyed(holder: SurfaceHolder) {
            Log.d(TAG, "surfaceDestroyed")
            Log.d("IJKMEDIA", "surfaceDestroyed")
            runOnPlayerThread {
                ijkMediaPlayer?.setSurface(null)
            }
        }
    }

    private fun clearSurface() {
        this.surfaceView?.holder?.removeCallback(mSurfaceCallback)
        this.surfaceView = null

        this.textureView?.surfaceTextureListener = null
        this.textureView = null
    }

    override fun clearSurfaceOnly() {
        ijkMediaPlayer?.setSurface(null)
        surfaceView?.holder?.surface?.release()
        textureView?.surfaceTexture?.release()
        Log.d(TAG, "textureView清空11")
        clearSurface()
    }

    // 主动触发帧渲染，避免解码器“偷懒”
    private fun triggerFrameRender() {
        mainHandler.postDelayed({
            // 若200ms内未触发第二次更新，强制seek到当前位置（刷新帧输出）
            Log.d(TAG, "trigger::$secondFrameRendered ")
            if (secondFrameRendered == false) {
                Log.d(TAG, "第二帧render太慢")
                val currentPos = ijkMediaPlayer?.currentPosition
                Log.d(TAG, "第二帧:$currentPos")
                if (currentPos != null) {
                    ijkMediaPlayer?.seekTo(currentPos)
                }
            } else {
                Log.d(TAG, "第二帧render很快")
            }
        }, 100)
    }


    // 主动触发网络情况监测，避免网络断连，播放器不知道，无效尝试连接，应该及时通知APP层做UI提示
    private fun netWorkMonitor() {
        mainHandler.postDelayed(monitorNetTask, 2000)
    }

    override fun setSurfaceView(surfaceView: SurfaceView?) {
        Log.d(TAG, "setSurfaceView111")
        this.surfaceView = surfaceView as SurfaceRenderView
        val currentThread = Thread.currentThread()
        if (null != surfaceView) {
            handler = if (currentThread is HandlerThread) {
                Handler(currentThread.looper)
            } else {
                Handler(Looper.getMainLooper())
            }
        }
        surfaceView?.holder?.addCallback(mSurfaceCallback)
        surfaceView?.holder?.surface?.let {
            if (it.isValid) {
                ijkMediaPlayer?.setSurface(it)
            }
        }
    }

    private var mSaveTexture: SurfaceTexture? = null
    private var mSurface: Surface? = null


    private val mSurfaceTextureListener = object : TextureView.SurfaceTextureListener {
        override fun onSurfaceTextureAvailable(
            surfaceTexture: SurfaceTexture,
            width: Int,
            height: Int
        ) {
            updateTextureNumber = 0
            Log.d(TAG, "onSurfaceTextureAvailable")
            Log.d("IJKMEDIA", "onSurfaceTextureAvailable:$surfaceTexture")
            runOnPlayerThread {
                val surface = Surface(surfaceTexture)
                if (surface.isValid) {
                    ijkMediaPlayer?.setSurface(surface)
                }
            }
        }

        override fun onSurfaceTextureSizeChanged(
            surface: SurfaceTexture,
            width: Int,
            height: Int
        ) {
            Log.d(TAG, "onSurfaceTextureSizeChanged")
            Log.d("IJKMEDIA", "onSurfaceTextureSizeChanged")
            runOnPlayerThread {
//                ijkMediaPlayer?.surfaceChanged()
            }
        }

        override fun onSurfaceTextureDestroyed(surface: SurfaceTexture): Boolean {
            Log.d(TAG, "onSurfaceTextureDestroyed")
            Log.d("IJKMEDIA", "onSurfaceTextureDestroyed")
            runOnPlayerThread {
                //ijkMediaPlayer?.setSurface(null)
            }
            secondFrameRendered = false
            return false
        }

        override fun onSurfaceTextureUpdated(surface: SurfaceTexture) {
//            Log.d("ijkPlayer", "onSurfaceTextureUpdated")
            updateTextureNumber++
//        Log.d("ijkPlayer1==", "updateTextureNumber:$updateTextureNumber")
//            Log.d("ijkPlayer1==", "surface:$surface")
            if (updateTextureNumber == 1) {

//            Log.d("ijkPlayer1==", "secondFrameRendered")
//                Log.d("ijkPlayer", "secondFrameRendered = true")
                val isPlaying = ijkMediaPlayer?.isPlaying

                if (isPlaying == true) {
                    onPlayerListener?.onVideoStart(mediaSource)
                }
                listeners.forEach { listener ->
                    if (isPlaying == true) {
                        listener.onVideoStart(mediaSource)
                    }
                    listener.onLoadingEnd(mediaSource)
                }
            }

            if (updateTextureNumber == 2) {
//                ijkMediaPlayer?.setIsCodecReused(1)
                Log.d(TAG, "updateTextureNumber =2")
                Log.d("IJKMEDIA", "updateTextureNumber =2")
            }

            if (updateTextureNumber >= 2) {
                secondFrameRendered = true
            }
        }
    }

    override fun setTextureView(textureView: TextureView?) {
        clearSurface()
        this.textureView = textureView as TextureRenderView
        val currentThread = Thread.currentThread()
        if (null != surfaceView) {
            handler = if (currentThread is HandlerThread) {
                Log.d(TAG, "currentThread.looper")
                Handler(currentThread.looper)
            } else {
                Handler(Looper.getMainLooper())
            }
        }
        textureView?.surfaceTextureListener = mSurfaceTextureListener
        textureView?.surfaceTexture?.let {
            val surface = Surface(it)
            if (surface.isValid) {
                ijkMediaPlayer?.setSurface(surface)
            }
        }
    }


    override fun setDataSource(mediaSource: MediaSource) {
        try {
            Log.d(TAG, "实际的媒体资源 :$mediaSource")
            val source = UrlSource()
            val headers = mediaSource.headers
            Log.d(TAG, "实际的媒体资源 headers :$headers")
            val localPath = mediaSource.localPath
            Log.d(TAG, "实际的媒体资源 localPath :$localPath")
            val key = mediaSource.key
            Log.d(TAG, "实际的媒体资源 key :$key")


            curUrl = mediaSource.url
            Log.d(TAG, "setDataSource old:$curUrl")
            this.mediaSource = mediaSource
            source.uri = curUrl
            onPlayerListener?.onSetDataSource()
            listeners.forEach {
                it.onSetDataSource()
            }

            if (isCacheManagerEnabled == true) {
//                playUrl = ProxyCacheUtils.getProxyUrl(curUrl.toString(), headers, null);
//                VideoProxyCacheManager.getInstance().startRequestVideoInfo(curUrl, headers, null);
//                VideoProxyCacheManager.getInstance().setPlayingUrlMd5(ProxyCacheUtils.computeMD5(curUrl));
//                VideoProxyCacheManager.getInstance().addCacheListener(curUrl, mListener)
//                ijkMediaPlayer?.setDataSource(context, playUrl.toUri(), headers)
                Log.d(TAG, "setDataSource 开启代理")
            } else {
                ijkMediaPlayer?.setDataSource(context, curUrl.toUri())
                Log.d(TAG, "setDataSource 未开启代理")
            }

            Log.d(TAG, "setDataSource new:$playUrl")
            isPrepare = false
            isInnerChangeDecoder = false
        } catch (e: FileNotFoundException) {
            Log.e(TAG, "文件已不存在:" + e.toString())
        } catch (e: IllegalStateException) {
            Log.e(TAG, "IllegalStateException:" + e.toString())
        } catch (e: Exception) {
            Log.e(TAG, e.toString())
        }
    }

    override fun prepare() {
        try {
            Log.d(TAG, "prepare11")
            ijkMediaPlayer?.prepareAsync()
            isReset = false
            isCompletion = false
        } catch (e: IllegalStateException) {
            Log.e(TAG, "设置数据源失败,导致播放器状态异常:" + e.toString())
        } catch (e: Exception) {
            // 捕获其他未预料的异常（兜底处理）
            Log.e(TAG, "prepare时发生未知错误" + e.toString())
        }
    }

    override fun play() {
        Log.d(TAG, "播放器play 开始播放")
        onPlayerListener?.initPlayer()
        listeners.forEach {
            it.initPlayer()
        }
        listeners.forEach { listener ->
            listener?.onVideoStart(mediaSource)
        }
        if (handler == null) {
            val currentThread = Thread.currentThread()
            if (null != currentThread) {
                handler = if (currentThread is HandlerThread) {
                    Handler(currentThread.looper)
                } else {
                    Handler(Looper.getMainLooper())
                }
            }
        } else {
            handler?.post(timerTask)
        }
        ijkMediaPlayer?.start()
        audioFocusHelper?.isPlaying = true
        audioFocusHelper?.isUserPause = false

        audioFocusHelper?.requestFocus()
        isCompletion = false
        isComplete = false
    }

    override fun pause() {
        Log.d(TAG, "pause")
        try {
            audioFocusHelper?.isUserPause = true
            ijkMediaPlayer?.pause()
            audioFocusHelper?.abandonFocus()
            onPlayerListener?.onVideoPause(mediaSource)
            listeners.forEach { listener ->
                listener.onVideoPause(mediaSource)
            }
            updateState(PlayerState.PAUSED);
            // 清除不必要的回调，避免后台线程继续回调
//        ijkMediaPlayer?.setOnBufferingUpdateListener(null)
//        ijkMediaPlayer?.setOnCompletionListener(null)
//        ijkMediaPlayer?.setOnSeekCompleteListener(null)
//        ijkMediaPlayer?.setOnVideoSizeChangedListener(null)
//        ijkMediaPlayer?.setOnPreparedListener(null)
//        ijkMediaPlayer?.setOnInfoListener(null)
//        ijkMediaPlayer?.setOnErrorListener(null)
//        ijkMediaPlayer?.setOnTimedTextListener(null)
//        ijkMediaPlayer?.setSurface(null)
//        ijkMediaPlayer?.resetListeners()


//        handler?.removeCallbacks(timerTask)
        } catch (e: FileNotFoundException) {
            Log.e(TAG, "文件已不存在:" + e.toString())
        } catch (e: IllegalStateException) {
            Log.e(TAG, "IllegalStateException:" + e.toString())
        } catch (e: Exception) {
            Log.e(TAG, e.toString())
        }
    }

    override fun stop() {
        Log.d(TAG, "播放器stop")
        curUrl = ""
        isRenderFirstFrame = false
        isCompletion = false
        audioFocusHelper?.isUserPause = true
        ijkMediaPlayer?.stop()
        audioFocusHelper?.abandonFocus()
        isInnerChangeDecoder = false
    }

    override fun release() {
        Log.d(TAG, "播放器release")
        curUrl = ""
        isRenderFirstFrame = false
        isCompletion = false
        ijkMediaPlayer?.release()
        onPlayerListener?.onPlayerRelease()
        listeners.forEach {
            it.onPlayerRelease()
        }
        progressHandler.removeCallbacks(timerTask)
        handler?.removeCallbacks(timerTask)
        mainHandler.removeCallbacks(monitorNetTask)
        audioFocusHelper?.abandonFocus()
        clearSurface()
        isPrepare = false
        isInnerChangeDecoder = false
        TnPlayerManager.isMusicPlay = false
//        ijkMediaPlayer?.setIsCodecReused(0)
        ijkMediaPlayer?.setSurface(null)
    }

    override fun reset() {
        ijkMediaPlayer?.stop()
        ijkMediaPlayer?.reset()
        isRenderFirstFrame = false
//        ijkMediaPlayer?.clearScreen()
        audioFocusHelper?.abandonFocus()
        if (!isReset) {
            onPlayerListener?.onPlayerReset()
            listeners.forEach {
                it.onPlayerReset()
            }
        }
        isReset = true
        isPrepare = false
        isInnerChangeDecoder = false
    }

    override fun seekTo(mills: Long) {
        Log.d(TAG, "开始Seek到$mills")
        val totalSeconds = mills / 1000
        val hours = (totalSeconds / 3600).toInt()
        val remainSeconds = (totalSeconds % 3600).toInt()
        val miniutes = remainSeconds / 60
        val seconds = remainSeconds % 60

        val totalDuration = ijkMediaPlayer?.duration
        val totalSecondsDuration = totalDuration?.div(1000)
        val hoursDuration = (totalSecondsDuration?.div(3600))?.toInt()
        val remainSecondsDuration = (totalSecondsDuration?.rem(3600))?.toInt()
        val miniutesDuration = remainSecondsDuration?.div(60)
        val secondsDuration = remainSecondsDuration?.rem(60)

        Log.d(TAG, "视频的总时长是$totalDuration")
        Log.d(
            TAG,
            "视频的总时长是:小时:${hoursDuration}，分钟:$miniutesDuration,秒:$secondsDuration"
        )
        Log.d(TAG, "开始Seek到:小时:$hours，分钟:$miniutes,秒:$seconds")
        if (isPlaying()) {
            ijkMediaPlayer?.setOption(
                IjkMediaPlayer.OPT_CATEGORY_PLAYER,
                "enable-accurate-seek",
                1
            )
            Log.d(TAG, "开启精准seek")
        } else {
            ijkMediaPlayer?.setOption(
                IjkMediaPlayer.OPT_CATEGORY_PLAYER,
                "enable-accurate-seek",
                1
            )
//            Log.d("ijkplayer", "开启模糊seek")
            val progress = ijkMediaPlayer?.currentPosition ?: 0L
            Log.d(TAG, "进度$mills")
            listeners.forEach {
//                Log.d("ijkPlayer==", "current progress: =$progress")
                it.onProgress(mills, mediaSource)
            }
        }

        if (isCacheManagerEnabled == true) {
//            if (totalDuration != null) {
//                if (totalDuration > 0) {
//                    val percent: Float = mills * 1.0f / totalDuration
//                    Log.d(TAG, "seek的位置占视频的总时长的百分比是$percent")
//                    Log.d(TAG, "Seek 开启代理")
//                    VideoProxyCacheManager.getInstance().seekToCacheTaskFromClient(curUrl, percent)
//                }
//            }
        } else {
            Log.d(TAG, "Seek 未开启代理")
        }

        ijkMediaPlayer?.seekTo(mills)
        accurateSeekPosition = mills
        isSeekBegin = true
    }

    override fun getDuration(): Long {
        return ijkMediaPlayer?.duration ?: 0L
    }

    override fun isPlaying(): Boolean {
        return ijkMediaPlayer?.isPlaying == true
    }

    override fun isComplete(): Boolean {
        return isComplete
    }

    override fun setLooping(isLoop: Boolean) {
        ijkMediaPlayer?.isLooping = isLoop
    }

    override fun isMute(): Boolean {
        return false
    }

    override fun setVolume(volume: Float) {
//        Log.d("ijkPlayer", "setVolume   volume:$volume")
        ijkMediaPlayer?.setVolume(volume, volume)
        currentVolume = volume
    }

    override fun getVolume(): Float {
        return currentVolume
    }

    override fun setAutoPlay(isAutoPlay: Boolean) {
        this.isAutoPlay = isAutoPlay
    }


    override fun setMute(mute: Boolean) {
        this.mute = mute
        if (mute) {
            Log.d(TAG, "设置静音")
            ijkMediaPlayer?.setVolume(0.0f, 0.0f)
        } else {
            ijkMediaPlayer?.setVolume(0.5f, 0.5f)
        }
    }

    private fun initNewPlayer() {
        setMute(mute)
        volume?.let {
            setVolume(it)
        }
        setLooping(isLoop)
        setAutoPlay(isAutoPlay)
        setSpeed(speed)
        if (null != surfaceView) {
            setSurfaceView(surfaceView)
        }
        if (null != textureView) {
            setTextureView(textureView)
        }
        setScaleMode(scaleMode)
    }

    override fun enableHardwareDecoder(enable: Boolean) {
        if (enable.not() && curDecoderType == ORIjkDecoderType.HARDWARE) {
            //硬解切到软解
            ORPlayerLog.d(TAG, "1-硬解切到软解，重新创建设置", true)
            changeToSoftDecoder()
        } else if (enable && curDecoderType != ORIjkDecoderType.HARDWARE) {
            //软解切到硬解
            curDecoderType = ORIjkDecoderType.HARDWARE
            ORPlayerLog.d(TAG, "2-软解切换到硬解，重新创建设置", true)
            createPlayer(curDecoderType)
            initNewPlayer()
        }
    }

    private fun innerRelease() {
        isPrepare = false
        isCompletion = false
        isRenderFirstFrame = false
        Log.e(TAG, "innerRelease")
        if (TnPlayerPool.needReleasePlayer(this)) {
            ijkMediaPlayer?.release()
        } else {
            ijkMediaPlayer?.stop()
        }
    }

    override fun getCurrentPosition(): Long {
        return ijkMediaPlayer?.currentPosition ?: 0L
    }

    /**
     * 切换到软解
     * 需要重新创建新播放器
     */
    private fun changeToSoftDecoder(): MediaSource? {
        val curMediaSource = mediaSource
        // val curVideoMimeType = videoMimeType
        //切换编码，需要重新创建播放器，所以把之前的release掉
        innerRelease()
//        curDecoderType = when (curVideoMimeType) {
//            MimeTypes.VIDEO_AV1 -> {
//                ORExoDecoderType.AV1
//            }
//
//            else -> {//vp9设备就支持，其他类型的用ffmpeg基本可以支持
//                ORExoDecoderType.FFMPEG
//            }
//        }
        listeners.forEach { listener ->
            listener?.onLoadingBegin(mediaSource)
            Log.d(TAG, "切换播放器内核: 开始缓冲 监听回调")
        }

        curDecoderType = ORIjkDecoderType.FFMPEG
        ORPlayerLog.d(
            TAG,
            "重新创建播放器切换编码, DecoderType:$curDecoderType",
            true
        )
        createPlayer(curDecoderType)
        initNewPlayer()//重新创建播放器，配置需要重新设置
        return curMediaSource
    }

    override fun getBitrate(): Pair<Int, Int> {
        return Pair(0, 0)
    }

    override fun setSpeed(speed: Float) {
        this.speed = speed
        ijkMediaPlayer?.setSpeed(speed)
    }

    private var scaleMode: ScaleMode = ScaleMode.SCALE_TO_FILL
    override fun setScaleMode(scaleMode: ScaleMode) {
        super.setScaleMode(scaleMode)
        this.scaleMode = scaleMode
        val renderScaleMode: RenderScaleMode = when (scaleMode) {
            ScaleMode.SCALE_TO_FILL -> {
                Log.d(TAG, "执行了SCALE_TO_FILL")
                RenderScaleMode.SCREEN_SCALE_MATCH_PARENT
            }

            ScaleMode.SCALE_ASPECT_FIT -> {
                Log.d(TAG, "执行了SCALE_ASPECT_FIT")
                RenderScaleMode.SCREEN_SCALE_DEFAULT
            }

            ScaleMode.SCALE_ASPECT_FILL -> {
                Log.d(TAG, "执行了SCALE_ASPECT_FILL")
                RenderScaleMode.SCREEN_SCALE_CENTER_CROP
            }
        }
        textureView?.setScaleType(renderScaleMode)
        surfaceView?.setScaleType(renderScaleMode)
    }

    override fun currentMediaSource(): MediaSource? {
        return mediaSource
    }

    override fun setIsScreenUIChange(isScreenUIChange: Int) {
        this.isScreenUIChange = isScreenUIChange
        Log.d(TAG, "ijk触发横竖屏操作 $isScreenUIChange")
        if (this.isScreenUIChange == 1) {
            val isPlaying = ijkMediaPlayer?.isPlaying()
            if (isPlaying == true) {
                Log.d(TAG, "ijk触发横竖屏操作 且在播放中")
//                ijkMediaPlayer?.setIsCodecReused(1)
            } else {
                Log.d(TAG, "ijk触发横竖屏操作 但不在播放中")
            }
        }

        Log.d(TAG, "ijk触发横竖屏操作,是硬解：$isCodecHardCodec")
        if (isCodecHardCodec == true) {
//            val currentPotionS = ijkMediaPlayer?.currentPosition
//            ijkMediaPlayer?.seekTo(currentPotionS!!)
        }
    }

    private var currentPos: Long? = 0
    private var isTrackSelected: Boolean? = false
    private var audioTrackIds = IntArray(4)
    private var currentAudioTrackId: Int = 0

    private var selectedTrackIndex: Int = 0

    private val changeResolutionTask = Runnable {
        // 2. 设置选中的轨道
        // 第一个参数: 0表示视频轨道类型Ï
        // 第二个参数: 1表示选择指定轨道，0表示取消选择
        // 第三个参数: 要选择的轨道索引
        ijkMediaPlayer?.setOption(
            IjkMediaPlayer.OPT_CATEGORY_PLAYER,
            "mediacodec-track-selection",
            1
        )
        ijkMediaPlayer?.setOption(
            IjkMediaPlayer.OPT_CATEGORY_PLAYER,
            "track-select",
            "video=$selectedTrackIndex"
        )
        ijkMediaPlayer?.selectTrack(selectedTrackIndex)

        for (trackId in audioTrackIds) {
            if (trackId != currentAudioTrackId) {
                currentAudioTrackId = trackId
            }
        }
        Log.d(TAG, "需要selected音频 $currentAudioTrackId")
//        ijkMediaPlayer?.selectTrack(currentAudioTrackId)

//        currentPos = ijkMediaPlayer?.currentPosition
        Log.d(TAG, "切换分辨率后的postion:$currentPos")
//        if (currentPos != null) {
//            Log.d(TAG, "切换分辨率后 seek天到postion:$currentPos")
//            seekTo(currentPos!!)
//        }
        ijkMediaPlayer?.start()
    }

    //适用于单索引多分辨率的m3u8场景的API
    override fun changeTrackSelectionIJK(
        currentHeight: String,
        selectedHeight: String,
        heightsMap: Map<String, Int>
    ) {
        //切换分辨率需要重新创建解码器
//        ijkMediaPlayer?.setIsCodecReused(0)

        Log.d(TAG, "ijk播放器切换分辨率")

        Log.d(TAG, "ijk播放器当前的分辨率 $currentHeight")
        Log.d(TAG, "ijk播放器所有的分辨率 $heightsMap")
        Log.d(TAG, "ijk播放器新选的分辨率 $selectedHeight")
        listeners.forEach { listener ->
            listener?.onLoadingBegin(mediaSource)
            Log.d(TAG, "切换分辨率: 开始缓冲 监听回调")
            isChangeResolution = true
        }


        var heightsAllMap = heightsMap
        val currentHeights = currentHeight
//        var selectedTrackIndex: Int = 0
        var currentTrackIndex: Int = 0
        for (key in heightsAllMap.keys) {
            if (key.equals(selectedHeight)) {
                selectedTrackIndex = heightsAllMap[key]!!
                Log.d(TAG, "ijk播放器选中的index $selectedTrackIndex")
            }
        }

        for (key in heightsAllMap.keys) {
            if (key.equals(currentHeights)) {
                currentTrackIndex = heightsAllMap[key]!!
                Log.d(TAG, "ijk播放器当前的index $currentTrackIndex")
            }
        }

        // 1. 停止当前播放
//        ijkMediaPlayer?.pause()

//        ijkMediaPlayer?.stop()
        ijkMediaPlayer?.reset()
//        ijkMediaPlayer?.deselectTrack(currentTrackIndex)

        isTrackSelected = true
        ijkMediaPlayer?.setDataSource(context, curUrl.toUri(), null)
//        ijkMediaPlayer?.setNewVideoTrack(selectedTrackIndex)
        ijkMediaPlayer?.prepareAsync()


        // 2. 设置选中的轨道
        // 第一个参数: 0表示视频轨道类型Ï
        // 第二个参数: 1表示选择指定轨道，0表示取消选择
        // 第三个参数: 要选择的轨道索引
//        ijkMediaPlayer?.setOption(
//            IjkMediaPlayer.OPT_CATEGORY_PLAYER,
//            "mediacodec-track-selection",
//            1
//        )
//        ijkMediaPlayer?.setOption(
//            IjkMediaPlayer.OPT_CATEGORY_PLAYER,
//            "track-select",
//            "video=$selectedTrackIndex"
//        )
//        ijkMediaPlayer?.selectTrack(selectedTrackIndex)
//
//        for (trackId in audioTrackIds) {
//            if(trackId != currentAudioTrackId){
//                currentAudioTrackId = trackId
//            }
//        }
//        Log.d(TAG,"需要selected音频 $currentAudioTrackId" )
//        ijkMediaPlayer?.selectTrack(currentAudioTrackId)
//
//        currentPos = ijkMediaPlayer?.currentPosition
//        Log.d(TAG, "切换分辨率后的postion:$currentPos")
//        if (currentPos != null) {
//            Log.d(TAG, "切换分辨率后 seek天到postion:$currentPos")
//            seekTo(currentPos!!)
//        }
//        ijkMediaPlayer?.start()


        val mapCurrentHeight = mutableMapOf<String, Int>()
        mapCurrentHeight[selectedHeight] = selectedTrackIndex
        listeners.forEach { listener ->
            listener?.onTracksChangeIJK(allHeightMap, mapCurrentHeight)
        }
        listeners.forEach { listener ->
            listener?.onTracksChangeIJKEnd()
        }
    }
}