package com.transsion.player.mediasession

import android.app.PendingIntent
import android.content.Intent
import android.os.Parcelable
import androidx.annotation.Keep
import kotlinx.parcelize.Parcelize

/**
 * @author xinbing.zhang
 * @date :2023/9/25 12:55
 * @description: 封装当前播放的媒体的信息
 */
@Keep
@Parcelize
data class MediaItem(
    var title: String? = null,                          // 标题
    var subTitle: String? = null,                       // 副标题
    var coverUrl: String? = null,                       // 封面地址
    var duration: Long? = null,                         // 总时长
    var position: Long? = null,                         // 当前播放进度
    var state: String? = MUSIC_FLOAT_STATE_IDEA,        // 当前播放状态

    // 通知点击事件
    var pendingIntent: PendingIntent? = null, //下载对象，用于本地视频播放
    var clickIntent: Intent? = null, // 用于悬浮窗跳转到播放详情页

    var subjectId: String? = null,                      // 作品ID --> 调整详情页使用的
    var mediaId: String? = null,                        // 媒体唯一标识

    var isMusic: Boolean? = null, // 当前是否是Music

    var pageName: String? = "", // 音乐在哪个页面播放的
    var inBackground: Boolean? = false, // 当前是否在后台

    var ops: String? = null, // 操作

) : Parcelable {

    companion object {

        /**
         * 当前音乐播放器的状态
         */
        const val MUSIC_FLOAT_STATE_IDEA = "idea"
        const val MUSIC_FLOAT_STATE_COMPLETION = "completion"
        const val MUSIC_FLOAT_STATE_PLAY = "play"
        const val MUSIC_FLOAT_STATE_PAUSE = "pause"
        const val MUSIC_FLOAT_STATE_ERROR = "error"
    }
}
