package com.transsion.player.mediasession

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.view.KeyEvent
import com.transsion.player.orplayer.global.TnPlayerManager

/**
 * @author xinbing.zhang
 * @date :2023/9/21 19:21
 * @description: 媒体通知栏的按钮点击事件接收
 *
 * 13以下通知栏点击事件走的是广播，13以上走的是控制器的回调
 */
class MusicIntentReceiver : BroadcastReceiver() {

    private fun getClassTag(): String = javaClass.simpleName

    override fun onReceive(context: Context, intent: Intent) {
        kotlin.runCatching {
            when (intent.action) {
                Intent.ACTION_MEDIA_BUTTON -> {
                    ((intent.extras?.get(Intent.EXTRA_KEY_EVENT)) as? KeyEvent)?.let {
                        SessionLogger.log("${getClassTag()} --> onReceive --> 接收到通知点击事件, = ${it}, ${it.keyCode}")
                        it.let {
                            when (it.keyCode) {
                                KeyEvent.KEYCODE_MEDIA_PAUSE -> TnPlayerManager.currentFocusPlayer?.pause()
                                KeyEvent.KEYCODE_MEDIA_PLAY -> TnPlayerManager.currentFocusPlayer?.play()
                                KeyEvent.KEYCODE_MEDIA_NEXT -> MediaBrowserCompatHelper.instance.skipToNext()
                                KeyEvent.KEYCODE_MEDIA_PREVIOUS -> MediaBrowserCompatHelper.instance.skipToPrevious()
                                KeyEvent.KEYCODE_MEDIA_STOP -> TnPlayerManager.currentFocusPlayer?.stop()
                                else -> {
                                    // 什么都处理
                                }
                            }
                        }
                    }
                }

//                PLAYER_NOTIFICATION_ACTION_PLAY_PAUSE -> {
//                    SessionLogger.log("intent.action == PLAYER_NOTIFICATION_ACTION_PLAY_PAUSE")
//                    TnPlayerManager.currentFocusPlayer?.let {
//                        if (it.isPlaying()) {
//                            it.pause()
//                        } else {
//                            it.play()
//                        }
//                    }
//                }

                else -> {
                    //
                }
            }
        }.getOrElse {
            SessionLogger.log("${getClassTag()} --> onReceive --> 接收到通知点击事件 --- it = $it")
        }
    }

}