package com.transsion.player.mediasession

import android.annotation.SuppressLint
import android.app.PendingIntent
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Build
import com.blankj.utilcode.util.Utils
import com.transsion.player.orplayer.global.TnPlayerManager

/**
 * @author: zhangxinbing
 * @date : 2024/10/17 15:49
 * @description: 通知事件
 */
class MusicNotificationBroadcastReceiver : BroadcastReceiver() {

    companion object {

        /**
         * 通知点击事件的广播Action
         */
        private const val MUSIC_NOTIFICATION_ACTION_DELETE_INTENT =
            "com.transsion.player.mediasession.NotificationUtil.DeleteIntent"

        @SuppressLint("UnspecifiedRegisterReceiverFlag")
        fun register() {
            // 创建广播接收器实例
            val receiver = MusicNotificationBroadcastReceiver()
            // 创建过滤器，定义接收的广播类型
            val filter = IntentFilter(this.MUSIC_NOTIFICATION_ACTION_DELETE_INTENT)
            // 注册接收器
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                Utils.getApp().registerReceiver(receiver, filter, Context.RECEIVER_NOT_EXPORTED)
            } else {
                Utils.getApp().registerReceiver(receiver, filter)
            }
        }

        fun getDeleteIntent(): PendingIntent {
            val broadcastIntent =
                Intent(Utils.getApp(), MusicNotificationBroadcastReceiver::class.java)
            broadcastIntent.action = this.MUSIC_NOTIFICATION_ACTION_DELETE_INTENT
            val pendingIntent = PendingIntent.getBroadcast(
                Utils.getApp(),
                0,
                broadcastIntent,
                PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE
            )
            return pendingIntent
        }

    }


    // =============================================================================================


    override fun onReceive(context: Context, intent: Intent?) {
        when (intent?.action) {
            MUSIC_NOTIFICATION_ACTION_DELETE_INTENT -> {
                TnPlayerManager.currentFocusPlayer?.release()
                MediaNotification.isCreate = false
            }
        }
    }

}