package com.transsion.player.orplayer.global

import android.view.SurfaceView
import android.view.TextureView
import com.transsion.player.MediaSource
import com.transsion.player.config.VodConfig
import com.transsion.player.enum.ScaleMode
import com.transsion.player.orplayer.IPlayerListener
import com.transsion.player.orplayer.ORPlayer
import com.transsion.player.tracks.TnFormat
import com.transsion.player.tracks.TnTracks
import com.transsion.player.tracks.TnTracksGroup
import java.util.concurrent.CopyOnWriteArrayList

/**
 * 单播放器
 */
class TnSingleInstancePlayer : ORPlayer {
    companion object {
        const val TAG = "TnPlayerProxy"
    }

    @Volatile
    var mOrPlayer: ORPlayer? = null

    @Volatile
    private var mediaSource: MediaSource? = null


    private var surfaceView: SurfaceView? = null
    private var textureView: TextureView? = null
    private var listener: IPlayerListener? = null
    private var listeners: CopyOnWriteArrayList<IPlayerListener> = CopyOnWriteArrayList()

    private var volume: Float? = null
    private var isAutoPlay: Boolean = false
    private var isLoop: Boolean = false
    private var vodConfig: VodConfig? = null
    private var mute:  Boolean = false
    private var enableHardwareDecoder: Boolean = true
    private var speed: Float = 1f
    private var scaleMode: ScaleMode = ScaleMode.SCALE_ASPECT_FIT

    override fun setSurfaceView(surfaceView: SurfaceView?) {
        this.textureView = null
        this.surfaceView = surfaceView
        mOrPlayer?.setSurfaceView(surfaceView)
    }

    override fun setTextureView(textureView: TextureView?) {
        this.surfaceView = null
        this.textureView = textureView
        mOrPlayer?.setTextureView(textureView)
    }

    override fun clearSurfaceOnly() {
        mOrPlayer?.clearSurfaceOnly()
        surfaceView = null
        textureView = null
    }

    override fun setPlayerListener(listener: IPlayerListener) {
        this.listener = listener
        mOrPlayer?.setPlayerListener(listener)
    }

    override fun addPlayerListener(listener: IPlayerListener) {
        if (listeners.contains(listener).not()) {
            listeners.add(listener)
            mOrPlayer?.addPlayerListener(listener)
        }
    }

    override fun removePlayerListener(listener: IPlayerListener) {
        listeners.remove(listener)
        mOrPlayer?.removePlayerListener(listener)
    }

    override fun setDataSource(mediaSource: MediaSource) {
        this.mediaSource = mediaSource
        mOrPlayer?.let { player ->
            TnPlayerManager.requestFocus(player, "setDataSource")
        }
        if (requestForce().not()){
            mOrPlayer?.setDataSource(mediaSource)
        }
    }


    override fun prepare() {
        mOrPlayer?.prepare()
    }

    override fun play() {
        TnPlayerManager.play(this, mediaSource)
        mOrPlayer?.let { player ->
            TnPlayerManager.requestFocus(player, "play")
        }
        mOrPlayer?.play()
    }

    override fun pause() {
        TnPlayerManager.pause(this, mediaSource)
        mOrPlayer?.pause()
    }

    override fun stop() {
        mOrPlayer?.stop()
    }

    override fun release() {
        mOrPlayer?.release()
        this.mOrPlayer = null
        this.listener = null
        this.surfaceView = null
        this.textureView = null
        TnPlayerManager.releaseFocus(this)
    }

    override fun release(id: String?) {
        if (id.isNullOrEmpty().not() && mediaSource?.id != id) return//当前视频才release
        release()
    }

    override fun reset() {
        mOrPlayer?.reset()
    }

    override fun clearScreen() {
        mOrPlayer?.clearScreen()
    }

    override fun seekTo(mills: Long) {
        mOrPlayer?.seekTo(mills)
        mediaSource?.mediaItem?.position= mills
        TnPlayerManager.seekTo(this, mediaSource)
    }

    override fun seekTo(uuid: String, mills: Long) {
        mOrPlayer?.seekTo(uuid, mills)
    }

    override fun getDuration(): Long {
        return mOrPlayer?.getDuration() ?: 0
    }

    override fun isPlaying(): Boolean {
        return mOrPlayer?.isPlaying() ?: false
    }

    override fun isComplete(): Boolean {
        return mOrPlayer?.isComplete() ?: false
    }

    override fun setLooping(isLoop: Boolean) {
        this.isLoop = isLoop
        mOrPlayer?.setLooping(isLoop)
    }

    override fun isMute(): Boolean {
        return mOrPlayer?.isMute() ?: false
    }

    override fun setVolume(volume: Float) {
        this.volume = volume
        mOrPlayer?.setVolume(volume)
    }

    override fun getVolume(): Float? {
        return mOrPlayer?.getVolume()
    }

    override fun setAutoPlay(isAutoPlay: Boolean) {
        this.isAutoPlay = isAutoPlay
        mOrPlayer?.setAutoPlay(isAutoPlay)
    }

    override fun enableHardwareDecoder(enable: Boolean) {
        this.enableHardwareDecoder = enable
        mOrPlayer?.enableHardwareDecoder(enable)
    }


    override fun getDownloadBitrate(): Any? {
        return mOrPlayer?.getDownloadBitrate()
    }

    override fun setPlayerConfig(vodConfig: VodConfig) {
        this.vodConfig = vodConfig
        mOrPlayer?.setPlayerConfig(vodConfig)
    }

    /**
     * @return false：焦点已获取， true:重新获得焦点，注意要重新prepare
     */
    override fun requestForce(): Boolean {
        if (null == mOrPlayer) {
            TnPlayerManager.requestForce(this)
            mOrPlayer?.let{player->
                val action: () -> Unit =  {
                    mOrPlayer?.let { player ->
                        player.stop()
                        player.reset()
                        player.enableHardwareDecoder(enableHardwareDecoder)

                        vodConfig?.let {
                            player.setPlayerConfig(it)
                        }
                        player.setMute(mute)
                        volume?.let {
                            player.setVolume(it)
                        }

                        player.setSpeed(speed)
                        player.setLooping(isLoop)
                        player.setAutoPlay(isAutoPlay)
                        if (surfaceView != null){
                            player.setSurfaceView(surfaceView)
                        }
                        if (textureView != null){
                            player.setTextureView(textureView)
                        }
                        listener?.let {
                            player.setPlayerListener(it)
                        }
                        listeners.forEach { listener ->
                            player.addPlayerListener(listener)
                        }
                        player.setScaleMode(scaleMode)
                        mediaSource?.let {
                            player.setDataSource(it)
                        }
                    }

                }
                if (player is TnAliPlayer) {
                    player.runOnPlayerThread(action)
                }else{
                    action.invoke()
                }
            }

            return true
        }
        return false
    }

    override fun setMute(mute: Boolean) {
        this.mute = mute
        mOrPlayer?.setMute(mute)
    }

    override fun isLoading(): Boolean {
        return mOrPlayer?.isLoading() ?: super.isLoading()
    }

    override fun getVideoWidth(): Int {
        return mOrPlayer?.getVideoWidth() ?: super.getVideoWidth()
    }

    override fun getVideoHeight(): Int {
        return mOrPlayer?.getVideoHeight() ?: super.getVideoHeight()
    }

    override fun isPrepared(): Boolean {
        return mOrPlayer?.isPrepared() ?: super.isPrepared()
    }

    override fun getBitrate() = mOrPlayer?.getBitrate() ?: Pair(0, 0)

    override fun setSpeed(speed: Float) {
        this.speed = speed
        mOrPlayer?.setSpeed(speed)
    }

    override fun setScaleMode(scaleMode: ScaleMode) {
        this.scaleMode = scaleMode
        mOrPlayer?.setScaleMode(scaleMode)
    }


    override fun getCurrentTracks(): TnTracks? {
        return mOrPlayer?.getCurrentTracks()
    }

    override fun getCurrentPosition(): Long {
        return mOrPlayer?.getCurrentPosition() ?: 0L
    }

    override fun getCurrentVideoFormat(): TnFormat? {
        return mOrPlayer?.getCurrentVideoFormat()
    }

    override fun changeTrackSelection(mediaTrackGroup: TnTracksGroup, index: Int) {
        mOrPlayer?.changeTrackSelection(mediaTrackGroup, index)
    }

    override fun changeTrackSelectionIJK(
        currentHeight: String,
        selectedHeight: String,
        heightsMap: Map<String, Int>
    ) {
        mOrPlayer?.changeTrackSelectionIJK(currentHeight, selectedHeight, heightsMap)
    }

    override fun setIsScreenUIChange(isScreenUIChange: Int) {
        mOrPlayer?.setIsScreenUIChange(isScreenUIChange)
    }


    fun onLossFocus(focusLoss: Boolean) {
        listener?.onFocusChange(focusLoss)
    }

    override fun currentMediaSource(): MediaSource? {
        return mediaSource
    }

}