package com.transsion.player.tracks


data class TnFormat(
    /** An identifier for the format, or null if unknown or not applicable.  */
    val id: String? = null,

    /** The human readable label, or null if unknown or not applicable.  */
    val label: String? = null,

    /** The language as an IETF BCP 47 conformant tag, or null if unknown or not applicable.  */
    val language: String? = null,

    /** Track selection flags.  */
    val selectionFlags: @TnSelectionFlags Int = 0,


    /**
     * The average bitrate in bits per second, or [.NO_VALUE] if unknown or not applicable. The
     * way in which this field is populated depends on the type of media to which the format
     * corresponds:
     *
     *
     *  * DASH representations: Always [Format.NO_VALUE].
     *  * HLS variants: The `AVERAGE-BANDWIDTH` attribute defined on the corresponding `EXT-X-STREAM-INF` tag in the multivariant playlist, or [Format.NO_VALUE] if not
     * present.
     *  * SmoothStreaming track elements: The `Bitrate` attribute defined on the
     * corresponding `TrackElement` in the manifest, or [Format.NO_VALUE] if not
     * present.
     *  * Progressive container formats: Often [Format.NO_VALUE], but may be populated with
     * the average bitrate of the container if known.
     *  * Sample formats: Often [Format.NO_VALUE], but may be populated with the average
     * bitrate of the stream of samples with type [.sampleMimeType] if known. Note that if
     * [.sampleMimeType] is a compressed format (e.g., [MimeTypes.AUDIO_AAC]), then
     * this bitrate is for the stream of still compressed samples.
     *
     */
    val averageBitrate: Int = 0,

    /**
     * The peak bitrate in bits per second, or [.NO_VALUE] if unknown or not applicable. The way
     * in which this field is populated depends on the type of media to which the format corresponds:
     *
     *
     *  * DASH representations: The `@bandwidth` attribute of the corresponding `Representation` element in the manifest.
     *  * HLS variants: The `BANDWIDTH` attribute defined on the corresponding `EXT-X-STREAM-INF` tag.
     *  * SmoothStreaming track elements: Always [Format.NO_VALUE].
     *  * Progressive container formats: Often [Format.NO_VALUE], but may be populated with
     * the peak bitrate of the container if known.
     *  * Sample formats: Often [Format.NO_VALUE], but may be populated with the peak bitrate
     * of the stream of samples with type [.sampleMimeType] if known. Note that if [       ][.sampleMimeType] is a compressed format (e.g., [MimeTypes.AUDIO_AAC]), then this
     * bitrate is for the stream of still compressed samples.
     *
     */
    val peakBitrate: Int = 0,

    /**
     * The bitrate in bits per second. This is the peak bitrate if known, or else the average bitrate
     * if known, or else [Format.NO_VALUE]. Equivalent to: `peakBitrate != NO_VALUE ?
     * peakBitrate : averageBitrate`.
     */
    val bitrate: Int = 0,

    /** Codecs of the format as described in RFC 6381, or null if unknown or not applicable.  */
    val codecs: String? = null,


    // Video specific.
    /** The width of the video in pixels, or [.NO_VALUE] if unknown or not applicable.  */
    val width: Int = 0,

    /** The height of the video in pixels, or [.NO_VALUE] if unknown or not applicable.  */
    val height: Int = 0,

    /** The frame rate in frames per second, or [.NO_VALUE] if unknown or not applicable.  */
    val frameRate: Float = 0f,

    /**
     * The clockwise rotation that should be applied to the video for it to be rendered in the correct
     * orientation, or 0 if unknown or not applicable. Only 0, 90, 180 and 270 are supported.
     */
    val rotationDegrees: Int = 0,

    /** The width to height ratio of pixels in the video, or 1.0 if unknown or not applicable.  */
    val pixelWidthHeightRatio: Float = 0f


)