package com.transsion.player.ui

import android.content.Context
import android.graphics.Color
import android.util.AttributeSet
import android.view.Gravity
import android.view.SurfaceView
import android.view.TextureView
import android.view.ViewGroup
import android.widget.FrameLayout
import com.transsion.player.config.ORPlayerConfig
import com.transsion.player.config.RenderType
import com.transsion.player.ui.render.SurfaceRenderView
import com.transsion.player.ui.render.TextureRenderView

/**
 * @author xugaopan
 * @date 2022/8/9
 */
class ORPlayerView : FrameLayout {

    private var textureView: TextureRenderView? = null
    private var surfaceView: SurfaceRenderView? = null

    constructor(context: Context) : this(context, null)
    constructor(context: Context, renderType: RenderType?) : this(context, null,renderType)
    constructor(context: Context, attrs: AttributeSet?, renderType: RenderType?) : this(context, attrs, 0,renderType)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int, renderType: RenderType?) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        setBackgroundColor(Color.parseColor("#FF000000"))
        val layoutParams = LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT
        )
        layoutParams.gravity = Gravity.CENTER
        when (renderType) {//增加局部设置render
            RenderType.SURFACE_VIEW -> {
                surfaceView = SurfaceRenderView(context)
                addView(surfaceView, layoutParams)
            }
            RenderType.TEXTURE_VIEW -> {
                textureView = TextureRenderView(context)
                addView(textureView, layoutParams)
            }
            else -> {
                if (ORPlayerConfig.isUsingSurfaceView()) {
                    surfaceView = SurfaceRenderView(context)
                    addView(surfaceView, layoutParams)
                } else {
                    textureView = TextureRenderView(context)
                    addView(textureView, layoutParams)
                }
            }
        }
    }

    fun updateSurface(lp: ViewGroup.LayoutParams) {
        if (ORPlayerConfig.isUsingSurfaceView()) {
            surfaceView?.layoutParams = lp
        } else {
            textureView?.layoutParams = lp
        }

    }

    fun getSurface():SurfaceView?{
        return surfaceView
    }

    fun getTextureView():TextureView?{
        return textureView
    }


}