package com.transsion.player.ui.render

import android.graphics.Bitmap
import android.view.View

interface IRenderView {

    fun getView(): View

    /**
     * 设置视频宽高
     * @param videoWidth 宽
     * @param videoHeight 高
     */
    fun setVideoSize(videoWidth: Int, videoHeight: Int)

    /**
     * 设置视频旋转角度
     * @param degree 角度值
     */
    fun setVideoRotation(degree: Int)

    /**
     * 设置screen scale type
     * @param scaleType 类型
     */
    fun setScaleType(scaleType: RenderScaleMode)

    /**
     * 截图
     */
    fun doScreenShot(): Bitmap?

    /**
     * 释放资源
     */
    fun release()
}